/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.zkbridge;

import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.preferences.EnvironmentPreferences;
import com.ez.eclient.service.database.DatabaseService;
import com.ez.eclient.zkbridge.LogUtil;
import com.ez.eclient.zkbridge.ProjectConnectionFactoryNull;
import com.ez.eclient.zkbridge.internal.Messages;
import com.ez.ezsource.connection.EZSourceConnectionFactory;
import com.ez.ezsource.connection.EZSourceFactoryProvider;
import com.ez.ezsource.connection.zkbridge.ProjectConnectionFactory;
import com.ez.ezsource.connection.zkbridge.SessionInfo;
import com.ez.ezsource.connection.zkbridge.SessionInfoBuilder;
import com.ez.internal.model.IMFProjectsServiceFacade;
import com.ez.internal.utils.PreferencesUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.keeper.client.ZkSessionFactory;
import com.sun.jna.platform.win32.Netapi32Util;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConnectionFactoryProvider
implements EZSourceFactoryProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectConnectionFactoryProvider.class);
    private static final String OS = System.getProperty("os.name").toLowerCase();

    public EZSourceConnectionFactory createFactory(Properties properties) {
        UUID eid = null;
        ProjectConnectionFactoryNull cf = null;
        String reason = null;
        try {
            Integer applicationId = Integer.valueOf(properties.getProperty("applicationId"));
            UUID sessionId = UUID.fromString(properties.getProperty("instanceSid"));
            BaseConfiguration config = new BaseConfiguration();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                config.setProperty((String)e.getKey(), (Object)((String)e.getValue()));
            }
            config.setProperty("applicationId", (Object)applicationId);
            config.setProperty("instanceSid", (Object)sessionId);
            if (System.getProperty("DISABLE_CCS_SESSION") == null) {
                L.info("CCS session enabled.");
                String applicationName = applicationId == 3 ? "Application Discovery Analyze" : (applicationId == 11 ? "Application Discovery Integration Service" : null);
                config.setProperty("sessionInfo", (Object)this.buildSessionInfo(sessionId, applicationId, applicationName));
            } else {
                L.info("CCS session disabled.");
            }
            ZkSessionFactory sf = this.getSessionFactory();
            if (sf == null) {
                String msg = "Session factory for configuration server not found, projects list will not be available.";
                L.warn(msg);
                LogUtil.log(4, Messages.getString(ProjectConnectionFactoryProvider.class, "log.error.server.not.found"));
            }
            if (sf != null) {
                eid = this.getEnvironmentId();
            }
            if (eid != null) {
                config.setProperty("environmentId", (Object)eid);
                DatabaseService dbServ = (DatabaseService)ServiceUtils.getService(DatabaseService.class);
                config.setProperty("databaseService", (Object)dbServ);
                IMFProjectsServiceFacade projServ = (IMFProjectsServiceFacade)ServiceUtils.getService(IMFProjectsServiceFacade.class);
                if (projServ != null) {
                    config.setProperty("mfProjectsService", (Object)projServ);
                } else {
                    L.error("mf projects service is null!");
                }
                cf = new ProjectConnectionFactory(sf, (Configuration)config);
            } else {
                reason = "current environment not set";
            }
        }
        catch (Exception ex) {
            L.error("", (Throwable)ex);
            reason = "internal error";
        }
        if (cf == null) {
            cf = new ProjectConnectionFactoryNull(reason);
        }
        return cf;
    }

    private UUID getEnvironmentId() {
        UUID uid = null;
        Environment e = EnvironmentPreferences.getEnvironment();
        if (e == null) {
            String msg = "Environment not set, projects list will not be available.";
            L.warn(msg);
            LogUtil.log(4, Messages.getString(ProjectConnectionFactoryProvider.class, "log.error.environment.not.set"));
        } else {
            String id = e.getId();
            try {
                uid = UUID.fromString(id);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                L.error("", (Object)e);
            }
            if (id == null) {
                String msg = "Environment id not set / invalid, projects list will not be available.";
                L.warn(msg);
                LogUtil.log(4, Messages.getString(ProjectConnectionFactoryProvider.class, "log.error.id.invalid"));
            }
        }
        return uid;
    }

    private ZkSessionFactory getSessionFactory() {
        ZkSessionFactory f = null;
        BundleContext bundleContext = Platform.getBundle((String)"com.ez.workspace").getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(ZkSessionFactory.class);
        if (ref == null) {
            L.error("Can't get reference to {}", ZkSessionFactory.class);
        } else {
            f = (ZkSessionFactory)bundleContext.getService(ref);
        }
        if (f == null) {
            String msg = "Session factory for configuration server not found, projects list will not be available.";
            L.warn(msg);
            LogUtil.log(4, Messages.getString(ProjectConnectionFactoryProvider.class, "log.error.server.not.found"));
        }
        return f;
    }

    private SessionInfo buildSessionInfo(UUID sessionId, Integer applicationId, String applicationName) {
        String host = null;
        SessionInfoBuilder sib = SessionInfoBuilder.newBuilder((UUID)sessionId);
        AboutMe me = null;
        try {
            host = PreferencesUtils.manageClientIP();
        }
        catch (Exception ex) {
            L.error("", (Throwable)ex);
        }
        if (host != null) {
            sib.setHost(host);
        }
        sib.setApplicationId(applicationId);
        sib.setApplicationName(applicationName);
        try {
            me = this.whoAmI();
        }
        catch (Exception ex) {
            L.error("", (Throwable)ex);
        }
        if (me != null) {
            sib.setUsername(me.name);
            sib.setDomain(me.domain);
        }
        return sib.build();
    }

    private AboutMe whoAmI() {
        String domain = null;
        String user = null;
        L.debug("OS: {}", (Object)OS);
        user = System.getProperty("user.name");
        if (user == null) {
            throw new RuntimeException("Can't read system property user.name");
        }
        L.debug("Username: {}", (Object)user);
        if (domain == null && OS.contains("win")) {
            L.debug("Finding domain name...");
            try {
                Netapi32Util.DomainController dc = Netapi32Util.getDC();
                if (dc != null) {
                    domain = dc.domainName;
                    L.debug("Domain found: {}", (Object)domain);
                }
            }
            catch (Throwable ex) {
                L.warn("Error when finding domain for user: {}", (Object)user, (Object)ex);
            }
        }
        return new AboutMe(user, domain);
    }

    private class AboutMe {
        String name;
        String domain;

        AboutMe(String name, String domain) {
            this.name = name;
            this.domain = domain;
        }
    }
}

