/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.analysis.view;

import com.ez.ann.analysis.internal.Messages;
import com.ez.internal.utils.Triplet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ResTypeDialog
extends Dialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    Map<Triplet<String, String, Integer>, List<Triplet<Integer, String, String>>> types;
    private ArrayList<Button> typeButtons = null;
    private Set<Triplet<Integer, String, String>> selection = new TreeSet<Triplet<Integer, String, String>>(new ResTypeComparator());
    private Collection<Triplet<Integer, String, String>> initSelection;

    public ResTypeDialog(Shell parentShell, Map<Triplet<String, String, Integer>, List<Triplet<Integer, String, String>>> resTypes, Collection<Triplet<Integer, String, String>> initialSelection) {
        super(parentShell);
        this.types = resTypes;
        this.initSelection = initialSelection;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString(ResTypeDialog.class, "shell.name.text"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginTop = 5;
        gl.marginBottom = 5;
        gl.marginLeft = 5;
        gl.marginRight = 5;
        container.setLayout((Layout)gl);
        ArrayList<Triplet<String, String, Integer>> tmp = new ArrayList<Triplet<String, String, Integer>>(this.types.keySet());
        Collections.sort(tmp, new Comparator<Triplet<String, String, Integer>>(){

            @Override
            public int compare(Triplet<String, String, Integer> arg0, Triplet<String, String, Integer> arg1) {
                return ((Integer)arg0.getThird()).compareTo((Integer)arg1.getThird());
            }
        });
        for (Triplet triplet : tmp) {
            Group keyGroup = new Group(container, 0);
            GridData gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 1;
            keyGroup.setLayoutData((Object)gd);
            gl = new GridLayout();
            gl.numColumns = this.types.get(triplet).size() / 10 + 1;
            keyGroup.setLayout((Layout)gl);
            keyGroup.setText((String)triplet.getSecond());
            Collections.sort(this.types.get(triplet), new Comparator<Triplet<Integer, String, String>>(){

                @Override
                public int compare(Triplet<Integer, String, String> o1, Triplet<Integer, String, String> o2) {
                    return ((String)o1.getSecond()).compareTo((String)o2.getSecond());
                }
            });
            for (Triplet<Integer, String, String> type : this.types.get(triplet)) {
                final Button keyButton = new Button((Composite)keyGroup, 32);
                keyButton.setText((String)type.getSecond());
                keyButton.setData(type);
                if (this.initSelection != null) {
                    boolean selected = this.initSelection.contains(type);
                    keyButton.setSelection(selected);
                    if (selected) {
                        this.selection.add((Triplet<Integer, String, String>)((Triplet)keyButton.getData()));
                    }
                }
                if (this.typeButtons == null) {
                    this.typeButtons = new ArrayList();
                }
                this.typeButtons.add(keyButton);
                keyButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        Triplet btnData = (Triplet)keyButton.getData();
                        if (keyButton.getSelection()) {
                            ResTypeDialog.this.selection.add(btnData);
                        } else {
                            ResTypeDialog.this.selection.remove(btnData);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                gd = new GridData(1, 2, false, false);
                keyButton.setLayoutData((Object)gd);
            }
        }
        return container;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 131072, true, false));
        Button selectAll = this.createButton(parent, 4, Messages.getString(ResTypeDialog.class, "selectAll.text"), false);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Button program : ResTypeDialog.this.typeButtons) {
                    program.setSelection(true);
                    ResTypeDialog.this.selection.add((Triplet)program.getData());
                }
            }
        });
        Button selectNone = this.createButton(parent, 3, Messages.getString(ResTypeDialog.class, "selectNone.text"), false);
        selectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Button program : ResTypeDialog.this.typeButtons) {
                    program.setSelection(false);
                }
                ResTypeDialog.this.selection.clear();
            }
        });
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button cancelButton = this.createButton(parent, 1, Messages.getString(ResTypeDialog.class, "cancel.text"), false);
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ResTypeDialog.this.selection.clear();
                ResTypeDialog.this.cancelPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button okButton = this.createButton(parent, 0, Messages.getString(ResTypeDialog.class, "ok.text"), true);
        okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ResTypeDialog.this.okPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
    }

    protected List<Triplet<Integer, String, String>> getResourceType() {
        return new ArrayList<Triplet<Integer, String, String>>(this.selection);
    }

    protected boolean isResizable() {
        return true;
    }

    private class ResTypeComparator
    implements Comparator<Triplet<Integer, String, String>> {
        private ResTypeComparator() {
        }

        @Override
        public int compare(Triplet<Integer, String, String> o1, Triplet<Integer, String, String> o2) {
            return ((String)o1.getSecond()).compareTo((String)o2.getSecond());
        }
    }
}

