/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.analysis.view;

import com.ez.ann.analysis.internal.Activator;
import com.ez.ann.analysis.internal.Messages;
import com.ez.ann.db.EZAnnotationDbManager;
import com.ez.ann.model.EZKeyword;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.internal.utils.LogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysDialog
extends Dialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(KeysDialog.class);
    private Map<String, EZKeyword> avKeywordMap = null;
    private List avList = null;
    private ArrayList<EZKeyword> selKeywords = null;
    private String[] keywordsNames = null;
    private Collection<EZKeyword> prevSelected = null;

    public KeysDialog(Shell parentShell, Collection<EZKeyword> selected) {
        super(parentShell);
        this.prevSelected = selected;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString(KeysDialog.class, "shell.name.text"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 5;
        gridLayout.marginBottom = 5;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        Composite keywordsComposite = new Composite(container, 2064);
        gridLayout = new GridLayout();
        gridLayout.marginTop = 5;
        gridLayout.marginBottom = 5;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        gridLayout.numColumns = 1;
        keywordsComposite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        keywordsComposite.setLayoutData((Object)gd);
        this.avList = new List(keywordsComposite, 66050);
        gd = new GridData(4, 4, true, true);
        this.avList.setLayoutData((Object)gd);
        this.fillUI();
        this.avList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnClean = new Button(container, 8);
        btnClean.setText(Messages.getString(KeysDialog.class, "clear.text"));
        btnClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeysDialog.this.avList.deselectAll();
            }
        });
        return container;
    }

    private void fillUI() {
        Set allKeySt = null;
        try {
            allKeySt = EZAnnotationDbManager.getInstance().getAllKeywords((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            L.error("error getting all keywords", (Throwable)ex);
            LogUtil.displayErrorMessage((Throwable)ex, (String)EZAnnotationDbManager.GET_KEYWORDS_ERROR, (Plugin)Activator.getDefault(), (boolean)false);
        }
        if (allKeySt != null && allKeySt.size() > 0) {
            String[] allKeys = new String[allKeySt.size()];
            ArrayList tmp = new ArrayList(allKeySt);
            Collections.sort(tmp);
            int i = 0;
            int[] selection = this.prevSelected != null ? new int[this.prevSelected.size()] : new int[]{};
            int s = 0;
            for (EZKeyword key : tmp) {
                if (this.prevSelected != null && this.prevSelected.contains(key)) {
                    selection[s] = i;
                    ++s;
                }
                if (this.avKeywordMap == null) {
                    this.avKeywordMap = new HashMap<String, EZKeyword>();
                }
                allKeys[i++] = key.getName();
                this.avKeywordMap.put(key.getName(), key);
            }
            this.avList.setItems(allKeys);
            this.avList.setSelection(selection);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button ok = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        ok.setText(Messages.getString(KeysDialog.class, "ok.text"));
        Button cancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        cancel.setText(Messages.getString(KeysDialog.class, "cancel.text"));
    }

    protected void okPressed() {
        this.keywordsNames = this.avList.getSelection();
        if (this.selKeywords == null) {
            this.selKeywords = new ArrayList();
        }
        String[] stringArray = this.keywordsNames;
        int n = this.keywordsNames.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            EZKeyword ezKey = this.avKeywordMap.get(key);
            this.selKeywords.add(ezKey);
            ++n2;
        }
        super.okPressed();
    }

    public ArrayList<EZKeyword> getKeysSelected() {
        return this.selKeywords;
    }

    protected Point getInitialSize() {
        return new Point(DpiScaler.getScaledSize((int)300), DpiScaler.getScaledSize((int)350));
    }

    protected boolean isResizable() {
        return true;
    }
}

