/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.analysis.view;

import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.ann.analysis.gui.AddAnnDialog;
import com.ez.ann.analysis.internal.Activator;
import com.ez.ann.analysis.internal.Messages;
import com.ez.ann.analysis.view.FindAnnDescriptor;
import com.ez.ann.analysis.view.KeysDialog;
import com.ez.ann.analysis.view.ResTypeDialog;
import com.ez.ann.db.EZAnnotationDbManager;
import com.ez.ann.db.ResourceCriteria;
import com.ez.ann.db.ResourceIdentificator;
import com.ez.ann.model.AnnResource;
import com.ez.ann.model.Constants;
import com.ez.ann.model.EZAnnotation;
import com.ez.ann.model.EZKeyword;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZJobInputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.ProjectsListWrapper;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.audit.IAudit;
import com.ez.workspace.analysis.graph.ExecExportStatus;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDBSegmentIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceSQLFieldTableIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import com.ez.workspace.state.AEvent;
import com.ez.workspace.state.EZAnnotationEvent;
import com.ez.workspace.state.EventType;
import com.ez.workspace.state.StateManager;
import java.io.File;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindAnnViewer
implements IResultViewer,
IAudit {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FindAnnViewer.class);
    private static final String DELETE_ANNOTATION_IMG_KEY = "deleteAnnotation";
    private static final String EDIT_ANNOTATION_IMG_KEY = "editAnnotation";
    private static final String SHOW_FILTERS_AREA_KEY = "show filters area";
    private static final String FILTERS_COLLAPSED_IMG_KEY = "filtersCollapsed";
    private static final String FILTERS_EXPANDED_IMG_KEY = "filtersExpanded";
    private static final String EXPORT_RESULTS_AREA_IMG_KEY = "exportResults";
    private static final String EXPORT_RESULTS_DISABLED_IMG_KEY = "exportResultsDIsabled";
    private static final String RESULTS_KEY = "annotationsResults";
    private static final String SEARCH_CRITERIA_KEY = "searchCriteria";
    private static final String HIDE_FILTERS_AREA_TOOLTIP = Messages.getString(FindAnnViewer.class, "hide.filters.area.tooltip");
    private static final String SHOW_FILTERS_AREA_TOOLTIP = Messages.getString(FindAnnViewer.class, "show.filters.area.tooltip");
    private FindAnnDescriptor descriptor;
    private IActionManager manager;
    private ImageRegistry imgRegistry;
    private Text annTextTitleTxt;
    private Text txtKeysCriteria;
    private DateTime dateFrom;
    private Button dateCheckButtonFrom;
    private Button dateCheckButtonTo;
    private DateTime dateTo;
    private Text resNameTxt;
    private Text resTypeTxt;
    private ProjectsListWrapper availableProjectsList;
    private ListViewer resAnnotations;
    private ListViewer resPrj;
    private TreeViewer resourcesTreeViewer;
    private Text txtAnnText;
    private Text txtAnnDate;
    private org.eclipse.swt.widgets.List lstKeys;
    private Button searchButton;
    private Button btnEdit;
    private Button btnRemove;
    private Button exportButton;
    private String selectedProject;
    private static final int space5px = 5;
    private static final int space10px = 10;
    private static final int space3px = 3;
    Map<String, Object> searchCrit = new HashMap<String, Object>();
    EZAnnotation currentAnn = null;
    static Map<Triplet<String, String, Integer>, List<Triplet<Integer, String, String>>> resTypes = new HashMap<Triplet<String, String, Integer>, List<Triplet<Integer, String, String>>>();
    private ModifyListener changeListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            FindAnnViewer.this.checkSearchBtn();
        }
    };

    static {
        ArrayList<Triplet> lst = new ArrayList<Triplet>();
        ProgramType[] programTypeArray = ProgramType.values();
        int n = programTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProgramType pType = programTypeArray[n2];
            if (!(pType.equals((Object)ProgramType.UNKNOWN) || pType.equals((Object)ProgramType.SCL) || pType.equals((Object)ProgramType.SCL_PROCEDURE) || pType.equals((Object)ProgramType.DDCL))) {
                lst.add(new Triplet((Object)pType.ordinal(), (Object)FindAnnViewer.getLocalizedProgramType(pType), (Object)"5"));
            }
            ++n2;
        }
        resTypes.put((Triplet<String, String, Integer>)new Triplet((Object)"5", (Object)ResourceIdentificator.RESOURCETYPE_PROGRAM, (Object)1), lst);
        lst = new ArrayList();
        lst.add(new Triplet(null, (Object)ResourceIdentificator.RESOURCETYPE_JCL_JOB, (Object)"22"));
        lst.add(new Triplet(null, (Object)ResourceIdentificator.RESOURCETYPE_SQLTABLE, (Object)"1"));
        lst.add(new Triplet(null, (Object)ResourceIdentificator.RESOURCETYPE_SQLFIELDTABLE, (Object)"187"));
        lst.add(new Triplet(null, (Object)ResourceIdentificator.RESOURCETYPE_CICSMAP, (Object)"6"));
        lst.add(new Triplet(null, (Object)ResourceIdentificator.RESOURCETYPE_IMSTRAN, (Object)"20"));
        lst.add(new Triplet(null, (Object)ResourceIdentificator.RESOURCETYPE_IMSDBSEG, (Object)"209"));
        lst.add(new Triplet(null, (Object)ResourceIdentificator.RESOURCETYPE_IMSMSG, (Object)"212"));
        lst.add(new Triplet(null, (Object)ResourceIdentificator.RESOURCETYPE_FILE, (Object)"9"));
        resTypes.put((Triplet<String, String, Integer>)new Triplet((Object)"", (Object)ResourceIdentificator.RESOURCETYPE_GROUP_OTHER, (Object)2), lst);
    }

    private static String getLocalizedProgramType(ProgramType pType) {
        int id = pType.ordinal();
        String str = Utils.getExternalizedType((Integer)id);
        if (str.equals(String.valueOf(id))) {
            str = pType.toString();
        }
        return str;
    }

    public FindAnnViewer(FindAnnDescriptor findAnnDescriptor) {
        this.descriptor = findAnnDescriptor;
    }

    public Composite create(Composite parent, IAction action, IActionManager manager) {
        this.manager = manager;
        manager.setCurrentContext(null);
        this.initImageRegistry(manager);
        final Composite mainPanel = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        mainPanel.setLayout((Layout)formLayout);
        final Button toggleFiltersButton = new Button(mainPanel, 2);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        toggleFiltersButton.setLayoutData((Object)formData);
        Label filtersSummary = new Label(mainPanel, 0);
        filtersSummary.setText(Messages.getString(FindAnnViewer.class, "filters.label"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)toggleFiltersButton, 0, 0x1000000);
        formData.left = new FormAttachment((Control)toggleFiltersButton, 5);
        filtersSummary.setLayoutData((Object)formData);
        final SashForm hSashMain = new SashForm(mainPanel, 512);
        formData = new FormData();
        formData.top = new FormAttachment((Control)toggleFiltersButton);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        hSashMain.setLayoutData((Object)formData);
        formLayout = new FormLayout();
        hSashMain.setLayout((Layout)formLayout);
        ScrolledComposite filtersMainSC = new ScrolledComposite((Composite)hSashMain, 2816);
        filtersMainSC.setExpandHorizontal(true);
        filtersMainSC.setExpandVertical(true);
        filtersMainSC.setShowFocusedControl(true);
        Composite filtersMainArea = new Composite((Composite)filtersMainSC, 0);
        formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        filtersMainArea.setLayout((Layout)formLayout);
        filtersMainArea.pack();
        this.createFiltersArea(filtersMainArea);
        filtersMainSC.setContent((Control)filtersMainArea);
        Point sizeFiltersArea = filtersMainArea.computeSize(-1, -1);
        filtersMainSC.setMinSize(sizeFiltersArea);
        final ScrolledComposite resultsSC = new ScrolledComposite((Composite)hSashMain, 768);
        resultsSC.setExpandHorizontal(true);
        resultsSC.setExpandVertical(true);
        resultsSC.setShowFocusedControl(true);
        Composite resultsArea = new Composite((Composite)resultsSC, 2048);
        formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        resultsArea.setLayout((Layout)formLayout);
        this.createResultsArea(resultsArea);
        resultsSC.setContent((Control)resultsArea);
        resultsSC.setMinSize(resultsArea.computeSize(-1, -1));
        toggleFiltersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAnnViewer.this.showOrHideFiltersArea(toggleFiltersButton, hSashMain, (Composite)resultsSC);
                mainPanel.layout();
            }
        });
        Boolean showFiltersArea = (Boolean)this.descriptor.getState().getData().get(SHOW_FILTERS_AREA_KEY);
        toggleFiltersButton.setSelection(showFiltersArea != null ? showFiltersArea : true);
        this.showOrHideFiltersArea(toggleFiltersButton, hSashMain, (Composite)resultsSC);
        Point sizeMainArea = mainPanel.computeSize(-1, -1);
        this.fillGUI();
        hSashMain.setWeights(new int[]{sizeFiltersArea.y * 100 / sizeMainArea.y, (sizeMainArea.y - sizeFiltersArea.y) * 100 / sizeMainArea.y});
        return mainPanel;
    }

    private void fillGUI() {
        Map data = this.descriptor.getState().getData();
        this.searchCrit = (Map)data.get(SEARCH_CRITERIA_KEY);
        boolean isMoved = this.searchCrit != null && !this.searchCrit.isEmpty();
        String[] prjs = null;
        if (isMoved) {
            prjs = this.fillResourceGUIfromCriteria();
        } else {
            Collection inpts = (Collection)data.get("ANALYSIS_TYPE_INPUTS");
            if (inpts != null && !inpts.isEmpty()) {
                this.fillResourceGUIfromInputs(inpts);
            }
        }
        ArrayList<ProjectInfo> selectedPrjs = null;
        List allProjects = (List)data.get("projects");
        if (isMoved) {
            if (prjs != null && prjs.length > 0) {
                selectedPrjs = new ArrayList<ProjectInfo>();
                int i = 0;
                while (i < prjs.length) {
                    String prjName = prjs[i];
                    for (ProjectInfo p : allProjects) {
                        if (!p.getName().equals(prjName)) continue;
                        selectedPrjs.add(p);
                        break;
                    }
                    ++i;
                }
            } else {
                L.warn("tab was moved but no selected projects?!");
            }
        } else {
            selectedPrjs = (ArrayList<ProjectInfo>)data.get("PROJECT_LIST");
        }
        List filteredProjects = com.ez.mainframe.gui.utils.Utils.filterProjects((List)allProjects, (EZAnalysisType)this.descriptor.getAnalysisType());
        this.availableProjectsList.fill(filteredProjects, selectedPrjs);
        this.cleanContext();
        this.checkSearchBtn();
        this.enableAnnButtons(false);
        this.loadResultsFromContext();
    }

    private String[] fillResourceGUIfromCriteria() {
        ResourceCriteria crit;
        String[] prjs = null;
        String text = (String)this.searchCrit.get("ann_name_text");
        this.annTextTitleTxt.setText(text != null ? text : "");
        Calendar d = (Calendar)this.searchCrit.get("startDate");
        if (d != null) {
            this.dateFrom.setDate(d.get(1), d.get(2), d.get(5));
            this.dateFrom.setTime(d.get(11), d.get(12), d.get(13));
            this.dateCheckButtonFrom.setEnabled(true);
            this.dateFrom.setEnabled(true);
            this.dateCheckButtonFrom.setSelection(true);
        }
        if ((d = (Calendar)this.searchCrit.get("endDate")) != null) {
            this.dateTo.setDate(d.get(1), d.get(2), d.get(5));
            this.dateTo.setTime(d.get(11), d.get(12), d.get(13));
            this.dateCheckButtonTo.setEnabled(true);
            this.dateTo.setEnabled(true);
            this.dateCheckButtonTo.setSelection(true);
        }
        Collection keys = (Collection)this.searchCrit.get("keyword");
        this.fillKeys(keys);
        Set criterion = (Set)this.searchCrit.get("byResources");
        if (criterion != null && !criterion.isEmpty() && (crit = (ResourceCriteria)criterion.iterator().next()) != null) {
            prjs = (String[])crit.getValue("project");
            String resName = (String)crit.getValue("resourceName");
            this.resNameTxt.setText(resName != null ? resName : "");
            List types = (List)crit.getValue("resourceType");
            if (types != null && !types.isEmpty()) {
                HashSet<String> typeNames = new HashSet<String>();
                for (Triplet t : types) {
                    typeNames.add((String)t.getSecond());
                }
                this.fillResTypes(types, typeNames);
            }
        }
        return prjs;
    }

    private void loadResultsFromContext() {
        Map data = this.descriptor.getState().getData();
        if (data.get(RESULTS_KEY) != null) {
            Collection anns = (Collection)data.get(RESULTS_KEY);
            this.fillResults(anns);
        }
    }

    private void cleanContext() {
        this.descriptor.getState().getData().put("selectedContext", null);
        this.manager.setCurrentContext(null);
    }

    private void checkSearchBtn() {
        boolean ret = this.annTextTitleTxt.getText() != null && !this.annTextTitleTxt.getText().isEmpty() || this.resNameTxt.getText() != null && !this.resNameTxt.getText().isEmpty() || this.resTypeTxt.getData() != null || this.txtKeysCriteria.getData() != null || this.dateCheckButtonFrom.getSelection() || this.dateCheckButtonTo.getSelection() || this.availableProjectsList.getList().getSelectionCount() > 0;
        this.searchButton.setEnabled(this.searchCrit != null && !this.searchCrit.isEmpty());
        this.searchButton.setEnabled(ret);
    }

    private void fillResourceGUIfromInputs(Collection<EZObjectType> inputs) {
        StringBuffer names = new StringBuffer();
        HashSet<String> typeNames = new HashSet<String>();
        ArrayList<Triplet<Integer, String, String>> types = new ArrayList<Triplet<Integer, String, String>>();
        for (EZObjectType obj : inputs) {
            String resName = null;
            Triplet t = new Triplet();
            String resType = null;
            String resTypeName = null;
            if (obj instanceof EZSourceProgram) {
                resType = "5";
                resTypeName = ResourceIdentificator.RESOURCETYPE_PROGRAM;
                EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)obj.getEntID().getSegment(EZSourceProgramIDSg.class);
                if (prgSg != null) {
                    t.setFirst((Object)prgSg.getTypeId());
                    resTypeName = Utils.getPrgType((String)prgSg.getTypeId().toString());
                    if (resName == null) {
                        resName = prgSg.getProgramName();
                    }
                }
            } else if (obj instanceof EZJobInputType) {
                resName = obj.getName();
                if (resName == null) {
                    resName = ((EZSourceJobIDSg)obj.getEntID().getSegment(EZSourceJobIDSg.class)).getJobName();
                }
                resType = "22";
                resTypeName = ResourceIdentificator.RESOURCETYPE_JCL_JOB;
            }
            if (resName != null) {
                names.append(resName);
                names.append(",");
            }
            if (resType == null) continue;
            t.setSecond((Object)resTypeName);
            t.setThird((Object)resType);
            types.add((Triplet<Integer, String, String>)t);
            typeNames.add(resTypeName);
        }
        if (names.length() > 0) {
            names.delete(names.length() - 1, names.length());
            this.resNameTxt.setText(names.toString());
        } else {
            this.resNameTxt.setText("");
        }
        this.fillResTypes(types, typeNames);
    }

    private void fillResTypes(List<Triplet<Integer, String, String>> types, Set<String> typeNames) {
        if (types.isEmpty()) {
            this.resTypeTxt.setText("");
            this.resTypeTxt.setData(null);
        } else {
            ArrayList<String> tmp = new ArrayList<String>(typeNames);
            Collections.sort(tmp);
            this.resTypeTxt.setText(((Object)tmp).toString());
            this.resTypeTxt.setData(types);
        }
    }

    private void collectResourceCriteria() {
        HashSet<ResourceCriteria> criterion = new HashSet<ResourceCriteria>();
        ResourceCriteria crit = new ResourceCriteria();
        criterion.add(crit);
        String[] prjs = this.availableProjectsList.getList().getSelection();
        if (prjs != null && prjs.length > 0) {
            crit.addCriteria("project", (Object)prjs);
        }
        if (!this.resNameTxt.getText().isEmpty()) {
            crit.addCriteria("resourceName", (Object)this.resNameTxt.getText());
        }
        if (this.resTypeTxt.getData() != null) {
            crit.addCriteria("resourceType", this.resTypeTxt.getData());
        }
        this.searchCrit.put("byResources", criterion);
    }

    private void createFiltersArea(Composite filtersMainArea) {
        SashForm vSashFiltersArea = new SashForm(filtersMainArea, 256);
        ScrolledComposite leftSC = new ScrolledComposite((Composite)vSashFiltersArea, 768);
        leftSC.setExpandHorizontal(true);
        leftSC.setExpandVertical(true);
        leftSC.setShowFocusedControl(true);
        Composite leftFiltersArea = new Composite((Composite)leftSC, 2048);
        FormLayout formLayout = new FormLayout();
        formLayout.marginRight = 10;
        formLayout.marginLeft = 10;
        formLayout.marginTop = 5;
        formLayout.marginBottom = 5;
        leftFiltersArea.setLayout((Layout)formLayout);
        leftSC.setContent((Control)leftFiltersArea);
        Composite rightFiltersArea = new Composite((Composite)vSashFiltersArea, 2048);
        formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        rightFiltersArea.setLayout((Layout)formLayout);
        vSashFiltersArea.setWeights(new int[]{70, 30});
        this.createLeftFilterArea(leftFiltersArea);
        leftSC.setMinSize(leftFiltersArea.computeSize(-1, -1));
        this.createProjectsArea(rightFiltersArea);
        Point leftSize = leftFiltersArea.computeSize(-1, -1);
        Point rightSize = rightFiltersArea.computeSize(-1, -1);
        FormData formData = new FormData(leftSize.x + rightSize.x, leftSize.y);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        vSashFiltersArea.setLayoutData((Object)formData);
    }

    private void createProjectsArea(Composite parent) {
        Group projectsGroup = new Group(parent, 0);
        projectsGroup.setText(Messages.getString(FindAnnViewer.class, "projects.label.text"));
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        projectsGroup.setLayout((Layout)formLayout);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        projectsGroup.setLayoutData((Object)formData);
        this.availableProjectsList = new ProjectsListWrapper(projectsGroup, 2562);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        this.availableProjectsList.getList().setLayoutData((Object)formData);
        this.availableProjectsList.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
    }

    private void createLeftFilterArea(Composite parent) {
        Label titleLabel = new Label(parent, 0);
        titleLabel.setText(Messages.getString(FindAnnViewer.class, "text.label.text"));
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0, 5);
        titleLabel.setLayoutData((Object)formData);
        this.annTextTitleTxt = new Text(parent, 2048);
        this.annTextTitleTxt.addModifyListener(this.changeListener);
        formData = new FormData(150, -1);
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)titleLabel, 5);
        this.annTextTitleTxt.setLayoutData((Object)formData);
        Label keysLabel = new Label(parent, 0);
        keysLabel.setText(Messages.getString(FindAnnViewer.class, "keys.label.text"));
        formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment((Control)this.annTextTitleTxt, 5);
        keysLabel.setLayoutData((Object)formData);
        this.txtKeysCriteria = new Text(parent, 2048);
        this.txtKeysCriteria.setEditable(false);
        this.txtKeysCriteria.addModifyListener(this.changeListener);
        final Button keysButton = new Button(parent, 8);
        keysButton.setText("...");
        keysButton.setToolTipText(Messages.getString(FindAnnViewer.class, "keys.button.tooltip.text"));
        keysButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(FindAnnViewer.class, "keys.button.tooltip.text");
            }
        });
        keysButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                KeysDialog dialog = new KeysDialog(keysButton.getShell(), (Collection)FindAnnViewer.this.txtKeysCriteria.getData());
                if (dialog.open() == 0) {
                    FindAnnViewer.this.fillKeys(dialog.getKeysSelected());
                }
                FindAnnViewer.this.checkSearchBtn();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        keysButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)keysLabel, 5);
        formData.right = new FormAttachment((Control)keysButton, -5);
        this.txtKeysCriteria.setLayoutData((Object)formData);
        Composite filteringComposite = new Composite(parent, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.txtKeysCriteria, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        filteringComposite.setLayoutData((Object)formData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        filteringComposite.setLayout((Layout)gridLayout);
        Group dateFiltering = new Group(filteringComposite, 0);
        dateFiltering.setText(Messages.getString(FindAnnViewer.class, "dateFiltering.label.text"));
        GridData gridData = new GridData(4, 4, false, true);
        gridData.horizontalSpan = 1;
        dateFiltering.setLayoutData((Object)gridData);
        dateFiltering.pack();
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        dateFiltering.setLayout((Layout)gridLayout);
        this.dateCheckButtonFrom = new Button((Composite)dateFiltering, 32);
        this.dateCheckButtonFrom.setText(Messages.getString(FindAnnViewer.class, "dateFrom.label.text"));
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 1;
        this.dateCheckButtonFrom.setLayoutData((Object)gridData);
        this.dateFrom = new DateTime((Composite)dateFiltering, 2084);
        gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 1;
        this.dateFrom.setLayoutData((Object)gridData);
        this.dateCheckButtonTo = new Button((Composite)dateFiltering, 32);
        this.dateCheckButtonTo.setText(Messages.getString(FindAnnViewer.class, "dateTo.label.text"));
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 1;
        this.dateCheckButtonTo.setLayoutData((Object)gridData);
        this.dateTo = new DateTime((Composite)dateFiltering, 2084);
        gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 1;
        this.dateTo.setLayoutData((Object)gridData);
        this.dateFrom.setEnabled(false);
        this.dateCheckButtonFrom.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FindAnnViewer.this.dateCheckButtonFrom.getSelection()) {
                    FindAnnViewer.this.dateFrom.setEnabled(true);
                } else {
                    FindAnnViewer.this.dateFrom.setEnabled(false);
                }
                FindAnnViewer.this.checkSearchBtn();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dateTo.setEnabled(false);
        this.dateCheckButtonTo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FindAnnViewer.this.dateCheckButtonTo.getSelection()) {
                    FindAnnViewer.this.dateTo.setEnabled(true);
                } else {
                    FindAnnViewer.this.dateTo.setEnabled(false);
                }
                FindAnnViewer.this.checkSearchBtn();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group resourceFiltering = new Group(filteringComposite, 0);
        resourceFiltering.setText(Messages.getString(FindAnnViewer.class, "resourceFiltering.label.text"));
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 1;
        resourceFiltering.setLayoutData((Object)gridData);
        FormLayout formLayout = new FormLayout();
        resourceFiltering.setLayout((Layout)formLayout);
        Label resNameLabel = new Label((Composite)resourceFiltering, 0);
        resNameLabel.setText(Messages.getString(FindAnnViewer.class, "resourceName.label.text"));
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        resNameLabel.setLayoutData((Object)formData);
        this.resNameTxt = new Text((Composite)resourceFiltering, 2048);
        this.resNameTxt.addModifyListener(this.changeListener);
        formData = new FormData();
        formData.top = new FormAttachment((Control)resNameLabel, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.resNameTxt.setLayoutData((Object)formData);
        Label resTypeLabel = new Label((Composite)resourceFiltering, 0);
        resTypeLabel.setText(Messages.getString(FindAnnViewer.class, "resourceType.label.text"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.resNameTxt, 5);
        formData.left = new FormAttachment(0, 5);
        resTypeLabel.setLayoutData((Object)formData);
        this.resTypeTxt = new Text((Composite)resourceFiltering, 2048);
        this.resTypeTxt.setEditable(false);
        this.resTypeTxt.addModifyListener(this.changeListener);
        final Button resTypeButton = new Button((Composite)resourceFiltering, 8);
        resTypeButton.setText("...");
        resTypeButton.setToolTipText(Messages.getString(FindAnnViewer.class, "result.type.button.tooltip"));
        resTypeButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(FindAnnViewer.class, "result.type.button.tooltip");
            }
        });
        resTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FindAnnViewer.this.chooseResourceType(resTypeButton);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment((Control)resTypeLabel, 5);
        formData.right = new FormAttachment(100, -5);
        resTypeButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)resTypeLabel, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment((Control)resTypeButton, -5);
        this.resTypeTxt.setLayoutData((Object)formData);
        this.searchButton = new Button(parent, 8);
        this.searchButton.setText(Messages.getString(FindAnnViewer.class, "search.lbl"));
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAnnViewer.this.doSearch();
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment((Control)filteringComposite, 5);
        formData.right = new FormAttachment(100, -5);
        this.searchButton.setLayoutData((Object)formData);
    }

    protected void fillKeys(Collection<EZKeyword> selection) {
        if (selection == null || selection.isEmpty()) {
            this.txtKeysCriteria.setText("");
            this.txtKeysCriteria.setData(null);
        } else {
            StringBuilder buff = new StringBuilder();
            for (EZKeyword k : selection) {
                buff.append(k.getName());
                buff.append(",");
            }
            buff.delete(buff.length() - 1, buff.length());
            this.txtKeysCriteria.setText(buff.toString());
            this.txtKeysCriteria.setData(selection);
        }
    }

    protected void fillResourceTypes(List<Triplet<Integer, String, String>> selection) {
        if (selection == null || selection.isEmpty()) {
            this.resTypeTxt.setText("");
            this.resTypeTxt.setData(null);
        } else {
            StringBuilder buff = new StringBuilder();
            for (Triplet<Integer, String, String> sel : selection) {
                buff.append(sel.getSecond());
                buff.append(",");
            }
            buff.delete(buff.length() - 1, buff.length());
            this.resTypeTxt.setText(buff.toString());
            this.resTypeTxt.setData(selection);
        }
    }

    void doSearch() {
        L.debug("starting search");
        final long startTime = System.currentTimeMillis();
        L.info("{} - search start time: {}", (Object)this.descriptor.getAnalysisType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        this.clearResults();
        this.fillCriteria();
        Map data = this.descriptor.getState().getData();
        data.put(SEARCH_CRITERIA_KEY, this.searchCrit);
        Job j = new Job(Messages.getString(FindAnnViewer.class, "search.annotations")){

            protected IStatus run(IProgressMonitor monitor) {
                ResourceCriteria criteria;
                final Collection anns = FindAnnViewer.this.search(monitor);
                Set resources = (Set)FindAnnViewer.this.searchCrit.get("byResources");
                if (resources != null && !resources.isEmpty() && (criteria = (ResourceCriteria)resources.iterator().next()) != null) {
                    CharSequence[] proj = (String[])criteria.getValue("project");
                    FindAnnViewer.this.selectedProject = String.join((CharSequence)",", proj);
                }
                Map data = FindAnnViewer.this.descriptor.getState().getData();
                data.put(FindAnnViewer.RESULTS_KEY, anns);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FindAnnViewer.this.fillResults(anns);
                        long duration = System.currentTimeMillis() - startTime;
                        L.info("{} - search duration after loading results: {} ms.", (Object)FindAnnViewer.this.descriptor.getAnalysisType().toString(), (Object)duration);
                    }
                });
                FindAnnViewer.this.auditAnalysis();
                long duration = System.currentTimeMillis() - startTime;
                L.info("{} - search duration: {} ms.", (Object)FindAnnViewer.this.descriptor.getAnalysisType().toString(), (Object)duration);
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    private void fillCriteria() {
        if (this.searchCrit == null) {
            this.searchCrit = new HashMap<String, Object>();
        } else {
            this.searchCrit.clear();
        }
        if (this.annTextTitleTxt.getText() != null && !this.annTextTitleTxt.getText().isEmpty()) {
            this.searchCrit.put("ann_name_text", this.annTextTitleTxt.getText());
        }
        Calendar d = Calendar.getInstance();
        if (this.dateCheckButtonFrom.getSelection()) {
            d.set(1, this.dateFrom.getYear());
            d.set(2, this.dateFrom.getMonth());
            d.set(5, this.dateFrom.getDay());
            this.searchCrit.put("startDate", d);
        }
        if (this.dateCheckButtonTo.getSelection()) {
            d = Calendar.getInstance();
            d.set(1, this.dateTo.getYear());
            d.set(2, this.dateTo.getMonth());
            d.set(5, this.dateTo.getDay());
            this.searchCrit.put("endDate", d);
        }
        if (this.txtKeysCriteria.getData() != null) {
            this.searchCrit.put("keyword", this.txtKeysCriteria.getData());
        }
        this.collectResourceCriteria();
    }

    private Collection<?> search(IProgressMonitor monitor) {
        Collection ret = null;
        if (this.searchCrit != null && !this.searchCrit.isEmpty()) {
            try {
                ret = EZAnnotationDbManager.getInstance().findAnn(this.searchCrit, monitor);
                L.debug("find by: {}", this.searchCrit);
                for (EZAnnotation ann : (Set)ret) {
                    L.trace("-------- annID={}, name={}", (Object)ann.getDbId(), (Object)ann.getName());
                }
            }
            catch (Exception ex) {
                L.error("error getting annotation", (Throwable)ex);
                LogUtil.displayErrorMessage((Throwable)ex, (String)Messages.getString(FindAnnViewer.class, "error.getting.annotation.message"), (Plugin)Activator.getDefault(), (boolean)false);
                ret = new ArrayList();
                ((List)ret).add(Messages.getString(FindAnnViewer.class, "error.results.entry"));
            }
        }
        if (ret == null || ret.isEmpty()) {
            ret = new ArrayList();
            ((List)ret).add(Messages.getString(FindAnnViewer.class, "noData.results.entry"));
        }
        return ret;
    }

    private void clearResults() {
        this.exportButton.setEnabled(false);
        this.exportButton.setImage(this.imgRegistry.get(EXPORT_RESULTS_DISABLED_IMG_KEY));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (FindAnnViewer.this.resAnnotations != null) {
                    FindAnnViewer.this.resAnnotations.setInput(null);
                }
                FindAnnViewer.this.fillAnnDetails(null);
            }
        });
    }

    private void createResultsArea(Composite parent) {
        final Group resultsComp = new Group(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        resultsComp.setLayout((Layout)formLayout);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        resultsComp.setLayoutData((Object)formData);
        Label resultsCompLabel = new Label((Composite)resultsComp, 0);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        resultsCompLabel.setLayoutData((Object)formData);
        resultsComp.setText(Messages.getString(FindAnnViewer.class, "results.label.text"));
        this.exportButton = new Button((Composite)resultsComp, 8);
        this.exportButton.setEnabled(false);
        this.exportButton.setImage(this.imgRegistry.get(EXPORT_RESULTS_DISABLED_IMG_KEY));
        this.exportButton.setToolTipText(Messages.getString(FindAnnViewer.class, "export.csv.tooltip"));
        this.exportButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(FindAnnViewer.class, "export.csv.tooltip");
            }
        });
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog exportFileDialog = new FileDialog(resultsComp.getShell(), 8192);
                exportFileDialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                exportFileDialog.setFilterNames(new String[]{Messages.getString(FindAnnViewer.class, "file.csv.label", new String[]{"*.csv"}), Messages.getString(FindAnnViewer.class, "file.all.label", new String[]{"*.*"})});
                exportFileDialog.setOverwrite(true);
                final String fileNamePath = exportFileDialog.open();
                if (fileNamePath != null) {
                    Job exportJob = new Job(Messages.getString(FindAnnViewer.class, "export.csv.job.name")){

                        protected IStatus run(IProgressMonitor monitor) {
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            subMonitor.setTaskName(Messages.getString(FindAnnViewer.class, "export.csv.exportTask.name"));
                            FindAnnViewer.this.exportResultsToCSV((IProgressMonitor)subMonitor.newChild(100), fileNamePath);
                            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                        }
                    };
                    exportJob.setUser(true);
                    exportJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            IStatus status;
                            if (fileNamePath != null && (status = event.getResult()) == Status.OK_STATUS) {
                                ExecExportStatus ees = new ExecExportStatus();
                                ees.exportStatus = true;
                                ees.exportFile = fileNamePath;
                                Display.getDefault().syncExec((Runnable)ees);
                            }
                        }
                    });
                    exportJob.schedule();
                }
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.exportButton.setLayoutData((Object)formData);
        SashForm resultsSashForm = new SashForm((Composite)resultsComp, 256);
        formData = new FormData();
        formData.top = new FormAttachment((Control)resultsCompLabel, 5);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        resultsSashForm.setLayoutData((Object)formData);
        Group annComp = new Group((Composite)resultsSashForm, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)resultsCompLabel);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(30);
        formData.bottom = new FormAttachment(100);
        annComp.setLayoutData((Object)formData);
        formLayout = new FormLayout();
        annComp.setLayout((Layout)formLayout);
        annComp.setText(Messages.getString(FindAnnViewer.class, "annotations.label.text"));
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        this.btnRemove = new Button((Composite)annComp, 8);
        this.btnRemove.setImage(this.imgRegistry.get(DELETE_ANNOTATION_IMG_KEY));
        this.btnRemove.setToolTipText(Messages.getString(FindAnnViewer.class, "remove.button.tooltip.text"));
        this.btnRemove.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(FindAnnViewer.class, "remove.button.tooltip.text");
            }
        });
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.btnRemove.setLayoutData((Object)formData);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAnnViewer.this.deleteAnnotation();
            }
        });
        this.btnEdit = new Button((Composite)annComp, 8);
        this.btnEdit.setImage(this.imgRegistry.get(EDIT_ANNOTATION_IMG_KEY));
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment((Control)this.btnRemove);
        this.btnEdit.setLayoutData((Object)formData);
        this.btnEdit.setToolTipText(Messages.getString(FindAnnViewer.class, "edit.button.tooltip.text"));
        this.btnEdit.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(FindAnnViewer.class, "edit.button.tooltip.text");
            }
        });
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAnnViewer.this.editAnnotation();
            }
        });
        this.resAnnotations = new ListViewer((Composite)annComp, 2816);
        this.resAnnotations.setLabelProvider((IBaseLabelProvider)new EZAnnLblProvider());
        this.resAnnotations.setContentProvider((IContentProvider)new EZAnnContentProvider());
        this.resAnnotations.setSorter((ViewerSorter)new EZAnnViewerSorter());
        this.resAnnotations.addSelectionChangedListener((ISelectionChangedListener)new AnnSelectionListener());
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.btnEdit);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.resAnnotations.getList().setLayoutData((Object)formData);
        Composite detailsComposite = new Composite((Composite)resultsSashForm, 0);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(70);
        formData.bottom = new FormAttachment(100);
        formLayout = new FormLayout();
        detailsComposite.setLayout((Layout)formLayout);
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        Composite annDetComp = new Composite(detailsComposite, 0);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        annDetComp.setLayoutData((Object)formData);
        formLayout = new FormLayout();
        annDetComp.setLayout((Layout)formLayout);
        Group annDetGr = new Group(annDetComp, 0);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        annDetGr.setLayoutData((Object)formData);
        annDetGr.setText(Messages.getString(FindAnnViewer.class, "annotation.details.text"));
        this.createAnnDetailsArea(annDetGr);
        Group resComp = new Group((Composite)resultsSashForm, 0);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(70);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        formLayout = new FormLayout();
        resComp.setLayout((Layout)formLayout);
        Label resLabel = new Label((Composite)resComp, 0);
        resComp.setText(Messages.getString(FindAnnViewer.class, "resources.label.text"));
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        resLabel.setLayoutData((Object)formData);
        this.resourcesTreeViewer = new TreeViewer((Composite)resComp, 68354);
        this.resourcesTreeViewer.setContentProvider((IContentProvider)new ResourcesContentProvider());
        this.resourcesTreeViewer.setLabelProvider((IBaseLabelProvider)new ResourcesLabelProvider());
        formData = new FormData();
        formData.top = new FormAttachment((Control)resLabel);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.resourcesTreeViewer.getTree().setLayoutData((Object)formData);
        final Label lblRelProj = new Label((Composite)resComp, 0);
        lblRelProj.setText(Messages.getString(FindAnnViewer.class, "relatedProjects.label"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.resourcesTreeViewer.getTree());
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        lblRelProj.setLayoutData((Object)formData);
        this.resPrj = new ListViewer((Composite)resComp, 2560);
        this.resPrj.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.resPrj.setContentProvider((IContentProvider)new ProjectContentProvider());
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblRelProj);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.resPrj.getList().setLayoutData((Object)formData);
        this.resPrj.getList().getAccessible().addRelation(2, lblRelProj.getAccessible());
        lblRelProj.getAccessible().addRelation(3, this.resPrj.getList().getAccessible());
        this.resPrj.getList().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = lblRelProj.getText();
            }
        });
        this.resourcesTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection resSelection = event.getSelection();
                FindAnnViewer.this.selectResource(resSelection);
            }
        });
        this.resPrj.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection prjSelection = event.getSelection();
                if (!prjSelection.isEmpty()) {
                    FindAnnViewer.this.makeContextForAnalyzes();
                } else {
                    FindAnnViewer.this.cleanContext();
                }
            }
        });
        resultsSashForm.setWeights(new int[]{30, 40, 30});
    }

    private void editAnnotation() {
        if (this.currentAnn != null) {
            AddAnnDialog dialog = new AddAnnDialog(this.btnEdit.getShell(), this.currentAnn);
            dialog.create();
            if (dialog.open() == 0) {
                L.debug("end update");
                ISelection s = this.resAnnotations.getSelection();
                this.resAnnotations.refresh();
                this.resAnnotations.setSelection(s);
            } else {
                L.trace("update canceled");
            }
        } else {
            L.warn("nothing to edit?!");
        }
    }

    private void deleteAnnotation() {
        if (this.currentAnn != null) {
            boolean delete = MessageDialog.openQuestion((Shell)this.btnRemove.getShell(), (String)Messages.getString(FindAnnViewer.class, "confirm.delete.text"), (String)Messages.getString(FindAnnViewer.class, "validate.delete.text"));
            if (delete) {
                final long startTime = System.currentTimeMillis();
                L.info("{} - delete annotation start time: {}", (Object)this.descriptor.getAnalysisType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
                Job j = new Job(Messages.getString(FindAnnViewer.class, "delete.annotation.progress")){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            boolean deleted = EZAnnotationDbManager.getInstance().logicalDeleteAnn(FindAnnViewer.this.currentAnn, (IProgressMonitor)new NullProgressMonitor());
                            if (deleted) {
                                Set resrs = FindAnnViewer.this.currentAnn.getResources();
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((Set)FindAnnViewer.this.resAnnotations.getInput()).remove((this).FindAnnViewer.this.currentAnn);
                                        FindAnnViewer.this.resAnnotations.refresh();
                                        FindAnnViewer.this.resAnnotations.setSelection(null);
                                    }
                                });
                                FindAnnViewer.this.notifyDeleteAnn(resrs);
                            }
                        }
                        catch (Exception e) {
                            L.error("error deleting annotation", (Throwable)e);
                            MessageBox msg = new MessageBox(FindAnnViewer.this.btnRemove.getShell(), 1);
                            msg.setText(Messages.getString(FindAnnViewer.class, "errorBoxTitle"));
                            msg.setMessage(e.toString());
                            msg.open();
                        }
                        long duration = System.currentTimeMillis() - startTime;
                        L.info("{} - delete annotation duration: {} ms.", (Object)FindAnnViewer.this.descriptor.getAnalysisType().toString(), (Object)duration);
                        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                    }
                };
                j.setUser(true);
                j.schedule();
            } else {
                L.trace("delete canceled");
            }
        } else {
            L.warn("nothing to delete?!");
        }
    }

    private void notifyDeleteAnn(Set<AnnResource> resrs) {
        Map data = this.descriptor.getState().getData();
        HashSet<EZObjectType> tmp = new HashSet<EZObjectType>();
        for (AnnResource r : resrs) {
            List allProjects = (List)data.get("projects");
            ProjectInfo projectInfo = null;
            for (ProjectInfo p : allProjects) {
                if (!r.getProjectInfo().equals(p.getName())) continue;
                projectInfo = p;
                break;
            }
            if (projectInfo == null) continue;
            EZObjectType o = this.buildObjectType(r, projectInfo);
            tmp.add(o);
        }
        if (!tmp.isEmpty()) {
            EZAnnotationEvent event = new EZAnnotationEvent();
            event.setEvType(EventType.EZANNOTATION_EVENT_TYPE);
            try {
                Set ret = EZAnnotationDbManager.getInstance().haveAnnotations(tmp, null);
                if (ret != null && !ret.isEmpty()) {
                    for (EZObjectType tt : ret) {
                        event.addInStateMap(tt.getEntID(), Boolean.TRUE);
                        tmp.remove(tt);
                    }
                }
            }
            catch (SQLException e) {
                L.error("error finding annotations", (Throwable)e);
            }
            for (EZObjectType tt : tmp) {
                event.addInStateMap(tt.getEntID(), Boolean.FALSE);
            }
            StateManager.getInstance().notify((AEvent)event);
        }
    }

    private void createAnnDetailsArea(Group annDetGr) {
        GridLayout gLay = new GridLayout(2, false);
        gLay.horizontalSpacing = 3;
        gLay.verticalSpacing = 3;
        annDetGr.setLayout((Layout)gLay);
        ScrolledComposite scrollAnnDet = new ScrolledComposite((Composite)annDetGr, 512);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        scrollAnnDet.setLayoutData((Object)gd);
        Composite annComp = new Composite((Composite)scrollAnnDet, 0);
        FormLayout fl = new FormLayout();
        annComp.setLayout((Layout)fl);
        Label lbl = new Label(annComp, 0);
        lbl.setText(Messages.getString(FindAnnViewer.class, "ann.detail.maintext.label.text"));
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        this.txtAnnText = new Text(annComp, 2122);
        this.txtAnnText.getAccessible().addRelation(9, annDetGr.getAccessible());
        this.txtAnnText.getAccessible().addRelation(9, lbl.getAccessible());
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment((Control)lbl, 5);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(100);
        this.txtAnnText.setLayoutData((Object)fd);
        annComp.setSize(annComp.computeSize(-1, -1, true));
        scrollAnnDet.setContent((Control)annComp);
        scrollAnnDet.setMinSize(annComp.computeSize(-1, -1));
        scrollAnnDet.setExpandVertical(true);
        scrollAnnDet.setExpandHorizontal(true);
        lbl = new Label((Composite)annDetGr, 0);
        lbl.setText(Messages.getString(FindAnnViewer.class, "ann.detail.date.label.text"));
        lbl.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.txtAnnDate = new Text((Composite)annDetGr, 2056);
        gd = new GridData(4, 128, true, false);
        this.txtAnnDate.setLayoutData((Object)gd);
        lbl = new Label((Composite)annDetGr, 0);
        lbl.setText(Messages.getString(FindAnnViewer.class, "ann.detail.keywords.label.text"));
        gd = new GridData(16384, 128, false, false);
        lbl.setLayoutData((Object)gd);
        this.lstKeys = new org.eclipse.swt.widgets.List((Composite)annDetGr, 2568);
        gd = new GridData(4, 128, true, false);
        this.lstKeys.setLayoutData((Object)gd);
    }

    private void defaultSelectionOnSearch() {
        this.resAnnotations.getList().select(0);
        StructuredSelection sel = (StructuredSelection)this.resAnnotations.getSelection();
        this.selectAnnotation((ISelection)sel);
    }

    private void fillAnnDetails(EZAnnotation ann) {
        this.lstKeys.removeAll();
        if (ann != null) {
            if (ann.getDescription() != null) {
                this.txtAnnText.setText(ann.getDescription());
            } else {
                this.txtAnnText.setText("");
            }
            if (ann.getDate() != null) {
                this.txtAnnDate.setText(Constants.df.format(ann.getDate()));
            } else {
                this.txtAnnDate.setText("");
            }
            if (ann.getKeywords() != null && !ann.getKeywords().isEmpty()) {
                ArrayList tmp = new ArrayList(ann.getKeywords());
                Collections.sort(tmp);
                for (EZKeyword k : tmp) {
                    this.lstKeys.add(k.getName());
                }
                tmp.clear();
                tmp = null;
            }
            this.resourcesTreeViewer.setInput((Object)ann.getResources());
            this.resourcesTreeViewer.refresh();
            this.resourcesTreeViewer.expandAll();
            TreeItem firstItem = this.resourcesTreeViewer.getTree().getItem(0).getItem(0);
            this.resourcesTreeViewer.getTree().select(firstItem);
            this.selectResource(this.resourcesTreeViewer.getSelection());
            this.enableAnnButtons(true);
        } else {
            this.txtAnnText.setText("");
            this.txtAnnDate.setText("");
            this.resourcesTreeViewer.setInput(null);
            this.resPrj.setInput(null);
            this.cleanContext();
            this.enableAnnButtons(false);
        }
    }

    private void enableAnnButtons(boolean enable) {
        this.btnEdit.setEnabled(enable);
        this.btnRemove.setEnabled(enable);
    }

    private void showOrHideFiltersArea(Button toggleFiltersButton, SashForm hSashMain, Composite resultsArea) {
        if (toggleFiltersButton.getSelection()) {
            hSashMain.setMaximizedControl(null);
            toggleFiltersButton.setImage(this.imgRegistry.get(FILTERS_EXPANDED_IMG_KEY));
            toggleFiltersButton.setToolTipText(HIDE_FILTERS_AREA_TOOLTIP);
            this.descriptor.getState().getData().put(SHOW_FILTERS_AREA_KEY, true);
        } else {
            hSashMain.setMaximizedControl((Control)resultsArea);
            toggleFiltersButton.setImage(this.imgRegistry.get(FILTERS_COLLAPSED_IMG_KEY));
            toggleFiltersButton.setToolTipText(SHOW_FILTERS_AREA_TOOLTIP);
            this.descriptor.getState().getData().put(SHOW_FILTERS_AREA_KEY, false);
        }
    }

    private void initImageRegistry(IActionManager manager) {
        if (this.imgRegistry == null) {
            this.imgRegistry = ((BrowserManager)manager).getImageRegistry();
        }
        if (this.imgRegistry.get(FILTERS_COLLAPSED_IMG_KEY) == null) {
            this.imgRegistry.put(FILTERS_COLLAPSED_IMG_KEY, Activator.getImageDescriptor("icons/collapsed_16.png"));
        }
        if (this.imgRegistry.get(FILTERS_EXPANDED_IMG_KEY) == null) {
            this.imgRegistry.put(FILTERS_EXPANDED_IMG_KEY, Activator.getImageDescriptor("icons/expanded_16.png"));
        }
        if (this.imgRegistry.get(EDIT_ANNOTATION_IMG_KEY) == null) {
            this.imgRegistry.put(EDIT_ANNOTATION_IMG_KEY, Activator.getImageDescriptor("icons/ann_overlay.gif"));
        }
        if (this.imgRegistry.get(DELETE_ANNOTATION_IMG_KEY) == null) {
            this.imgRegistry.put(DELETE_ANNOTATION_IMG_KEY, Activator.getImageDescriptor("icons/remove.png"));
        }
        if (this.imgRegistry.get(EXPORT_RESULTS_AREA_IMG_KEY) == null) {
            this.imgRegistry.put(EXPORT_RESULTS_AREA_IMG_KEY, Activator.getImageDescriptor("icons/Export_16x16.gif"));
        }
        if (this.imgRegistry.get(EXPORT_RESULTS_DISABLED_IMG_KEY) == null) {
            this.imgRegistry.put(EXPORT_RESULTS_DISABLED_IMG_KEY, Activator.getImageDescriptor("icons/disableExport_16x16.gif"));
        }
    }

    private void makeContextForAnalyzes() {
        ISelection resSel;
        AbstractActionContext context = null;
        String selectedPrj = null;
        ISelection s = this.resPrj.getSelection();
        if (s != null && s instanceof StructuredSelection) {
            selectedPrj = (String)((StructuredSelection)s).getFirstElement();
        }
        if (selectedPrj != null && !selectedPrj.isEmpty() && (resSel = this.resourcesTreeViewer.getSelection()) != null && !resSel.isEmpty()) {
            Map data = this.descriptor.getState().getData();
            List allProjects = (List)data.get("projects");
            ProjectInfo projectInfo = null;
            for (ProjectInfo p : allProjects) {
                if (!p.getName().equals(selectedPrj)) continue;
                projectInfo = p;
                break;
            }
            if (projectInfo != null) {
                ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
                for (Node n : (StructuredSelection)resSel) {
                    EZObjectType objType;
                    AnnResource res = null;
                    if (n.details != null && !n.details.isEmpty()) {
                        for (AnnResource r : n.details) {
                            if (!selectedPrj.equals(r.getProjectInfo())) continue;
                            res = r;
                            break;
                        }
                    }
                    if ((objType = this.buildObjectType(res, projectInfo)) == null) continue;
                    inputs.add(objType);
                }
                final HashMap d = new HashMap();
                d.put("projects", allProjects);
                d.put("ANALYSIS_TYPE_INPUTS", inputs);
                d.put("sourceView", new Pair((Object)"com.ez.analysisbrowser.views.AnalysisBrowserView", (Object)((BrowserManager)this.manager).getViewSecondaryId()));
                context = new AbstractActionContext(){

                    public Map<String, Object> getData() {
                        return d;
                    }

                    public String getId() {
                        return "com.ez.analysis.findannotations";
                    }
                };
            }
        }
        this.descriptor.getState().getData().put("selectedContext", context);
        this.manager.setCurrentContext(context);
    }

    private EZObjectType buildObjectType(AnnResource res, ProjectInfo projectInfo) {
        EZObjectType inputType = null;
        EZEntityID entityId = new EZEntityID();
        switch (res.getResourceType()) {
            case "5": {
                Integer prgType = new Integer(res.getPrgType());
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(prgType);
                String programPath = res.getPrgPath();
                Boolean occur = null;
                if (programPath != null) {
                    occur = !programPath.isEmpty();
                }
                inputType.addProperty("program occur", occur);
                EZSourceProgramIDSg prgSegm = new EZSourceProgramIDSg(res.getName(), Integer.valueOf(res.getDbId()), prgType, occur);
                entityId.addSegment((EZSegment)prgSegm);
                String anc = res.getAncestorName();
                if (anc == null || anc.isEmpty()) break;
                prgSegm.setAncestorName(anc);
                break;
            }
            case "22": {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
                String jobName = res.getName();
                Integer jobId = res.getDbId();
                String memberName = jobName;
                EZSourceJobIDSg resourceSg = new EZSourceJobIDSg(jobName, jobId.intValue(), Integer.valueOf(22), memberName);
                entityId.addSegment((EZSegment)resourceSg);
                entityId.addSegment((EZSegment)new EZSourceAAUTOJobIDSg(jobName, null));
                break;
            }
            case "1": {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(1), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String tName = res.getName();
                EZSourceSQLTableIDSg tSg = new EZSourceSQLTableIDSg(tName);
                entityId.addSegment((EZSegment)tSg);
                inputType.addProperty("mainframe resource id sg", (Object)tSg);
                inputType.setName(tName);
                inputType.addProperty("TableName", (Object)tName);
                inputType.addProperty("SqlTableId", (Object)res.getDbId());
                break;
            }
            case "187": {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(187), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String fieldName = res.getName();
                String tableName = res.getQualifierName();
                EZSourceSQLFieldTableIDSg fSg = new EZSourceSQLFieldTableIDSg(fieldName, Integer.valueOf(res.getDbId()), tableName);
                entityId.addSegment((EZSegment)fSg);
                inputType.addProperty("mainframe resource id sg", (Object)fSg);
                inputType.setName(fieldName);
                inputType.addProperty("TableName", (Object)tableName);
                inputType.addProperty("SqlFieldID", (Object)res.getDbId());
                break;
            }
            case "20": {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(20), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String trName = res.getName();
                EZSourceTransactionIDSg trSg = new EZSourceTransactionIDSg(trName);
                trSg.setTransactionType(20);
                entityId.addSegment((EZSegment)trSg);
                inputType.addProperty("mainframe resource id sg", (Object)trSg);
                inputType.setName(trName);
                break;
            }
            case "6": {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(6), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String sName = res.getName();
                String mapSet = res.getQualifierName();
                EZSourceScreenIDSg bmsSg = new EZSourceScreenIDSg(null, sName, 119, null);
                entityId.addSegment((EZSegment)bmsSg);
                bmsSg.setMapSet(mapSet);
                inputType.addProperty("mainframe resource id sg", (Object)bmsSg);
                inputType.setName(sName);
                break;
            }
            case "209": {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(209), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                EZSourceIMSDBSegmentIDSg sSg = new EZSourceIMSDBSegmentIDSg(res.getName(), res.getQualifierName());
                sSg.setSegmentID(Integer.valueOf(res.getDbId()));
                entityId.addSegment((EZSegment)sSg);
                break;
            }
            case "9": {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(30), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String genN = null;
                EZSourceDatasetIDSg dSg = new EZSourceDatasetIDSg(res.getName(), Integer.valueOf(res.getDbId()), genN);
                dSg.setIncompleteSegment(true);
                entityId.addSegment((EZSegment)dSg);
                EZSourceDataset.setLIBProperty((EZObjectType)inputType, (String)res.getQualifierName());
                inputType.addProperty("dataset from File Control Table, FCT", (Object)(res.getDbId() == -1 ? Boolean.TRUE : Boolean.FALSE));
            }
        }
        if (inputType != null) {
            inputType.setEntID(entityId);
            EZSourceProjectIDSg ezsourcePrjSg = new EZSourceProjectIDSg(projectInfo);
            entityId.getSegments().add(0, ezsourcePrjSg);
        }
        return inputType;
    }

    private void exportResultsToCSV(IProgressMonitor pmonitor, String fileNamePath) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        Collection ret = (Collection)this.resAnnotations.getInput();
        if (ret != null && !ret.isEmpty()) {
            monitor.setWorkRemaining(ret.size() * 100);
            CSVWriter csvWriter = CSVWriter.open((File)new File(fileNamePath));
            if (csvWriter != null) {
                if (ret instanceof ArrayList) {
                    Iterator iterator = ((ArrayList)ret).iterator();
                    while (iterator.hasNext()) {
                        String cfr_ignored_0 = (String)iterator.next();
                        if (!monitor.isCanceled()) {
                            continue;
                        }
                        break;
                    }
                } else if (ret instanceof Set) {
                    Iterator iterator = ((Set)ret).iterator();
                    while (iterator.hasNext()) {
                        EZAnnotation cfr_ignored_1 = (EZAnnotation)iterator.next();
                        if (!monitor.isCanceled()) {
                            continue;
                        }
                        break;
                    }
                }
                this.writeResultsToCSV((IProgressMonitor)monitor.newChild(100), csvWriter);
                csvWriter.close();
                if (!csvWriter.isExportOK()) {
                    monitor.setCanceled(true);
                }
            } else {
                monitor.setCanceled(true);
            }
        }
    }

    private void writeResultsToCSV(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        Collection ret = (Collection)this.resAnnotations.getInput();
        String noResLine = "\"";
        if (ret instanceof ArrayList) {
            ArrayList res = (ArrayList)ret;
            for (String resStr : res) {
                noResLine = String.valueOf(noResLine) + resStr;
            }
            noResLine = String.valueOf(noResLine) + "\"";
            csvWriter.write(new String[]{noResLine});
        } else if (ret instanceof Set) {
            for (EZAnnotation ezAnn : (Set)ret) {
                String doubleQ;
                String ezAnnName = null;
                String ezAnnDescription = null;
                String ezAnnDate = null;
                String ezAnnKeywords = null;
                if (ezAnn.getName() == null || ezAnn.getName().isEmpty()) {
                    ezAnnName = "";
                } else if (ezAnn.getName().contains("\"")) {
                    doubleQ = ezAnn.getName().replace("\"", "\"\"");
                    ezAnnName = "\"" + doubleQ + "\"";
                } else {
                    ezAnnName = "\"" + ezAnn.getName() + "\"";
                }
                if (ezAnn.getDescription() == null || ezAnn.getDescription().isEmpty()) {
                    ezAnnDescription = "";
                } else if (ezAnn.getDescription().contains("\"")) {
                    doubleQ = ezAnn.getDescription().replace("\"", "\"\"");
                    ezAnnDescription = "\"" + doubleQ + "\"";
                } else {
                    ezAnnDescription = "\"" + ezAnn.getDescription() + "\"";
                }
                ezAnnDate = ezAnn.getDate() == null ? "" : "\"" + ezAnn.getDate().toString() + "\"";
                StringBuilder build = new StringBuilder();
                if (ezAnn.getKeywords() != null) {
                    for (EZKeyword key : ezAnn.getKeywords()) {
                        build.append(key.getName());
                        build.append(";");
                    }
                }
                if (build.length() == 0) {
                    ezAnnKeywords = "";
                } else if (build.toString().contains("\"")) {
                    String doubleQ2 = build.toString().replace("\"", "\"\"");
                    ezAnnKeywords = "\"" + doubleQ2 + "\"";
                } else {
                    ezAnnKeywords = "\"" + build.substring(0, build.length() - 1) + "\"";
                }
                ArrayList<String> resourceList = new ArrayList<String>();
                Set prj = null;
                TreeSet<AnnResource> sortedPrj = null;
                if (ezAnn.getResources() != null) {
                    prj = ezAnn.getResources();
                    sortedPrj = new TreeSet<AnnResource>(new AnnResComparator());
                    for (AnnResource ann : prj) {
                        sortedPrj.add(ann);
                    }
                }
                AnnResource lastAnn = null;
                String annResourceInfo = null;
                if (sortedPrj != null) {
                    for (AnnResource ann : sortedPrj) {
                        if (lastAnn != null) {
                            if (lastAnn.getResourceTypeName().compareTo(ann.getResourceTypeName()) == 0) {
                                if (lastAnn.getName().compareTo(ann.getName()) == 0) {
                                    resourceList.remove(annResourceInfo);
                                    annResourceInfo = String.valueOf(annResourceInfo) + ann.getProjectInfo() + " ";
                                    resourceList.add(annResourceInfo);
                                } else {
                                    annResourceInfo = String.valueOf(ann.getResourceTypeName()) + ":";
                                    annResourceInfo = String.valueOf(annResourceInfo) + ann.getName() + ":";
                                    annResourceInfo = String.valueOf(annResourceInfo) + ann.getProjectInfo() + " ";
                                    resourceList.add(annResourceInfo);
                                }
                            } else {
                                annResourceInfo = String.valueOf(ann.getResourceTypeName()) + ":";
                                annResourceInfo = String.valueOf(annResourceInfo) + ann.getName() + ":";
                                annResourceInfo = String.valueOf(annResourceInfo) + ann.getProjectInfo() + " ";
                                resourceList.add(annResourceInfo);
                            }
                        } else {
                            annResourceInfo = String.valueOf(ann.getResourceTypeName()) + ":";
                            annResourceInfo = String.valueOf(annResourceInfo) + ann.getName() + ":";
                            annResourceInfo = String.valueOf(annResourceInfo) + ann.getProjectInfo() + " ";
                            resourceList.add(annResourceInfo);
                        }
                        lastAnn = ann;
                    }
                }
                build = new StringBuilder();
                build.append("\"");
                for (String annResInfo : resourceList) {
                    build.append(annResInfo);
                    build.append(";");
                }
                csvWriter.write(new String[]{ezAnnName, ezAnnDescription, ezAnnDate, ezAnnKeywords, build.substring(0, build.length() - 1).toString().concat("\"")});
            }
        }
    }

    private void selectResource(ISelection resSelection) {
        if (!resSelection.isEmpty()) {
            TreeSet<String> projects = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            Node firstN = (Node)((StructuredSelection)resSelection).getFirstElement();
            for (AnnResource res : firstN.details) {
                projects.add(res.getProjectInfo());
            }
            for (Node n : (StructuredSelection)resSelection) {
                HashSet<String> tmp = new HashSet<String>();
                for (AnnResource res : n.details) {
                    tmp.add(res.getProjectInfo());
                }
                projects.retainAll(tmp);
            }
            this.resPrj.setInput(projects);
            this.resPrj.getList().select(0);
            this.makeContextForAnalyzes();
        } else {
            this.resPrj.setInput((Object)Messages.getString(FindAnnViewer.class, "noResource.entry"));
            this.cleanContext();
        }
    }

    private void selectAnnotation(ISelection selection) {
        StructuredSelection sel = (StructuredSelection)selection;
        this.currentAnn = sel.getFirstElement() instanceof EZAnnotation ? (EZAnnotation)sel.getFirstElement() : null;
        this.fillAnnDetails(this.currentAnn);
    }

    private void chooseResourceType(Button resTypeButton) {
        ResTypeDialog resTypeDialog = new ResTypeDialog(resTypeButton.getShell(), resTypes, (List)this.resTypeTxt.getData());
        int dialogId = resTypeDialog.open();
        if (dialogId == 0) {
            this.fillResourceTypes(resTypeDialog.getResourceType());
        }
        this.checkSearchBtn();
    }

    private void fillResults(Collection<?> anns) {
        this.resAnnotations.setInput(anns);
        this.defaultSelectionOnSearch();
        this.exportButton.setEnabled(true);
        this.exportButton.setImage(this.imgRegistry.get(EXPORT_RESULTS_AREA_IMG_KEY));
    }

    public String getProjectNames4Audit() {
        return this.selectedProject;
    }

    public String getOperationName() {
        return AnalysisType.FIND_ANNOTATION.toString();
    }

    public Integer getOperationCode() {
        return AnalysisType.FIND_ANNOTATION.getOperationCode();
    }

    class AnnResComparator
    implements Comparator<AnnResource> {
        AnnResComparator() {
        }

        @Override
        public int compare(AnnResource res1, AnnResource res2) {
            if (res1.getResourceTypeName().compareTo(res2.getResourceTypeName()) == 0) {
                if (res1.getName().compareToIgnoreCase(res2.getName()) == 0) {
                    return res1.getProjectInfo().compareToIgnoreCase(res2.getProjectInfo());
                }
                return res1.getName().compareToIgnoreCase(res2.getName());
            }
            return res1.getResourceTypeName().compareTo(res2.getResourceTypeName());
        }
    }

    class AnnSelectionListener
    implements ISelectionChangedListener {
        AnnSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            FindAnnViewer.this.selectAnnotation(selection);
        }
    }

    class EZAnnContentProvider
    implements IStructuredContentProvider {
        EZAnnContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Collection v = (Collection)inputElement;
            return v.toArray();
        }
    }

    class EZAnnLblProvider
    extends LabelProvider {
        EZAnnLblProvider() {
        }

        public String getText(Object element) {
            return element instanceof EZAnnotation ? ((EZAnnotation)element).getName() : element.toString();
        }
    }

    class EZAnnViewerSorter
    extends ViewerSorter {
        EZAnnViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof EZAnnotation && e2 instanceof EZAnnotation) {
                int ret = -1;
                EZAnnotation o1 = (EZAnnotation)e1;
                EZAnnotation o2 = (EZAnnotation)e2;
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 != null && !name1.isEmpty()) {
                    ret = name1.compareTo(name2);
                } else {
                    int n = ret = name2 == null || name2.isEmpty() ? 0 : 1;
                }
                if (ret == 0) {
                    String desc1 = o1.getDescription();
                    String desc2 = o2.getDescription();
                    ret = desc1 != null && !desc1.isEmpty() ? (desc2 == null || desc2.isEmpty() ? 1 : desc1.compareTo(desc2)) : (desc2 == null || desc2.isEmpty() ? 0 : -1);
                    if (ret == 0) {
                        ret = o1.getAID().compareTo(o2.getAID());
                    }
                }
                return ret;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class Node {
        String type;
        String name;
        boolean isRoot = false;
        Set<AnnResource> details = new HashSet<AnnResource>();

        public Node(String type) {
            this.type = type;
            this.isRoot = true;
        }

        public Node(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    class ProjectContentProvider
    implements IStructuredContentProvider {
        ProjectContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            int index = 0;
            Object[] elements = null;
            if (inputElement instanceof Set) {
                return ((Set)inputElement).toArray();
            }
            if (elements == null) {
                elements = new String[index + 1];
            }
            elements[index] = "";
            return elements;
        }
    }

    class ResourcesContentProvider
    implements ITreeContentProvider {
        Map<String, Map<String, Set<AnnResource>>> grouped;

        ResourcesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] nodes = new Node[this.grouped.keySet().size()];
            int i = 0;
            ArrayList<String> tmp = new ArrayList<String>(this.grouped.keySet());
            Collections.sort(tmp, String.CASE_INSENSITIVE_ORDER);
            for (String type : tmp) {
                Node n = new Node(type);
                nodes[i] = n;
                ++i;
            }
            return nodes;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Node) {
                Node parent = (Node)parentElement;
                if (parent.isRoot) {
                    Map<String, Set<AnnResource>> tmp = this.grouped.get(parent.type);
                    Object[] result = new Node[tmp.keySet().size()];
                    int i = 0;
                    ArrayList<String> temp = new ArrayList<String>(tmp.keySet());
                    Collections.sort(temp);
                    for (String RID : temp) {
                        Iterator<AnnResource> it = tmp.get(RID).iterator();
                        AnnResource res = it.next();
                        result[i] = new Node(res.getName(), res.getResourceTypeName());
                        ((Node)result[i]).details.add(res);
                        while (it.hasNext()) {
                            res = it.next();
                            ((Node)result[i]).details.add(res);
                        }
                        ++i;
                    }
                    return result;
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Node && ((Node)element).isRoot;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Set input = (Set)newInput;
            this.grouped = new HashMap<String, Map<String, Set<AnnResource>>>();
            if (input != null) {
                for (AnnResource res : input) {
                    Set<AnnResource> tmpDet;
                    String resType = res.getResourceTypeName();
                    Map<String, Set<AnnResource>> tmp = this.grouped.get(resType);
                    if (tmp == null) {
                        tmp = new HashMap<String, Set<AnnResource>>();
                        this.grouped.put(resType, tmp);
                    }
                    if ((tmpDet = tmp.get(res.getRID())) == null) {
                        tmpDet = new HashSet<AnnResource>();
                        tmp.put(res.getRID(), tmpDet);
                    }
                    tmpDet.add(res);
                }
            }
        }
    }

    class ResourcesLabelProvider
    implements ILabelProvider {
        ResourcesLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String txt = "";
            if (element instanceof Node) {
                txt = ((Node)element).isRoot ? ((Node)element).type : ((Node)element).name;
            }
            return txt;
        }
    }
}

