/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.analysis.view;

import com.ez.ann.analysis.EZAnnotationsFilter;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.ProjectType;
import java.util.Collection;
import java.util.Map;

public class FindAnnFilter
extends EZAnnotationsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\ufffd Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    @Override
    protected boolean checkCountResources() {
        return true;
    }

    @Override
    protected boolean countResources(Collection inputs) {
        return inputs != null && inputs.size() > 0;
    }

    @Override
    protected boolean isAcceptedInput(Object inpObj, Collection<Object> inputs) {
        boolean isAccepted = false;
        if (inpObj instanceof EZSourceProjectInputType) {
            EZSourceProjectInputType pit = (EZSourceProjectInputType)inpObj;
            ProjectInfo pInfo = (ProjectInfo)pit.getProperty("PROJECT_INFO");
            if (pInfo != null) {
                Map info = pInfo.getInfo();
                if (info != null && !info.isEmpty() && info.containsKey("onMainframe") && info.containsKey("environment")) {
                    Boolean onMainframe = (Boolean)info.get("onMainframe");
                    String environment = (String)info.get("environment");
                    isAccepted = !"JVM".equals(environment) || onMainframe.booleanValue() || !ProjectType.javaWazi.equals((Object)pInfo.getType());
                } else {
                    isAccepted = true;
                }
            } else {
                isAccepted = true;
            }
        }
        if (!(inpObj instanceof EZSourceProjectInputType)) {
            isAccepted = super.isAcceptedInput(inpObj, inputs);
        }
        return isAccepted;
    }
}

