/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.analysis.gui;

import com.ez.ann.analysis.internal.Activator;
import com.ez.ann.analysis.internal.Messages;
import com.ez.ann.db.EZAnnotationDbManager;
import com.ez.ann.db.EZDbException;
import com.ez.ann.model.EZKeyword;
import com.ez.internal.utils.LogUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeywordsManagementDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(KeywordsManagementDialog.class);
    private static final String DEFAULT_TITLE = Messages.getString(KeywordsManagementDialog.class, "title");
    private static final int DIALOG_MIN_HEIGHT = 400;
    private static final int DIALOG_MIN_WIDTH = 500;
    private static final int OK_ID = 0;
    private static final String OK_LABEL = Messages.getString(KeywordsManagementDialog.class, "lblOK");
    private static final int KEYWORD_MAX_LENGTH = 100;
    private Map<String, EZKeyword> avKeywordMap = null;
    private List<String> changedKeys = null;
    private Map<String, EZKeyword> selKeywordMap = new HashMap<String, EZKeyword>();
    private Set<EZKeyword> keysJustSelected = null;
    private List<String> newKeys = null;
    private Text keyText;
    private String keyName = null;
    private org.eclipse.swt.widgets.List avList;
    private org.eclipse.swt.widgets.List selList;
    private Button addKey;
    private Button changeKey;
    private Button removeKey;
    private Button select;
    private Button addButton;
    private Button remButton;
    private Button cancelButton;

    public KeywordsManagementDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public void setKeysJustSelected(Set<EZKeyword> listFromParentDialog) {
        this.keysJustSelected = listFromParentDialog;
    }

    public Set<EZKeyword> getKeysJustSelected() {
        return this.keysJustSelected;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DEFAULT_TITLE);
        newShell.setSize(500, 400);
        Rectangle rect = newShell.getParent().getBounds();
        newShell.setLocation(rect.x + rect.width / 4, rect.y + rect.height / 6);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        area.setLayoutData((Object)data);
        GridLayout gl = (GridLayout)area.getLayout();
        gl.numColumns = 6;
        gl.makeColumnsEqualWidth = true;
        area.setLayout((Layout)gl);
        this.createAvailableKeyGroup(area);
        this.createButtonsGroup(area);
        this.createSelectedKeyGroup(area);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.select = this.createButton(parent, 0, OK_LABEL, true);
        this.select.setEnabled(true);
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createAvailableKeyGroup(Composite parent) {
        Group availableGroup = new Group(parent, 0);
        availableGroup.setText(Messages.getString(KeywordsManagementDialog.class, "lblKeysGroup"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        availableGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        gl.makeColumnsEqualWidth = true;
        availableGroup.setLayout((Layout)gl);
        Composite composite1 = new Composite((Composite)availableGroup, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        composite1.setLayoutData((Object)data);
        gl = new GridLayout();
        composite1.setLayout((Layout)gl);
        this.addKey = new Button(composite1, 8);
        this.addKey.setText(Messages.getString(KeywordsManagementDialog.class, "btnAdd"));
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.addKey.setLayoutData((Object)data);
        this.addKey.setEnabled(false);
        this.addKey.addSelectionListener((SelectionListener)new AddKeyListener());
        this.changeKey = new Button(composite1, 8);
        this.changeKey.setText(Messages.getString(KeywordsManagementDialog.class, "btnChange"));
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        data.grabExcessHorizontalSpace = true;
        this.changeKey.setLayoutData((Object)data);
        this.changeKey.setEnabled(false);
        this.changeKey.addSelectionListener((SelectionListener)new ChangeKeyListener());
        this.removeKey = new Button(composite1, 8);
        this.removeKey.setText(Messages.getString(KeywordsManagementDialog.class, "btnRemove"));
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.removeKey.setLayoutData((Object)data);
        this.removeKey.setEnabled(false);
        this.removeKey.addSelectionListener((SelectionListener)new DeleteKeyListener());
        Composite composite2 = new Composite((Composite)availableGroup, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        composite2.setLayoutData((Object)data);
        gl = new GridLayout();
        composite2.setLayout((Layout)gl);
        this.keyText = new Text(composite2, 2052);
        this.keyText.setTextLimit(100);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.keyText.setLayoutData((Object)data);
        this.keyText.addModifyListener((ModifyListener)new NewKeyListener());
        this.avList = new org.eclipse.swt.widgets.List(composite2, 66308);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.avList.setLayoutData((Object)data);
        this.avList.addSelectionListener((SelectionListener)new AvailableKeySelectionListener());
        this.fillUI();
    }

    private void fillUI() {
        Set allKeySt = null;
        try {
            allKeySt = EZAnnotationDbManager.getInstance().getAllKeywords((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            L.error("error getting all keywords", (Throwable)ex);
            LogUtil.displayErrorMessage((Throwable)ex, (String)EZAnnotationDbManager.GET_KEYWORDS_ERROR, (Plugin)Activator.getDefault(), (boolean)false);
        }
        if (allKeySt != null && allKeySt.size() > 0) {
            String[] allKeys = new String[allKeySt.size()];
            ArrayList tmp = new ArrayList(allKeySt);
            Collections.sort(tmp);
            int i = 0;
            for (EZKeyword key : tmp) {
                if (this.avKeywordMap == null) {
                    this.avKeywordMap = new HashMap<String, EZKeyword>();
                }
                allKeys[i++] = key.getName();
                this.avKeywordMap.put(key.getName(), key);
            }
            this.avList.setItems(allKeys);
        }
    }

    private void createButtonsGroup(Composite parent) {
        Composite buttonsGroup = new Composite(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        buttonsGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 100;
        buttonsGroup.setLayout((Layout)gl);
        this.addButton = new Button(buttonsGroup, 8);
        this.addButton.setText(Messages.getString(KeywordsManagementDialog.class, "btnFw"));
        this.addButton.setEnabled(false);
        data = new GridData();
        data.horizontalSpan = 1;
        data.verticalAlignment = 0x1000000;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIdx = KeywordsManagementDialog.this.avList.getSelectionIndex();
                if (selIdx != -1) {
                    String selStr = KeywordsManagementDialog.this.avList.getItem(selIdx);
                    KeywordsManagementDialog.this.avList.remove(selIdx);
                    KeywordsManagementDialog.this.addButton.setEnabled(false);
                    KeywordsManagementDialog.this.selList.add(selStr);
                    if (KeywordsManagementDialog.this.avKeywordMap != null && KeywordsManagementDialog.this.avKeywordMap.containsKey(selStr)) {
                        KeywordsManagementDialog.this.selKeywordMap.put(selStr, (EZKeyword)KeywordsManagementDialog.this.avKeywordMap.get(selStr));
                    } else {
                        KeywordsManagementDialog.this.selKeywordMap.put(selStr, null);
                    }
                    KeywordsManagementDialog.this.removeKey.setEnabled(false);
                    KeywordsManagementDialog.this.changeKey.setEnabled(false);
                    boolean enableAdd = KeywordsManagementDialog.this.noDuplicateKey();
                    KeywordsManagementDialog.this.addKey.setEnabled(enableAdd);
                    KeywordsManagementDialog.this.selList.select(KeywordsManagementDialog.this.selList.indexOf(selStr));
                    KeywordsManagementDialog.this.remButton.setEnabled(true);
                }
            }
        });
        this.remButton = new Button(buttonsGroup, 8);
        this.remButton.setText(Messages.getString(KeywordsManagementDialog.class, "btnBack"));
        this.remButton.setLayoutData((Object)data);
        this.remButton.setEnabled(false);
        this.remButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIdx = KeywordsManagementDialog.this.selList.getSelectionIndex();
                if (selIdx != -1) {
                    String selStr = KeywordsManagementDialog.this.selList.getItem(selIdx);
                    KeywordsManagementDialog.this.selList.remove(selIdx);
                    KeywordsManagementDialog.this.remButton.setEnabled(false);
                    KeywordsManagementDialog.this.selKeywordMap.remove(selStr);
                    KeywordsManagementDialog.this.avList.add(selStr);
                    KeywordsManagementDialog.this.removeKey.setEnabled(true);
                    KeywordsManagementDialog.this.changeKey.setEnabled(false);
                    KeywordsManagementDialog.this.addKey.setEnabled(false);
                    KeywordsManagementDialog.this.avList.select(KeywordsManagementDialog.this.avList.indexOf(selStr));
                    KeywordsManagementDialog.this.addButton.setEnabled(true);
                }
            }
        });
    }

    private void createSelectedKeyGroup(Composite parent) {
        Group selectedGroup = new Group(parent, 0);
        selectedGroup.setText(Messages.getString(KeywordsManagementDialog.class, "lblSelKeysGroup"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        selectedGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 10;
        selectedGroup.setLayout((Layout)gl);
        this.selList = new org.eclipse.swt.widgets.List((Composite)selectedGroup, 66308);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.selList.setLayoutData((Object)data);
        if (this.keysJustSelected != null && this.keysJustSelected.size() > 0) {
            Object[] keys = this.keysJustSelected.toArray();
            String[] itms = new String[this.keysJustSelected.size()];
            int j = 0;
            while (j < keys.length) {
                itms[j] = ((EZKeyword)keys[j]).getName();
                this.selKeywordMap.put(itms[j], (EZKeyword)keys[j]);
                if (this.avList.indexOf(itms[j]) != -1) {
                    this.avList.remove(itms[j]);
                }
                ++j;
            }
            this.selList.setItems(itms);
            if (this.avList.getItemCount() == 0) {
                this.addButton.setEnabled(false);
            }
        }
        this.selList.addSelectionListener((SelectionListener)new SelectedKeySelectionListener());
    }

    protected void okPressed() {
        HashSet<EZKeyword> keysSet = null;
        if (this.changedKeys != null && this.changedKeys.size() > 0) {
            for (String name : this.changedKeys) {
                EZKeyword keyword = null;
                if (this.avKeywordMap != null && this.avKeywordMap.containsKey(name)) {
                    keyword = this.avKeywordMap.get(name);
                    keyword.setName(name);
                } else {
                    keyword = new EZKeyword(name);
                }
                if (keysSet == null) {
                    keysSet = new HashSet();
                }
                keysSet.add(keyword);
                if (!this.selKeywordMap.containsKey(name)) continue;
                this.selKeywordMap.put(name, keyword);
            }
        }
        if (this.newKeys != null && this.newKeys.size() > 0) {
            for (String keyName : this.newKeys) {
                EZKeyword key = new EZKeyword(keyName);
                if (keysSet == null) {
                    keysSet = new HashSet<EZKeyword>();
                }
                keysSet.add(key);
            }
        }
        try {
            if (keysSet != null && keysSet.size() > 0) {
                EZAnnotationDbManager.getInstance().saveKeywords((Set)keysSet, (IProgressMonitor)new NullProgressMonitor());
            }
            this.keysJustSelected.clear();
            if (this.selKeywordMap.size() > 0) {
                if (keysSet != null && keysSet.size() > 0) {
                    for (EZKeyword k : keysSet) {
                        if (!this.selKeywordMap.containsKey(k.getName())) continue;
                        this.selKeywordMap.put(k.getName(), k);
                    }
                    keysSet.clear();
                }
                Set<String> nameSet = this.selKeywordMap.keySet();
                String[] items = new String[nameSet.size()];
                items = nameSet.toArray(items);
                int i = 0;
                while (i < nameSet.size()) {
                    this.keysJustSelected.add(this.selKeywordMap.get(items[i]));
                    ++i;
                }
            }
        }
        catch (Exception dbe) {
            L.error("error saving keywords", (Throwable)dbe);
            LogUtil.displayErrorMessage((Throwable)dbe, (String)EZAnnotationDbManager.SAVE_KEYWORDS_ERROR, (Plugin)Activator.getDefault(), (boolean)false);
        }
        super.okPressed();
    }

    private boolean isStringInList(String str, List<String> list) {
        if (list != null) {
            for (String s : list) {
                if (!s.equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean noDuplicateKey() {
        boolean all = false;
        List<String> forbiddenFirstCharacter = Arrays.asList("@", "=", "+", "-");
        if (this.keyName != null && !this.keyName.isEmpty() && forbiddenFirstCharacter.contains(this.keyName.substring(0, 1))) {
            return false;
        }
        if (!"".equals(this.keyName) && this.keyName != null) {
            all = true;
            String[] items = this.avList.getItems();
            int i = 0;
            while (i < items.length) {
                if (this.keyName.equalsIgnoreCase(items[i])) {
                    all = false;
                    break;
                }
                ++i;
            }
            if (all) {
                items = this.selList.getItems();
                i = 0;
                while (i < items.length) {
                    if (this.keyName.equalsIgnoreCase(items[i])) {
                        all = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return all;
    }

    private class AddKeyListener
    extends SelectionAdapter {
        private AddKeyListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            KeywordsManagementDialog.this.avList.add(KeywordsManagementDialog.this.keyName);
            int idx = KeywordsManagementDialog.this.avList.indexOf(KeywordsManagementDialog.this.keyName);
            if (idx != -1) {
                KeywordsManagementDialog.this.avList.setSelection(idx);
            }
            KeywordsManagementDialog.this.addButton.setEnabled(true);
            if (KeywordsManagementDialog.this.newKeys == null) {
                KeywordsManagementDialog.this.newKeys = new ArrayList();
            }
            KeywordsManagementDialog.this.newKeys.add(KeywordsManagementDialog.this.keyName);
            KeywordsManagementDialog.this.addKey.setEnabled(false);
            KeywordsManagementDialog.this.changeKey.setEnabled(false);
            KeywordsManagementDialog.this.removeKey.setEnabled(true);
        }
    }

    private class AvailableKeySelectionListener
    extends SelectionAdapter {
        private AvailableKeySelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String[] str = ((org.eclipse.swt.widgets.List)e.widget).getSelection();
            if (str.length > 0) {
                KeywordsManagementDialog.this.removeKey.setEnabled(true);
                KeywordsManagementDialog.this.addButton.setEnabled(true);
                KeywordsManagementDialog.this.keyText.setText(str[0]);
            }
        }
    }

    private class ChangeKeyListener
    extends SelectionAdapter {
        private ChangeKeyListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!KeywordsManagementDialog.this.keyName.equals("") && KeywordsManagementDialog.this.noDuplicateKey()) {
                int idx = KeywordsManagementDialog.this.avList.getSelectionIndex();
                String selStr = null;
                if (idx != -1) {
                    selStr = KeywordsManagementDialog.this.avList.getItem(idx);
                    KeywordsManagementDialog.this.avList.remove(selStr);
                    if (KeywordsManagementDialog.this.avList.getItemCount() == 0) {
                        KeywordsManagementDialog.this.addButton.setEnabled(false);
                    }
                }
                KeywordsManagementDialog.this.avList.add(KeywordsManagementDialog.this.keyName);
                KeywordsManagementDialog.this.avList.setSelection(KeywordsManagementDialog.this.avList.indexOf(KeywordsManagementDialog.this.keyName));
                KeywordsManagementDialog.this.addButton.setEnabled(true);
                if (KeywordsManagementDialog.this.avKeywordMap != null && KeywordsManagementDialog.this.avKeywordMap.containsKey(selStr)) {
                    KeywordsManagementDialog.this.avKeywordMap.put(KeywordsManagementDialog.this.keyName, (EZKeyword)KeywordsManagementDialog.this.avKeywordMap.get(selStr));
                    KeywordsManagementDialog.this.avKeywordMap.remove(selStr);
                }
                if (KeywordsManagementDialog.this.changedKeys == null) {
                    KeywordsManagementDialog.this.changedKeys = new ArrayList();
                }
                if (KeywordsManagementDialog.this.isStringInList(selStr, KeywordsManagementDialog.this.newKeys)) {
                    KeywordsManagementDialog.this.newKeys.remove(selStr);
                }
                if (KeywordsManagementDialog.this.isStringInList(selStr, KeywordsManagementDialog.this.changedKeys)) {
                    KeywordsManagementDialog.this.changedKeys.remove(selStr);
                }
                KeywordsManagementDialog.this.changedKeys.add(KeywordsManagementDialog.this.keyName);
                KeywordsManagementDialog.this.keyText.setText("");
            }
            KeywordsManagementDialog.this.changeKey.setEnabled(false);
            KeywordsManagementDialog.this.removeKey.setEnabled(true);
        }
    }

    private class DeleteKeyListener
    extends SelectionAdapter {
        private DeleteKeyListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int idx = KeywordsManagementDialog.this.avList.getSelectionIndex();
            if (idx != -1) {
                String txt = KeywordsManagementDialog.this.avList.getItem(idx);
                try {
                    EZKeyword keyword;
                    if (KeywordsManagementDialog.this.avKeywordMap != null && (keyword = (EZKeyword)KeywordsManagementDialog.this.avKeywordMap.get(txt)) != null) {
                        EZAnnotationDbManager.getInstance().deleteKeyword(keyword, (IProgressMonitor)new NullProgressMonitor());
                        KeywordsManagementDialog.this.avKeywordMap.remove(txt);
                    }
                    if (KeywordsManagementDialog.this.isStringInList(txt, KeywordsManagementDialog.this.newKeys)) {
                        KeywordsManagementDialog.this.newKeys.remove(txt);
                    }
                    if (KeywordsManagementDialog.this.isStringInList(txt, KeywordsManagementDialog.this.changedKeys)) {
                        KeywordsManagementDialog.this.changedKeys.remove(txt);
                    }
                    KeywordsManagementDialog.this.avList.remove(idx);
                    if (KeywordsManagementDialog.this.avList.getItemCount() == 0) {
                        KeywordsManagementDialog.this.addButton.setEnabled(false);
                    }
                    if (KeywordsManagementDialog.this.keysJustSelected != null) {
                        EZKeyword annKey = null;
                        for (EZKeyword k : KeywordsManagementDialog.this.keysJustSelected) {
                            annKey = k;
                            if (annKey.getName().equals(txt)) {
                                KeywordsManagementDialog.this.cancelButton.setEnabled(false);
                                break;
                            }
                            annKey = null;
                        }
                        if (annKey != null) {
                            KeywordsManagementDialog.this.keysJustSelected.remove(annKey);
                        }
                    }
                    KeywordsManagementDialog.this.removeKey.setEnabled(false);
                    KeywordsManagementDialog.this.changeKey.setEnabled(false);
                    KeywordsManagementDialog.this.addButton.setEnabled(false);
                    KeywordsManagementDialog.this.keyText.setText("");
                }
                catch (EZDbException ex) {
                    if (ex.getType() == EZDbException.KEYWORD_HAS_ANNOTATIONS) {
                        L.info("keyword cannot be deleted while is associated with annotations", (Throwable)ex);
                        MessageBox dialog = new MessageBox(KeywordsManagementDialog.this.getShell(), 40);
                        dialog.setText(Messages.getString(KeywordsManagementDialog.class, "keysBoxTitle"));
                        String msg = Messages.getString(KeywordsManagementDialog.class, "keysBoxTxt", new String[]{txt});
                        dialog.setMessage(msg);
                        dialog.open();
                    } else {
                        L.error("error while deleting keyword", (Throwable)ex);
                    }
                }
                catch (SQLException e1) {
                    L.error("error while deleting keyword", (Throwable)e1);
                }
            }
        }
    }

    private class NewKeyListener
    implements ModifyListener {
        private NewKeyListener() {
        }

        public void modifyText(ModifyEvent e) {
            boolean shouldEnableAdd = false;
            KeywordsManagementDialog.this.keyName = KeywordsManagementDialog.this.keyText.getText().trim();
            if (KeywordsManagementDialog.this.noDuplicateKey()) {
                shouldEnableAdd = true;
            }
            KeywordsManagementDialog.this.addKey.setEnabled(shouldEnableAdd);
            KeywordsManagementDialog.this.changeKey.setEnabled(shouldEnableAdd && KeywordsManagementDialog.this.avList.getSelectionCount() > 0);
        }
    }

    private class SelectedKeySelectionListener
    extends SelectionAdapter {
        private SelectedKeySelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String[] str = ((org.eclipse.swt.widgets.List)e.widget).getSelection();
            if (str.length > 0) {
                KeywordsManagementDialog.this.remButton.setEnabled(true);
            }
        }
    }
}

