/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.analysis.gui;

import com.ez.ann.analysis.gui.KeywordsManagementDialog;
import com.ez.ann.analysis.internal.Activator;
import com.ez.ann.analysis.internal.Messages;
import com.ez.ann.db.EZAnnotationDbManager;
import com.ez.ann.model.AnnResource;
import com.ez.ann.model.Constants;
import com.ez.ann.model.EZAnnotation;
import com.ez.ann.model.EZKeyword;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.LogUtil;
import com.ez.workspace.state.AEvent;
import com.ez.workspace.state.EZAnnotationEvent;
import com.ez.workspace.state.EventType;
import com.ez.workspace.state.StateManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAnnDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AddAnnDialog.class);
    private static final int DIALOG_MIN_WIDTH = 550;
    private static final int DIALOG_MIN_HEIGHT = 400;
    private Cursor cursorArrow = null;
    private Cursor cursorWait = null;
    Set<AnnResource> resrs = null;
    private Set<EZKeyword> keysList = new HashSet<EZKeyword>();
    ListViewer resV;
    ListViewer keyLst;
    private Text txtName;
    private Text txtText;
    private Text txtDate;
    private Button btnAddAnn;
    private ModifyListener modifListener = new ItemModifyListener();
    private EZAnnotation annotation;
    private List<EZEntityID> sourcesForAnnEvent;

    public AddAnnDialog(Shell parent) {
        super(parent);
    }

    public AddAnnDialog(Shell shell, Set<AnnResource> resources) {
        this(shell);
        this.resrs = resources;
    }

    public AddAnnDialog(Shell shell, EZAnnotation ann) {
        this(shell);
        this.annotation = ann;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout lay = new GridLayout(2, true);
        container.setLayout((Layout)lay);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Group topC = new Group(container, 0);
        topC.setText(Messages.getString(AddAnnDialog.class, "resources.label"));
        topC.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.heightHint = 100;
        topC.setLayoutData((Object)gd);
        this.resV = new ListViewer((Composite)topC);
        this.resV.setContentProvider((IContentProvider)new EZAnnContentProvider());
        this.resV.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.resV.setInput(this.resrs);
        this.resV.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftC = new Composite(container, 0);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        leftC.setLayoutData((Object)gd);
        this.createLeftArea(leftC);
        Composite rightC = new Composite(container, 0);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        rightC.setLayoutData((Object)gd);
        this.createRightArea(rightC);
        return container;
    }

    private void createLeftArea(Composite leftC) {
        GridLayout lay = new GridLayout(2, false);
        leftC.setLayout((Layout)lay);
        Label lbl = new Label(leftC, 0);
        lbl.setText(Messages.getString(AddAnnDialog.class, "name.label"));
        this.txtName = new Text(leftC, 2052);
        this.txtName.setTextLimit(50);
        this.txtName.addModifyListener(this.modifListener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.txtName.setLayoutData((Object)gd);
        lbl = new Label(leftC, 0);
        lbl.setText(Messages.getString(AddAnnDialog.class, "text.label"));
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 128;
        lbl.setLayoutData((Object)gd);
        this.txtText = new Text(leftC, 2818);
        this.txtText.setTextLimit(500);
        this.txtText.addModifyListener(this.modifListener);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 200;
        gd.heightHint = 70;
        this.txtText.setLayoutData((Object)gd);
    }

    private void createRightArea(Composite rightC) {
        GridLayout lay = new GridLayout(3, false);
        rightC.setLayout((Layout)lay);
        Label lbl = new Label(rightC, 0);
        lbl.setText(Messages.getString(AddAnnDialog.class, "date.label"));
        this.txtDate = new Text(rightC, 2060);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        this.txtDate.setLayoutData((Object)gd);
        Group keyGrp = new Group(rightC, 0);
        keyGrp.setText(Messages.getString(AddAnnDialog.class, "keywords.label"));
        keyGrp.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.widthHint = 230;
        gd.heightHint = 120;
        keyGrp.setLayoutData((Object)gd);
        this.keyLst = new ListViewer((Composite)keyGrp, 2816);
        this.keyLst.setContentProvider((IContentProvider)new EZAnnContentProvider());
        this.keyLst.setLabelProvider((IBaseLabelProvider)new KeyLabelProvider());
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 130;
        this.keyLst.getList().setLayoutData((Object)gd);
        Button btnKeys = new Button((Composite)keyGrp, 8);
        btnKeys.setText(Messages.getString(AddAnnDialog.class, "manage.button"));
        btnKeys.addSelectionListener((SelectionListener)new KeywordAdapter());
        gd = new GridData();
        gd.verticalAlignment = 128;
        btnKeys.setLayoutData((Object)gd);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.fillUI();
        this.checkCreateAvailability();
        return c;
    }

    private void fillUI() {
        this.keysList.clear();
        Date time = Calendar.getInstance().getTime();
        this.txtDate.setText(Constants.df.format(time));
        this.txtDate.setData((Object)time);
        if (this.annotation != null) {
            this.txtName.setText(this.annotation.getName());
            if (this.annotation.getDescription() != null) {
                this.txtText.setText(this.annotation.getDescription());
            } else {
                this.txtText.setText("");
            }
            this.resV.setInput((Object)this.annotation.getResources());
            this.keyLst.setInput((Object)this.annotation.getKeywords());
            if (this.annotation.getKeywords() != null) {
                this.keysList.addAll(this.annotation.getKeywords());
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnAddAnn = this.createButton(parent, 0, Messages.getString(AddAnnDialog.class, "save.button"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = this.annotation != null ? Messages.getString(AddAnnDialog.class, "dialog.title.update") : Messages.getString(AddAnnDialog.class, "dialog.title.insert");
        newShell.setText(title);
        newShell.setMinimumSize(550, 400);
    }

    private void initCursors() {
        Display display = Display.getDefault();
        if (this.cursorWait == null) {
            this.cursorWait = new Cursor((Device)display, 1);
        }
        if (this.cursorArrow == null) {
            this.cursorArrow = new Cursor((Device)display, 0);
        }
    }

    protected void okPressed() {
        this.createAnnotation();
        super.okPressed();
    }

    private void createAnnotation() {
        EZAnnotation ann;
        final long startTime = System.currentTimeMillis();
        L.info("Create/edit annotation start time: {}", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        EZAnnotation eZAnnotation = ann = this.annotation == null ? new EZAnnotation() : this.annotation;
        if (!this.txtName.getText().isEmpty()) {
            ann.setName(this.txtName.getText().trim());
        }
        if (this.txtText.getText() != null && !this.txtText.getText().isEmpty()) {
            ann.setDescription(this.txtText.getText().trim());
        }
        ann.setDate((Date)this.txtDate.getData());
        Collection keys = (Collection)this.keyLst.getInput();
        if (keys != null && !keys.isEmpty()) {
            ann.setKeywords(keys);
        } else {
            ann.setKeywords(new ArrayList());
        }
        Set resrs = (Set)this.resV.getInput();
        if (resrs != null) {
            ann.setResources(resrs);
        }
        Job j = new Job(Messages.getString(AddAnnDialog.class, "save.annotation")){

            protected IStatus run(IProgressMonitor monitor) {
                Exception ex = null;
                try {
                    EZAnnotationDbManager.getInstance().saveAnn(ann, AddAnnDialog.this.annotation == null, monitor);
                    if (AddAnnDialog.this.sourcesForAnnEvent != null && !AddAnnDialog.this.sourcesForAnnEvent.isEmpty()) {
                        EZAnnotationEvent event = new EZAnnotationEvent();
                        event.setEvType(EventType.EZANNOTATION_EVENT_TYPE);
                        int i = 0;
                        while (i < AddAnnDialog.this.sourcesForAnnEvent.size()) {
                            event.addInStateMap((EZEntityID)AddAnnDialog.this.sourcesForAnnEvent.get(i), Boolean.TRUE);
                            ++i;
                        }
                        StateManager.getInstance().notify((AEvent)event);
                    }
                }
                catch (Exception e) {
                    L.error("error saving annotation", (Throwable)e);
                    ex = e;
                    LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(AddAnnDialog.class, "logview.error.detail"), (String)Messages.getString(AddAnnDialog.class, "logview.error.title"), (Plugin)Activator.getDefault());
                }
                long duration = System.currentTimeMillis() - startTime;
                L.info("Create/edit annotation duration: {}ms.", (Object)duration);
                return monitor.isCanceled() || ex != null ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    public boolean close() {
        if (this.cursorWait != null) {
            this.cursorWait.dispose();
            this.cursorWait = null;
        }
        if (this.cursorArrow != null) {
            this.cursorArrow.dispose();
            this.cursorArrow = null;
        }
        return super.close();
    }

    void checkCreateAvailability() {
        boolean available = false;
        String annName = this.txtName.getText().trim();
        String annText = this.txtText.getText().trim();
        int noTarget = this.resV.getList().getItemCount();
        List<String> forbiddenFirstCharacter = Arrays.asList("@", "=", "+", "-");
        if (annText != null && !annText.isEmpty() && forbiddenFirstCharacter.contains(annText.substring(0, 1)) || annName != null && !annName.isEmpty() && forbiddenFirstCharacter.contains(annName.substring(0, 1))) {
            this.btnAddAnn.setEnabled(available);
            return;
        }
        if (this.annotation == null) {
            available = annName != null && !annName.trim().isEmpty() && noTarget > 0;
        } else {
            boolean bl = available = !this.annotation.getName().equals(annName);
            if (!available) {
                boolean bl2 = available = this.annotation.getDescription() != null && !this.annotation.getDescription().equals(annText) || this.annotation.getDescription() == null && annText != null && !annText.isEmpty();
                if (!available) {
                    available = this.annotation.getKeywords() != null && !this.annotation.getKeywords().equals(this.keyLst.getInput()) || this.annotation.getKeywords() == null && this.keyLst.getInput() != null && !((Collection)this.keyLst.getInput()).isEmpty();
                }
            }
        }
        this.btnAddAnn.setEnabled(available);
    }

    protected boolean isResizable() {
        return true;
    }

    public void setInputs(Collection<EZObjectType> inpts) {
        this.sourcesForAnnEvent = new ArrayList<EZEntityID>();
        for (EZObjectType inpt : inpts) {
            this.sourcesForAnnEvent.add(inpt.getEntID());
        }
    }

    class EZAnnContentProvider
    implements IStructuredContentProvider {
        EZAnnContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Collection v = (Collection)inputElement;
            return v.toArray();
        }
    }

    class ItemModifyListener
    implements ModifyListener {
        ItemModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            AddAnnDialog.this.checkCreateAvailability();
        }
    }

    class KeyLabelProvider
    extends LabelProvider {
        KeyLabelProvider() {
        }

        public String getText(Object element) {
            return ((EZKeyword)element).getName();
        }
    }

    class KeywordAdapter
    extends SelectionAdapter {
        KeywordAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            AddAnnDialog.this.initCursors();
            AddAnnDialog.this.getShell().setCursor(AddAnnDialog.this.cursorWait);
            final KeywordsManagementDialog addKeys = new KeywordsManagementDialog(AddAnnDialog.this.getShell());
            HashSet tmp = new HashSet();
            if (AddAnnDialog.this.annotation != null && AddAnnDialog.this.annotation.getKeywords() != null) {
                tmp.addAll(AddAnnDialog.this.annotation.getKeywords());
            }
            addKeys.setKeysJustSelected(AddAnnDialog.this.keysList);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (addKeys.open() == 0) {
                        Set<EZKeyword> list = addKeys.getKeysJustSelected();
                        if (addKeys.close()) {
                            ((KeywordAdapter)KeywordAdapter.this).AddAnnDialog.this.keyLst.setInput(list);
                        }
                        AddAnnDialog.this.checkCreateAvailability();
                    }
                }
            });
            AddAnnDialog.this.getShell().setCursor(AddAnnDialog.this.cursorArrow);
        }
    }

    class ResourceLabelProvider
    extends LabelProvider {
        ResourceLabelProvider() {
        }

        public String getText(Object element) {
            return ((AnnResource)element).toString();
        }
    }
}

