/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.analysis.add;

import com.ez.ann.analysis.gui.AddAnnDialog;
import com.ez.ann.db.ResourceIdentificator;
import com.ez.ann.model.AnnResource;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEZAnnotationAnalysis
extends AbstractAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AddEZAnnotationAnalysis.class);
    private String projectName;

    protected void continueAnalysisForLocal() {
        Set<AnnResource> resources = this.collectResources();
        if (resources != null && !resources.isEmpty()) {
            this.openWizard(resources);
        }
    }

    private void openWizard(final Set<AnnResource> resources) {
        this.projectName = resources.iterator().next().getProjectInfo();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                List inpts = AddEZAnnotationAnalysis.this.getContextListValue("input_list");
                AddAnnDialog dialog = new AddAnnDialog(Display.getCurrent().getActiveShell(), resources);
                dialog.setInputs(inpts);
                dialog.create();
                if (dialog.open() == 0) {
                    L.debug("save started");
                    AddEZAnnotationAnalysis.this.auditAnalysis();
                } else {
                    L.debug("save canceled");
                }
            }
        });
    }

    private Set<AnnResource> collectResources() {
        List inpts = this.getContextListValue("input_list");
        if (inpts != null && !inpts.isEmpty()) {
            Set resources = ResourceIdentificator.getAnnResources((Collection)inpts);
            return resources.isEmpty() ? null : resources;
        }
        L.warn("analysis without inputs?!");
        return null;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        return null;
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.CREATE_EZANNOTATION;
    }

    public boolean scopeIsShared() {
        return false;
    }

    protected void verifyLicenseForLocal() {
        this.continueAnalysisForLocal();
    }

    public String getProjectNames4Audit() {
        return this.projectName;
    }
}

