/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.analysis;

import com.ez.internal.analysis.config.inputs.EZJobInputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.filters.MultipleMainframeProjectFilter;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZAnnotationsFilter
extends MultipleMainframeProjectFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZAnnotationsFilter.class);

    public boolean checkAnalysisAvailability(Collection inputs) {
        boolean ret;
        boolean bl = ret = inputs != null;
        if (ret) {
            if (this.checkCountResources()) {
                ret = this.countResources(inputs);
            }
            ret = ret && this.checkResources(inputs);
        }
        return ret;
    }

    protected boolean checkCountResources() {
        return false;
    }

    protected boolean countResources(Collection inputs) {
        return true;
    }

    private boolean checkResources(Collection<Object> inputs) {
        boolean checkResources = true;
        for (Object inpObj : inputs) {
            EZObjectType objType;
            EZEntityID entity;
            EZSourceProjectIDSg prjIdSg;
            if (!this.isAcceptedInput(inpObj, inputs)) {
                checkResources = false;
                break;
            }
            if (this.parameters != null && !(checkResources = this.checkProjectParameters(prjIdSg = (EZSourceProjectIDSg)(entity = (objType = (EZObjectType)inpObj).getEntID()).getSegment(EZSourceProjectIDSg.class)))) break;
        }
        return checkResources;
    }

    protected boolean isAcceptedInput(Object inpObj, Collection<Object> inputs) {
        boolean isAccepted = false;
        if (inpObj instanceof EZSourceProgram) {
            EZSourceProgram prgObj = (EZSourceProgram)inpObj;
            Boolean vb = (Boolean)prgObj.getProperty("is program scl having procedure's information");
            if (vb != null && vb.booleanValue()) {
                isAccepted = false;
            } else {
                EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)prgObj.getEntID().getSegment(EZSourceProgramIDSg.class);
                if (prgSg.getTypeId() == 19) {
                    prgObj.addProperty("program occur", (Object)(prgObj.getProperty("program_path") != null ? 1 : 0));
                    isAccepted = true;
                } else {
                    Boolean occur = (Boolean)((EZSourceProgram)inpObj).getProperty("program occur");
                    if (occur == null) {
                        L.debug("program's occur is not set for EZSourceProgram object type!");
                        occur = prgSg.getOccur();
                    }
                    if (occur != null) {
                        isAccepted = occur;
                    } else {
                        L.debug("program's occur is not set!");
                        isAccepted = false;
                    }
                }
            }
        } else if (inpObj instanceof EZJobInputType) {
            EZJobInputType jobInpt = (EZJobInputType)inpObj;
            EZSourceJobIDSg jobSg = (EZSourceJobIDSg)jobInpt.getEntID().getSegment(EZSourceJobIDSg.class);
            isAccepted = jobSg != null ? !jobSg.isDeleted() : true;
        }
        return isAccepted;
    }
}

