/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.selection;

import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.ServerType;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.selection.LogicalParser;
import com.ez.mainframe.selection.ParserException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Manager.class);
    private static Manager INSTANCE;
    public static final String ENVIRONMENT_SETTING = "env";
    public static final String LANG_SETTING = "lang";
    public static final String DB_TYPE_SETTING = "dbType";
    public static final String MAP_TYPE_SETTING = "mapType";
    public static final String EXPRESSION_SETTING = "exp";
    public static final String DB_ENGINE_SETTING = "DBEngine";
    public static final String ONLY_UCMDB_SETTING = "ucmdb";
    public static final String REQUIRES_MAINFRAME = "requiresMainframe";
    public static final String REPORTS_CATEGORY = "reports";
    public static final String STMT_TYPE_CATEGORY = "stmtType";
    public static final String SUMMARY_REPORT_DETAILS_CATEGORY = "summReport";
    public static final String CL_STATEMENTS = "2";
    public static final String COBOL_STATEMENTS = "3";
    public static final String NATURAL_STATEMENTS = "4";
    public static final String PL1_STATEMENTS = "5";
    public static final String ADABAS_STMT_VALUE = "7";
    public static final String IDMS_STMT_VALUE = "8";
    public static final String SQL_STMT_VALUE = "9";
    public static final String AIM_STMT_VALUE = "11";
    public static final String CICS_STMT_VALUE = "12";
    public static final String IMS_STMT_VALUE = "13";
    public static final String SMART_STMT_VALUE = "14";
    public static final String PRG_VS_FILES_PROC_ID = "0";
    public static final String PRG_VS_IDMS_SET_PROC_ID = "1";
    public static final String PRG_VS_IDMS_RECORD_PROC_ID = "2";
    public static final String PRG_VS_SQL_TABLE_PROC_ID = "3";
    public static final String PRG_VS_CL_FILES_PROC_ID = "4";
    public static final String PRG_VS_SMART_PROC_ID = "5";
    public static final String PRG_VS_DATACOM_TABLE_PROC_ID = "6";
    public static final String PRG_VS_IMSDB_PROC_ID = "7";
    public static final String SELECTION_PROPERTIES_FILENAME = "selection.properties";
    public static final String SELECTION_PATH_IN_PROJECT = "/config/selection.properties";
    private final String DOT = ".";
    private Properties prop = Utils.loadPropFile("/config/selection.properties");
    private Properties customProp;

    private Manager() {
        if (this.prop == null) {
            L.error("error at reading selection.properties configuration file");
            this.prop = new Properties();
        }
    }

    public boolean checkAvailability(ProjectInfo pInfo, Properties parameters) {
        Map<String, Object> prjInfo = this.getPrjInfoMap(pInfo);
        boolean ret = this.checkAvailability(prjInfo, null, null, parameters);
        return ret;
    }

    public boolean checkAvailability(Map<String, Object> prjInfo, Properties parameters) {
        boolean ret = this.checkAvailability(prjInfo, null, null, parameters);
        return ret;
    }

    public boolean checkAvailability(Map<String, Object> prjInfo, String category, String value) {
        if (prjInfo == null) {
            return true;
        }
        return this.checkAvailability(prjInfo, category, value, this.prop);
    }

    public boolean checkAvailability(ProjectInfo pInfo, String category, String value) {
        Map<String, Object> prjInfo = this.getPrjInfoMap(pInfo);
        return this.checkAvailability(prjInfo, category, value, this.prop);
    }

    private Map<String, Object> getPrjInfoMap(ProjectInfo pInfo) {
        HashMap<String, Object> prjInfo = new HashMap<String, Object>();
        prjInfo.put("projectName", pInfo.getProjectName());
        prjInfo.put("dbEngine", pInfo.getDbEngine());
        prjInfo.put("dbTypes", pInfo.getDbTypes());
        prjInfo.put("isUCMDB", pInfo.isUMCDB());
        prjInfo.put("drive", pInfo.getDrive());
        prjInfo.put("environment", pInfo.getEnvironment());
        prjInfo.put("languages", pInfo.getLanguages());
        prjInfo.put("mapTypes", pInfo.getMapTypes());
        prjInfo.put("onMainframe", pInfo.isOnMainframe());
        prjInfo.put("projectLocation", pInfo.getProjectLocation());
        if (pInfo.getDatabaseInfo() != null) {
            prjInfo.put("schemaName", pInfo.getDatabaseInfo().getSchema());
        }
        prjInfo.put("ccs_uuid", pInfo.getProjectUUID());
        return prjInfo;
    }

    boolean checkAvailability(Map<String, Object> prjInfo, String category, String value, Properties prop) {
        boolean valid = true;
        String prefix = category != null ? String.valueOf(category) + "." + value + "." : "";
        String envValue = prop.getProperty(String.valueOf(prefix) + ENVIRONMENT_SETTING);
        String langValues = prop.getProperty(String.valueOf(prefix) + LANG_SETTING);
        String dbTypeValues = prop.getProperty(String.valueOf(prefix) + DB_TYPE_SETTING);
        String mapValues = prop.getProperty(String.valueOf(prefix) + MAP_TYPE_SETTING);
        String logicalExpression = prop.getProperty(String.valueOf(prefix) + EXPRESSION_SETTING);
        String dbEngineValues = prop.getProperty(String.valueOf(prefix) + DB_ENGINE_SETTING);
        String onlyUcmdbValues = prop.getProperty(String.valueOf(prefix) + ONLY_UCMDB_SETTING);
        String requiresMainframe = prop.getProperty(String.valueOf(prefix) + REQUIRES_MAINFRAME);
        if (envValue == null && langValues == null && dbTypeValues == null && mapValues == null && dbEngineValues == null && onlyUcmdbValues == null && requiresMainframe == null) {
            return true;
        }
        boolean validEnv = true;
        boolean validLangs = true;
        boolean validDbTypes = true;
        boolean validMapTypes = true;
        boolean validDBEngine = true;
        boolean validUcmdb = true;
        boolean validMainframe = true;
        if (envValue != null) {
            validEnv = Manager.evaluateEnvironment(prjInfo, envValue.toUpperCase());
        }
        if (valid && langValues != null) {
            validLangs = Manager.evaluateLanguages(prjInfo, langValues.toUpperCase());
        }
        if (valid && dbTypeValues != null) {
            validDbTypes = Manager.evaluateDbTypes(prjInfo, dbTypeValues.toUpperCase());
        }
        if (valid && mapValues != null) {
            validMapTypes = Manager.evaluateMapTypes(prjInfo, mapValues.toUpperCase());
        }
        if (valid && dbEngineValues != null) {
            validDBEngine = Manager.evaluateDBEngine(prjInfo, dbEngineValues);
        }
        if (valid && requiresMainframe != null) {
            validMainframe = this.evaluateRequiresMainframe(prjInfo, requiresMainframe);
        }
        if (valid && logicalExpression != null) {
            HashMap<String, Boolean> variablesMap = new HashMap<String, Boolean>();
            if (envValue != null) {
                variablesMap.put(ENVIRONMENT_SETTING, new Boolean(validEnv));
            }
            if (langValues != null) {
                variablesMap.put(LANG_SETTING, new Boolean(validLangs));
            }
            if (dbTypeValues != null) {
                variablesMap.put(DB_TYPE_SETTING, new Boolean(validDbTypes));
            }
            if (mapValues != null) {
                variablesMap.put(MAP_TYPE_SETTING, new Boolean(validMapTypes));
            }
            if (mapValues != null) {
                variablesMap.put(DB_ENGINE_SETTING, new Boolean(validDBEngine));
            }
            if (mapValues != null) {
                variablesMap.put(ONLY_UCMDB_SETTING, new Boolean(validUcmdb));
            }
            if (mapValues != null) {
                variablesMap.put(REQUIRES_MAINFRAME, new Boolean(requiresMainframe));
            }
            if (!variablesMap.isEmpty()) {
                LogicalParser p = new LogicalParser(variablesMap);
                try {
                    boolean logicalExprValue = p.evaluate(logicalExpression);
                    L.info("logical Result for {} is {}", (Object)logicalExpression, (Object)logicalExprValue);
                    valid = logicalExprValue;
                }
                catch (ParserException exc) {
                    L.error("checkAvailability for: category={}, value={}", new Object[]{category, value, exc});
                }
            }
        } else {
            valid = validEnv && validLangs && validDbTypes && validMapTypes && validDBEngine && validUcmdb && validMainframe;
        }
        return valid;
    }

    private boolean evaluateRequiresMainframe(ProjectInfo prjInfo, String requiresMainframe) {
        boolean isOnMainframe = prjInfo.isOnMainframe();
        return this.evaluateRequiresMainframe(isOnMainframe, requiresMainframe);
    }

    private boolean evaluateRequiresMainframe(Map<String, Object> prjInfo, String requiresMainframe) {
        Boolean isOnMainframe = (Boolean)prjInfo.get("onMainframe");
        return this.evaluateRequiresMainframe(isOnMainframe, requiresMainframe);
    }

    private boolean evaluateRequiresMainframe(boolean isOnMainframe, String requiresMainframe) {
        boolean requires = Boolean.valueOf(requiresMainframe);
        if (requires) {
            return isOnMainframe;
        }
        return true;
    }

    public static boolean evaluateMapTypes(ProjectInfo prjInfo, String value) {
        List prjMapTypes = prjInfo.getMapTypes();
        return Manager.evaluateMapTypes(prjInfo.getProjectName(), prjMapTypes, value);
    }

    public static boolean evaluateMapTypes(Map<String, Object> prjInfo, String value) {
        List prjMapTypes = (List)prjInfo.get("mapTypes");
        String prjName = (String)prjInfo.get("projectName");
        return Manager.evaluateMapTypes(prjName, prjMapTypes, value);
    }

    public static boolean evaluateMapTypes(String prjName, List<String> prjMapTypes, String value) {
        boolean ret = true;
        if (prjMapTypes == null || prjMapTypes.isEmpty()) {
            L.warn("project [{}] does not have Map Types defined!!", (Object)prjName);
            ret = false;
        } else {
            String[] values = value.split(",");
            boolean noValidLang = true;
            int i = 0;
            while (i < values.length) {
                if (!prjMapTypes.contains(values[i])) {
                    L.info("project [{}] does not have a valid Map Type! ({})", (Object)prjName, (Object)values[i]);
                } else {
                    noValidLang = false;
                }
                ++i;
            }
            ret = !noValidLang;
        }
        return ret;
    }

    public static boolean evaluateDbTypes(ProjectInfo prjInfo, String value) {
        return Manager.evaluateDbTypes(prjInfo.getProjectName(), prjInfo.getDbTypes(), value);
    }

    public static boolean evaluateDbTypes(Map<String, Object> prjInfo, String value) {
        List dbtypes = (List)prjInfo.get("dbTypes");
        String prjName = (String)prjInfo.get("projectName");
        return Manager.evaluateDbTypes(prjName, dbtypes, value);
    }

    public static boolean evaluateDbTypes(String prjName, List<String> prjDbTypes, String value) {
        boolean ret = true;
        if (prjDbTypes == null || prjDbTypes.isEmpty()) {
            L.warn("project [{}] does not have DBTypes defined!!", (Object)prjName);
            ret = false;
        } else {
            String[] values = value.split(",");
            boolean noValidLang = true;
            int i = 0;
            while (i < values.length) {
                if (!prjDbTypes.contains(values[i])) {
                    L.info("project [{}] does not have a valid DBType! ({})", (Object)prjName, (Object)values[i]);
                } else {
                    noValidLang = false;
                }
                ++i;
            }
            ret = !noValidLang;
        }
        return ret;
    }

    public static boolean evaluateLanguages(ProjectInfo prjInfo, String value) {
        return Manager.evaluateLanguages(prjInfo.getProjectName(), prjInfo.getLanguages(), value);
    }

    public static boolean evaluateLanguages(Map<String, Object> prjInfo, String value) {
        List dbtypes = (List)prjInfo.get("languages");
        String prjName = (String)prjInfo.get("projectName");
        return Manager.evaluateLanguages(prjName, dbtypes, value);
    }

    public static boolean evaluateLanguages(String prjName, List<String> prjLangs, String value) {
        boolean ret = true;
        if (prjLangs == null || prjLangs.isEmpty()) {
            L.warn("project [{}] does not have languages defined!!", (Object)prjName);
            ret = false;
        } else {
            String[] languages = value.split(",");
            boolean noValidLang = true;
            int i = 0;
            while (i < languages.length) {
                if (!prjLangs.contains(languages[i])) {
                    L.info("project [{}] does not have a valid language! ({})", (Object)prjName, (Object)languages[i]);
                } else {
                    noValidLang = false;
                }
                ++i;
            }
            ret = !noValidLang;
        }
        return ret;
    }

    public static boolean evaluateDBEngine(ProjectInfo prjInfo, String value) {
        ServerType dbEngine = prjInfo.getDbEngine();
        Integer dbEngineInt = new Integer(dbEngine.getValue());
        return Manager.evaluateDBEngine(prjInfo.getProjectName(), dbEngineInt, value);
    }

    public static boolean evaluateDBEngine(Map<String, Object> prjInfo, String value) {
        String prjName = (String)prjInfo.get("projectName");
        Integer dbEngineInt = (Integer)prjInfo.get("dbEngine");
        return Manager.evaluateDBEngine(prjName, dbEngineInt, value);
    }

    public static boolean evaluateDBEngine(String prjName, Integer dbEngineInt, String value) {
        String dbEngineString = dbEngineInt.toString();
        String[] values = value.split(",");
        boolean noValidDBEngine = false;
        int i = 0;
        while (!noValidDBEngine && i < values.length) {
            if (values[i].equals(dbEngineString)) {
                noValidDBEngine = true;
            }
            ++i;
        }
        if (!noValidDBEngine) {
            L.info("project [{}] does not have searched DB Engine ({}), but has {} DB Engine", new Object[]{prjName, value, dbEngineInt});
        }
        return noValidDBEngine;
    }

    public static Manager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Manager();
        }
        return INSTANCE;
    }

    public static boolean evaluateEnvironment(ProjectInfo pi, String envValue) {
        String prjEnv = pi.getEnvironment();
        return Manager.evaluateEnvironment(pi.getProjectName(), prjEnv, envValue);
    }

    public static boolean evaluateEnvironment(Map<String, Object> prjInfo, String envValue) {
        String prjName = (String)prjInfo.get("projectName");
        String prjEnv = (String)prjInfo.get("environment");
        return Manager.evaluateEnvironment(prjName, prjEnv, envValue);
    }

    public static boolean evaluateEnvironment(String prjName, String prjEnv, String envValue) {
        boolean ret = false;
        String[] searchedEnvironments = envValue.split(",");
        int i = 0;
        while (i < searchedEnvironments.length && !ret) {
            if (!prjEnv.contains(searchedEnvironments[i])) {
                L.info("project [{}] does not have searched enviroment ({}), but has {} environment", new Object[]{prjName, envValue, prjEnv});
            } else {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    public void addSelections(Properties prop) {
        boolean overload;
        boolean bl = overload = this.customProp != null && !this.customProp.isEmpty();
        if (this.customProp == null) {
            this.customProp = new Properties();
            this.customProp.putAll((Map<?, ?>)this.prop);
            overload = !this.customProp.isEmpty();
        }
        this.prop.putAll((Map<?, ?>)prop);
        if (overload) {
            this.prop.putAll((Map<?, ?>)this.customProp);
        }
    }
}

