/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.selection;

import com.ez.mainframe.selection.ParserException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogicalParser {
    private static final Logger L = LoggerFactory.getLogger(LogicalParser.class);
    private Map variablesMap;
    final int NONE = 0;
    final int DELIMITER = 1;
    final int VARIABLE = 2;
    final int NUMBER = 3;
    final int SYNTAX = 0;
    final int UNBALPARENS = 1;
    final int NOEXP = 2;
    final String EOE = "\u0000";
    private String exp;
    private int expIdx;
    private String token;
    private int tokType;

    public LogicalParser(Map variablesMap) {
        this.variablesMap = variablesMap;
    }

    public boolean evaluate(String expstr) throws ParserException {
        this.exp = expstr;
        this.expIdx = 0;
        this.getToken();
        if (this.token.equals("\u0000")) {
            this.handleErr(2);
        }
        boolean result = this.evalExp2();
        if (!this.token.equals("\u0000")) {
            this.handleErr(0);
        }
        return result;
    }

    private boolean evalExp2() throws ParserException {
        char op;
        boolean result = this.evalExp5();
        while ((op = this.token.charAt(0)) == '&' || op == '|') {
            this.getToken();
            boolean partialResult = this.evalExp5();
            switch (op) {
                case '&': {
                    result = result && partialResult;
                    break;
                }
                case '|': {
                    boolean bl = result = result || partialResult;
                }
            }
        }
        return result;
    }

    private boolean evalExp5() throws ParserException {
        boolean result;
        if (this.tokType == 1 && this.token.equals("!")) {
            this.getToken();
            result = !this.evalExp6();
        } else {
            result = this.evalExp6();
        }
        return result;
    }

    private boolean evalExp6() throws ParserException {
        boolean result;
        if (this.token.equals("(")) {
            this.getToken();
            result = this.evalExp2();
            if (!this.token.equals(")")) {
                this.handleErr(1);
            }
            this.getToken();
        } else {
            result = this.atom();
        }
        return result;
    }

    private boolean atom() throws ParserException {
        boolean result = false;
        switch (this.tokType) {
            case 2: {
                try {
                    result = (Boolean)this.variablesMap.get(this.token);
                    L.debug("===== " + this.token + " ===== " + result);
                }
                catch (NumberFormatException numberFormatException) {
                    this.handleErr(0);
                }
                this.getToken();
                break;
            }
            default: {
                this.handleErr(0);
            }
        }
        return result;
    }

    private void handleErr(int error) throws ParserException {
        String[] err = new String[]{"Syntax Error", "Unbalanced Parentheses", "No Expression Present"};
        throw new ParserException(err[error]);
    }

    /*
     * Unable to fully structure code
     */
    private void getToken() {
        this.tokType = 0;
        this.token = "";
        if (this.expIdx != this.exp.length()) ** GOTO lbl7
        this.token = "\u0000";
        return;
lbl-1000:
        // 1 sources

        {
            ++this.expIdx;
lbl7:
            // 2 sources

            ** while (this.expIdx < this.exp.length() && Character.isWhitespace((char)this.exp.charAt((int)this.expIdx)))
        }
lbl8:
        // 1 sources

        if (this.expIdx == this.exp.length()) {
            this.token = "\u0000";
            return;
        }
        if (this.isDelim(this.exp.charAt(this.expIdx))) {
            this.token = String.valueOf(this.token) + this.exp.charAt(this.expIdx);
            ++this.expIdx;
            this.tokType = 1;
        } else if (Character.isLetter(this.exp.charAt(this.expIdx))) {
            while (!this.isDelim(this.exp.charAt(this.expIdx))) {
                this.token = String.valueOf(this.token) + this.exp.charAt(this.expIdx);
                ++this.expIdx;
                if (this.expIdx >= this.exp.length()) break;
            }
            this.tokType = 2;
        } else if (Character.isDigit(this.exp.charAt(this.expIdx))) {
            while (!this.isDelim(this.exp.charAt(this.expIdx))) {
                this.token = String.valueOf(this.token) + this.exp.charAt(this.expIdx);
                ++this.expIdx;
                if (this.expIdx >= this.exp.length()) break;
            }
            this.tokType = 3;
        } else {
            this.token = "\u0000";
            return;
        }
    }

    private boolean isDelim(char c) {
        return " &|!()".indexOf(c) != -1;
    }
}

