/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.model.dataset;

import com.ez.common.model.BaseResourceInput;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import java.util.Collection;
import java.util.HashSet;

public class VSAMInput
extends BaseMainframeResourceInput {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final long serialVersionUID = 1L;
    private String[] extra;
    protected String memberName;

    public VSAMInput(String datasetName, Integer dbID, String memberName) {
        super(datasetName, null, dbID);
        this.memberName = Utils.filterNullValue(memberName) != null ? memberName : null;
    }

    public VSAMInput(String datasetName, Integer dbID, Integer genNumber, String memberName) {
        super(datasetName, genNumber, dbID);
        this.memberName = Utils.filterNullValue(memberName) != null ? memberName : null;
    }

    public VSAMInput(String datasetName, Integer dbID, Integer genNumber, String memberName, String[] extra) {
        super(datasetName, genNumber, dbID);
        this.memberName = Utils.filterNullValue(memberName) != null ? memberName : null;
        this.extra = extra;
    }

    public Integer getTypeCode() {
        return 12;
    }

    public String getListableName() {
        if (this.type == null) {
            return String.valueOf(this.name) + (Utils.filterNullValue(this.memberName) != null && !this.memberName.isEmpty() ? "(" + this.memberName + ")" : "");
        }
        return String.valueOf(this.name) + "(" + this.type + ")";
    }

    public String getName() {
        return this.name;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public Integer getGenerationNumber() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VSAMInput)) {
            return false;
        }
        VSAMInput o2 = (VSAMInput)((Object)obj);
        boolean ret = false;
        if (this.name != null) {
            ret = this.name.equalsIgnoreCase(o2.name);
        } else {
            boolean bl = ret = o2.name == null;
        }
        if (ret && (this.memberName == null ? o2.memberName != null : !this.memberName.equals(o2.memberName))) {
            return false;
        }
        return ret;
    }

    public String[] getExtra() {
        String[] ret = null;
        if (this.extra != null) {
            ret = new String[this.extra.length];
            System.arraycopy(this.extra, 0, ret, 0, this.extra.length);
        }
        return ret;
    }

    public Collection<Integer> getIds() {
        HashSet<Integer> lst = new HashSet<Integer>();
        lst.add(this.resourceID);
        return lst;
    }

    public int compareTo(Object o) {
        int res = 0;
        if (o instanceof BaseResourceInput) {
            VSAMInput other = (VSAMInput)((Object)o);
            res = this.name.compareTo(other.name);
            if (res == 0) {
                if (this.type == null) {
                    if (other.type == null) {
                        return 0;
                    }
                    return -1;
                }
                if (!this.type.equals(other.type)) {
                    res = -this.type.compareTo(other.type);
                }
                if (res == 0) {
                    if (this.memberName == null) {
                        if (other.memberName == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (!this.memberName.equals(other.memberName)) {
                        res = this.memberName.compareTo(other.memberName);
                    }
                }
            }
        }
        return res;
    }

    public void setExtra(String[] extra) {
        this.extra = extra;
    }
}

