/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.model.dataset;

import com.ez.internal.utils.Pair;
import com.ez.mainframe.model.dataset.VSAMInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultipleVSAMInput
extends VSAMInput {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    List<Pair<Integer, String>> infos = new ArrayList<Pair<Integer, String>>();
    List<VSAMInput> lst = null;
    Set<Integer> ids = null;
    boolean isIncomplete = false;
    private static final long serialVersionUID = 1L;

    public MultipleVSAMInput(String datasetName, Integer dbID) {
        super(datasetName, (Integer)null, (String)null);
        Pair p = new Pair((Object)dbID, null);
        this.infos.add((Pair<Integer, String>)p);
    }

    public MultipleVSAMInput(String name, String memberName, Integer dbID, Integer genNumber) {
        super(name, dbID, genNumber, memberName);
        Pair p = new Pair((Object)dbID, null);
        this.infos.add((Pair<Integer, String>)p);
    }

    public void addInfo(Integer dbID, String number) {
        Pair p = new Pair((Object)dbID, (Object)number);
        this.infos.add((Pair<Integer, String>)p);
    }

    public boolean isIncomplete() {
        return this.isIncomplete;
    }

    public void setIncomplete(boolean isIncomplete) {
        this.isIncomplete = isIncomplete;
    }

    public Collection<VSAMInput> getSimpleObjects() {
        if (this.lst == null) {
            this.lst = new ArrayList<VSAMInput>();
            for (Pair<Integer, String> p : this.infos) {
                Integer id = (Integer)p.getFirst();
                String number = (String)p.getSecond();
                VSAMInput obj = new VSAMInput(this.name, id, number != null ? Integer.valueOf(number) : null, null);
                this.lst.add(obj);
            }
        }
        return this.lst;
    }

    @Override
    public String getListableName() {
        return String.valueOf(this.name) + (this.memberName != null && !this.memberName.isEmpty() ? "(" + this.memberName + ")" : "");
    }

    @Override
    public Collection<Integer> getIds() {
        if (this.ids == null) {
            this.ids = new HashSet<Integer>();
            for (Pair<Integer, String> p : this.infos) {
                Integer id = (Integer)p.getFirst();
                this.ids.add(id);
            }
        }
        return this.ids;
    }

    @Override
    public int compareTo(Object o) {
        int res = super.compareTo(o);
        if (res == 0) {
            MultipleVSAMInput other = (MultipleVSAMInput)((Object)o);
            if (this.memberName == null) {
                if (other.memberName == null) {
                    return 0;
                }
                return -1;
            }
            if (!this.memberName.equals(other.memberName)) {
                res = this.memberName.compareTo(other.memberName);
            }
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MultipleVSAMInput other = (MultipleVSAMInput)((Object)obj);
        return !(this.memberName == null ? other.memberName != null : !this.memberName.equals(other.memberName));
    }
}

