/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.model;

import com.ez.mainframe.model.Base;
import com.ez.mainframe.model.StmtType;
import java.util.HashSet;
import java.util.Set;

public class StmtGroup
extends Base {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String name;
    private Set<StmtType> types = new HashSet<StmtType>();
    private String parent;
    private Set subgroups;
    private String displayName;

    public StmtGroup() {
    }

    public StmtGroup(Integer id) {
        this.setId(id);
    }

    public StmtGroup(Integer id, String name) {
        this(id);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set getTypes() {
        return this.types;
    }

    public StmtType getType(StmtType type) {
        if (this.types != null && type != null) {
            for (StmtType t : this.types) {
                if (!t.getId().equals(type.getId())) continue;
                return t;
            }
        }
        return null;
    }

    public void addType(StmtType obj) {
        if (this.types == null) {
            this.types = new HashSet<StmtType>();
        }
        this.types.add(obj);
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public Set getSubgroups() {
        return this.subgroups;
    }

    public void setSubgroups(Set subgroups) {
        this.subgroups = subgroups;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name;
    }

    public void setDisplayName(String grDisplayName) {
        this.displayName = grDisplayName;
    }
}

