/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.model;

import com.ez.mainframe.data.callgraph.ResourceLink;
import com.ez.mainframe.data.internal.Messages;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.StatementInfo;
import com.ez.mainframe.model.StmtType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementNode
implements StatementInfo {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(StatementNode.class);
    private String statementDescription;
    private Set<TextSelectionInFile> locations;
    private static Map stmtMap;
    private static final String JOB_TO_PGM_DESCRIPTION;
    private static final String JOB_TO_JOB_DESCRIPTION;
    private static final String MAPPED_TRANSACTION_DESCRIPTION;
    public static final String FALL_THROUGH_DESCRIPTION;
    public static final String COND_FALL_THROUGH_DESCRIPTION;
    public static final String MID_MOD_MAPPED_TRANSACTION_DESCRIPTION;
    private static final String API_TO_SERVICE_DESCRIPTION;
    private static final String SERVICE_TO_TARGET_DESCRIPTION;
    private static final String EXT_CALL_DESCRIPTION_WRITE;
    private static final String EXT_CALL_DESCRIPTION_READ;
    private static final String EXT_CALL_DESCRIPTION;
    private static final String MAPPED_GENERICSCR_DESCRIPTION;

    static {
        JOB_TO_PGM_DESCRIPTION = Messages.getString(StatementNode.class, "job.to.pgm");
        JOB_TO_JOB_DESCRIPTION = Messages.getString(StatementNode.class, "job.to.job");
        MAPPED_TRANSACTION_DESCRIPTION = Messages.getString(StatementNode.class, "mapped.trans");
        FALL_THROUGH_DESCRIPTION = Messages.getString(StatementNode.class, "fall.through");
        COND_FALL_THROUGH_DESCRIPTION = Messages.getString(StatementNode.class, "cond.fall.through");
        MID_MOD_MAPPED_TRANSACTION_DESCRIPTION = Messages.getString(StatementNode.class, "messageToMappedTransaction");
        API_TO_SERVICE_DESCRIPTION = Messages.getString(StatementNode.class, "api.to.service");
        SERVICE_TO_TARGET_DESCRIPTION = Messages.getString(StatementNode.class, "service.to.target");
        EXT_CALL_DESCRIPTION_WRITE = Messages.getString(StatementNode.class, "ext.call.write");
        EXT_CALL_DESCRIPTION_READ = Messages.getString(StatementNode.class, "ext.call.read");
        EXT_CALL_DESCRIPTION = Messages.getString(StatementNode.class, "ext.call");
        MAPPED_GENERICSCR_DESCRIPTION = Messages.getString(StatementNode.class, "scr.trans");
        stmtMap = Utils.readStmtTypes();
    }

    public StatementNode(String statementType) {
        this(statementType, false);
    }

    private StatementNode() {
    }

    private StatementNode(String statementType, boolean isDescription) {
        this();
        if (isDescription) {
            this.statementDescription = statementType;
        } else {
            String stmtDescription = "";
            L.debug("statement type from query: {}", (Object)statementType);
            if (statementType != null && !statementType.isEmpty()) {
                if (ResourceLink.FAKE_STMT_TYPE_FOR_JCL_TO_PGM_STRING.equals(statementType)) {
                    stmtDescription = JOB_TO_PGM_DESCRIPTION;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_JCL_TO_JCL_STRING.equals(statementType)) {
                    stmtDescription = JOB_TO_JOB_DESCRIPTION;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_TRANSACTION_TO_MAPPED_PRG_STRING.equals(statementType)) {
                    stmtDescription = MAPPED_TRANSACTION_DESCRIPTION;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_FALL_THROUGH_STRING.equals(statementType)) {
                    stmtDescription = FALL_THROUGH_DESCRIPTION;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_COND_FALL_THROUGH_STRING.equals(statementType)) {
                    stmtDescription = COND_FALL_THROUGH_DESCRIPTION;
                } else if (ResourceLink.FAKE_STMT_TYPE_IMS_MID_MOD_TO_TRANSACTION_STRING.equals(statementType)) {
                    stmtDescription = MID_MOD_MAPPED_TRANSACTION_DESCRIPTION;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_SERVICE_TO_TARGET_STRING.equals(statementType)) {
                    stmtDescription = SERVICE_TO_TARGET_DESCRIPTION;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_API_TO_SERVICE_STRING.equals(statementType)) {
                    stmtDescription = API_TO_SERVICE_DESCRIPTION;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_EXT_CALL_READ_STRING.equals(statementType)) {
                    stmtDescription = EXT_CALL_DESCRIPTION_READ;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_EXT_CALL_WRITE_STRING.equals(statementType)) {
                    stmtDescription = EXT_CALL_DESCRIPTION_WRITE;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_EXT_CALL_STRING.equals(statementType)) {
                    stmtDescription = EXT_CALL_DESCRIPTION;
                } else if (ResourceLink.FAKE_STMT_TYPE_FOR_GENERICSCR_TO_MAPPED_PRG_STRING.equals(statementType)) {
                    stmtDescription = MAPPED_GENERICSCR_DESCRIPTION;
                } else {
                    try {
                        Integer stmtId = Integer.valueOf(statementType);
                        StmtType stmtType = (StmtType)stmtMap.get(stmtId);
                        L.debug("stmtType: {}", (Object)stmtType);
                        if (stmtType != null && (stmtDescription = stmtType.getName()) != null) {
                            stmtDescription = stmtDescription.replaceAll("_", " ");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        L.error("wrong format for statement type: {}", (Object)statementType, (Object)nfe);
                    }
                }
            }
            this.statementDescription = stmtDescription;
        }
    }

    public void addLocation(TextSelectionInFile tsf) {
        if (this.locations == null) {
            this.locations = new HashSet<TextSelectionInFile>();
        }
        this.locations.add(tsf);
    }

    public void addLocations(Set<TextSelectionInFile> loc) {
        if (this.locations == null) {
            this.locations = new HashSet<TextSelectionInFile>();
        }
        this.locations.addAll(loc);
    }

    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Override
    public List<Object[]> getLocations() {
        ArrayList<Object[]> loc = new ArrayList<Object[]>();
        if (this.locations != null && this.locations.size() > 0) {
            for (TextSelectionInFile tsf : this.locations) {
                int[] bounds = tsf.getBounds();
                Integer startLine = null;
                Integer startCol = null;
                if (bounds != null && bounds.length > 1) {
                    startLine = bounds[0];
                    startCol = bounds[1];
                }
                String prgTypeId = tsf.getPrgType();
                String prgType = null;
                prgType = String.valueOf(22).equals(prgTypeId) ? "JCL" : Utils.getPrgType(prgTypeId);
                Object[] l = new Object[]{tsf.getFileName(), prgType, startLine, startCol};
                loc.add(l);
            }
        }
        return loc;
    }

    public StatementNode copy(boolean withLocations) {
        StatementNode copy = new StatementNode();
        copy.locations = new HashSet<TextSelectionInFile>();
        if (withLocations && this.locations != null) {
            copy.locations = new HashSet<TextSelectionInFile>(this.locations);
        }
        copy.statementDescription = this.statementDescription;
        return copy;
    }

    @Override
    public String getStatementName() {
        return this.statementDescription;
    }
}

