/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.model;

import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.MultiAppInputNoGUI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramInputNoGUI
extends MultiAppInputNoGUI {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramInputNoGUI.class);
    private static final long serialVersionUID = 1L;
    private Set<Integer> childrensID;
    private String ancestorName;
    private Integer ancestorDBId;
    protected String path;
    protected boolean displayPath = false;

    public ProgramInputNoGUI(String name) {
        super(name);
    }

    public ProgramInputNoGUI(String name, Integer type) {
        super(name, type);
    }

    public ProgramInputNoGUI(String name, Integer type, Integer dbID) {
        super(name, type, dbID);
    }

    public ProgramInputNoGUI(String name, Integer type, Integer dbID, String odbRID) {
        super(name, type, dbID, odbRID);
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getNameWithApp() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.name);
        if (this.applicationsName != null && !this.applicationsName.isEmpty()) {
            buff.append(this.applicationsName);
        }
        return buff.toString();
    }

    @Override
    public String toString() {
        return this.name;
    }

    public int compareTo(Object o) {
        int res = 0;
        if (o instanceof ProgramInputNoGUI) {
            ProgramInputNoGUI other = (ProgramInputNoGUI)((Object)o);
            res = this.getListableName().compareToIgnoreCase(other.getListableName());
            if (res == 0 && !this.type.equals(other.type)) {
                res = -this.type.compareTo(other.type);
            }
        }
        return res;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof ProgramInputNoGUI) {
            ProgramInputNoGUI other = (ProgramInputNoGUI)((Object)arg0);
            if (this.getListableName() != null && other.getListableName() != null && this.getListableName().equals(other.getListableName()) && this.getTypeCode() != null && other.getTypeCode() != null && this.getTypeCode().equals(other.getTypeCode())) {
                return true;
            }
        }
        return false;
    }

    public Integer getProgramID() {
        return this.resourceID;
    }

    public void setProgramID(Integer programID) {
        this.resourceID = programID;
    }

    public void addChildId(String id) {
        if (this.childrensID == null) {
            this.childrensID = new HashSet<Integer>();
        }
        this.childrensID.add(Integer.valueOf(id));
    }

    public Collection<Integer> getChildrenIDs() {
        return this.childrensID;
    }

    public String getAncestorName() {
        return this.ancestorName;
    }

    public void setAncestorName(String ancestorName) {
        if (15 == this.type || 16 == this.type | 1 == this.type) {
            this.ancestorName = ancestorName;
        }
    }

    public Integer getAncestorDBId() {
        return this.ancestorDBId;
    }

    public void setAncestorDBId(Integer ancestorDBId) {
        this.ancestorDBId = ancestorDBId;
    }

    public String getListableName() {
        StringBuilder sb = this.getNameNoPath();
        if (this.displayPath && this.path != null) {
            sb.append(" (");
            if (this.path != null) {
                sb.append(this.path);
            } else {
                sb.append("N/A");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public StringBuilder getNameNoPath() {
        StringBuilder sb = null;
        String res = super.getListableName();
        if (Utils.filterNullValue(this.ancestorName) != null && !this.ancestorName.isEmpty()) {
            sb = new StringBuilder(this.ancestorName);
            sb.append(":");
            sb.append(res);
        }
        if (sb == null) {
            sb = new StringBuilder(res);
        }
        return sb;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void displayPath(boolean b) {
        this.displayPath = b;
    }
}

