/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.filters;

import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.selection.Manager;
import com.ez.workspace.analysis.filters.EZInputParamFilter;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleMainframeProjectFilter
implements EZInputParamFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MultipleMainframeProjectFilter.class);
    public Properties parameters;

    public boolean checkProjectCount(Collection inputs) {
        return true;
    }

    public boolean checkAnalysisAvailability(Collection inputs) {
        boolean ret = false;
        if (this.checkProjectCount(inputs)) {
            int countProjects = this.countProjects(inputs);
            boolean bl = ret = 1 < countProjects && inputs != null && countProjects == inputs.size();
            if (ret) {
                ret = this.checkProjects(inputs);
            }
        }
        return ret;
    }

    protected boolean checkProjects(Collection inputs) {
        boolean ret = this.checkProjectsDefinition(inputs);
        if (ret) {
            ret = this.checkParameters(inputs);
        }
        return ret;
    }

    protected boolean checkProjectsDefinition(Collection inputs) {
        boolean ret = true;
        Iterator it = inputs.iterator();
        while (ret && it.hasNext()) {
            EZSourceProjectInputType inpObj = (EZSourceProjectInputType)it.next();
            ProjectInfo pInfo = (ProjectInfo)inpObj.getProperty("PROJECT_INFO");
            ret = this.checkDefinition(pInfo);
        }
        return ret;
    }

    protected int countProjects(Collection inputs) {
        int count = 0;
        if (inputs != null) {
            for (Object inpObj : inputs) {
                if (!(inpObj instanceof EZSourceProjectInputType)) continue;
                ++count;
            }
        }
        return count;
    }

    public void setParameters(Properties parameters) {
        this.parameters = parameters;
    }

    protected boolean checkParameters(Collection inputs) {
        boolean ret = true;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            Iterator it = inputs.iterator();
            while (ret && it.hasNext()) {
                EZSourceProjectInputType inpObj = (EZSourceProjectInputType)it.next();
                ProjectInfo pInfo = (ProjectInfo)inpObj.getProperty("PROJECT_INFO");
                ret = this.checkAvailabilityForProject(pInfo);
            }
        }
        return ret;
    }

    protected boolean checkProjectParameters(EZSourceProjectIDSg prjIdSg) {
        boolean ret;
        boolean bl = ret = prjIdSg != null;
        if (ret && this.parameters != null && !this.parameters.isEmpty()) {
            ProjectInfo pInfo = prjIdSg.getProjectInfo();
            ret = this.checkAvailabilityForProject(pInfo);
        }
        return ret;
    }

    private boolean checkAvailabilityForProject(ProjectInfo pInfo) {
        boolean ret = Manager.getInstance().checkAvailability(pInfo.getInfo(), this.parameters);
        return ret;
    }

    protected boolean checkDefinition(ProjectInfo pInfo) {
        return pInfo.hasDefinition();
    }

    protected boolean isPrgInProject(Object inpObj, Collection<Object> inputs) {
        boolean isPrg = inpObj instanceof EZSourceProgram;
        if (isPrg) {
            int prgCount = 0;
            for (Object inp : inputs) {
                if (!(inp instanceof EZSourceProgram)) continue;
                ++prgCount;
            }
            if (prgCount == inputs.size() && prgCount > 1) {
                for (Object inp : inputs) {
                    Boolean occur = (Boolean)((EZSourceProgram)inp).getProperty("program occur");
                    if (occur == null) {
                        L.debug("program's occur is not set for EZSourceProgram object type!");
                        EZSourceProgram prgObj = (EZSourceProgram)inp;
                        EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)prgObj.getEntID().getSegment(EZSourceProgramIDSg.class);
                        occur = prgSg.getOccur();
                    }
                    if (occur != null) {
                        if (!occur.booleanValue()) continue;
                        return true;
                    }
                    L.debug("program's occur is not set!");
                    return true;
                }
                return false;
            }
            Boolean occur = (Boolean)((EZSourceProgram)inpObj).getProperty("program occur");
            if (occur == null) {
                L.debug("program's occur is not set for EZSourceProgram object type!");
                EZSourceProgram prgObj = (EZSourceProgram)inpObj;
                EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)prgObj.getEntID().getSegment(EZSourceProgramIDSg.class);
                occur = prgSg.getOccur();
            }
            if (occur != null) {
                isPrg = occur;
            } else {
                L.debug("program's occur is not set!");
                return true;
            }
        }
        return isPrg;
    }

    protected boolean isCICSds(EZObjectType inpObj) {
        Object propValue = inpObj.getProperty("dataset from File Control Table, FCT");
        return propValue != null && (Boolean)propValue != false;
    }
}

