/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.filters;

import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceInclude;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.filters.MultipleMainframeProjectFilter;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.Collection;
import java.util.HashSet;

public abstract class AbstractSingleMainframeProjectOrResourcesFilter
extends MultipleMainframeProjectFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    @Override
    public boolean checkAnalysisAvailability(Collection inputs) {
        boolean check = false;
        int count = this.countProjects(inputs);
        if (count == 1 && count == inputs.size()) {
            check = this.checkProjects(inputs);
        } else if (inputs != null) {
            check = this.checkResources(inputs);
        }
        return check;
    }

    protected abstract boolean isAcceptedResourceInput(Object var1);

    protected abstract boolean isAcceptedPrgInput(Object var1, Collection var2);

    protected boolean verifySpecificCondition(EZObjectType inpObj) {
        return true;
    }

    protected boolean checkResources(Collection inputs) {
        boolean checkResources = true;
        boolean checkParam = true;
        HashSet<String> prjNames = new HashSet<String>();
        for (Object inpObj : inputs) {
            if (!this.isAcceptedResourceInput(inpObj) && !this.isAcceptedPrgInput(inpObj, inputs)) {
                checkResources = false;
                break;
            }
            EZObjectType ezSourceObjType = (EZObjectType)inpObj;
            EZEntityID entity = ezSourceObjType.getEntID();
            EZSourceProjectIDSg prjIdSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
            prjNames.add(prjIdSg.getProjectName());
            boolean bl = checkResources = prjNames.size() == 1;
            if (checkResources && checkParam && this.parameters != null) {
                checkResources = this.checkProjectParameters(prjIdSg);
            }
            if (checkResources) {
                checkResources = this.verifySpecificCondition(ezSourceObjType);
            }
            if (!checkResources) break;
            checkParam = false;
        }
        return checkResources;
    }

    protected boolean isIncludeInProject(Object inpObj) {
        Object prop;
        boolean ret = false;
        if (inpObj instanceof EZSourceInclude && ((prop = ((EZSourceInclude)inpObj).getProperty("include is not on disk")) == null || !((Boolean)prop).booleanValue())) {
            ret = true;
        }
        return ret;
    }
}

