/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.data.utils;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.ParameterDirection;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.PathUtils;
import com.ez.mainframe.data.callgraph.GraphNode;
import com.ez.mainframe.data.internal.Messages;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.StmtGroup;
import com.ez.mainframe.model.StmtType;
import com.ez.mainframe.selection.Manager;
import com.ez.scl.procedures.SCLProceduresReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);
    public static final String PLUGIN_ID = "com.ez.mainframe.data";
    public static final String VT_NULL_VALUE = "VT_NULL";
    public static final String numericTempTableName = "numeric_param_temp";
    public static final String stringTempTableName = "string_param_temp";
    public static final String STATEMENTS_PROPERTIES_FILENAME = "statements.properties";
    public static final String STMTGROUPS_PROPERTIES_FILENAME = "stmtgroups.properties";
    public static final String CONFIG_FOLDER_NAME = "config";
    public static final String STMTGROUPS_PATH_IN_PROJECT = "/config/stmtgroups.properties";
    public static final String STATEMENTS_PATH_IN_PROJECT = "/config/statements.properties";
    private static Map<Integer, StmtType> allStmtTypes = new HashMap<Integer, StmtType>();
    public static final String CACHE_PREFIX = "cache";
    private static final String lockTimeout = "3000";
    public static final String DEFAULT_PROPERTIES_FILENAME = "default.properties";
    public static final String PROJECTS = "mfp";
    private static final Set<String> utilities = new HashSet<String>();
    public static final String TYPE_ID_MARKER = "MARKER";
    public static final String CONDITION_MARKER = "CONDITION_MARKER";
    private static final String PRGS_OCCUR_QUERY = "SELECT als.AliasName AS ProgramName, pgm.ProgramTypeID, pgm.ProgramID, pth.PathStr FROM Programs pgm INNER JOIN  Occurrences occ ON occ.Occurid = pgm.Occurid INNER JOIN ProgramAliases als ON pgm.ProgramID = als.ProgramId LEFT OUTER JOIN ( SELECT 1 AS Flag, AliasName, ProgramTypeID \t\tFROM Programs  \t\tINNER JOIN ProgramAliases \t\t\tON Programs.ProgramID = ProgramAliases.ProgramId and ProgramAliases.AliasType = 0\t    GROUP BY AliasName, ProgramTypeID \t    HAVING COUNT(*) > 1           ) f ON f.AliasName = als.AliasName AND f.ProgramTypeID = pgm.ProgramTypeID LEFT OUTER JOIN Paths pth ON pth.PathID = occ.PathID AND f.Flag = 1 WHERE als.AliasType = 0  AND occ.OccurID <> 0  AND CONDITION_MARKER ORDER BY als.AliasName";
    public static final String PRGS_OCCUR_IN_QUERY;
    public static final String PRGS_OCCUR_NOTIN_QUERY;
    public static final String PRGS_OCCUR_NOTIN_OR_COBOLNOANCESTOR_QUERY;
    public static final String AVAILABLE_PROGRAMS_4FUJITSU_QUERY;
    public static final String AVAILABLE_PROGRAMS_4REPORTS_QUERY;
    public static final String AVAILABLE_PROGRAMS_FORAPPFLOW_QUERY = "SELECT ProgramName, ProgramTypeID, ProgramID FROM Programs where ProgramTypeID in (1, 2, 3, 7, 8, 10, 11, 13) order by ProgramName";
    public static final String DATASET_INPUT_QUERY_NOTEMP_NOLIB = "SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID inner JOIN JCLDD ON JCLDDRef.DDID = JCLDD.DDID WHERE JCLPhysicalDataSet.IsInstream<>1 AND JCLPhysicalDataSet.Istemp<>1  and JCLDD.DDName not in ('STEPLIB', 'JOBLIB', 'PROCLIB') ORDER BY DataSetName,GenerationNumber, MemberName";
    public static final String DATASET_INPUT_QUERY_NOLIB = "SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID inner JOIN JCLDD ON JCLDDRef.DDID = JCLDD.DDID WHERE JCLPhysicalDataSet.IsInstream<>1 and JCLDD.DDName not in ('STEPLIB', 'JOBLIB', 'PROCLIB') ORDER BY DataSetName,GenerationNumber, MemberName";
    public static final String NOTEMP_DATASET_INPUT_QUERY = "SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID WHERE JCLPhysicalDataSet.IsInstream<>1 AND JCLPhysicalDataSet.Istemp<>1 ORDER BY DataSetName,GenerationNumber, MemberName";
    public static final String DATASET_INPUT_QUERY = "SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID WHERE JCLPhysicalDataSet.IsInstream<>1 ORDER BY DataSetName,GenerationNumber, MemberName";
    public static final String CICS_DATASET_INPUT_QUERY = "SELECT cast(NULL as integer) AS DataSetID, mf.DSName AS DataSetName, cast(NULL as integer) AS GenerationNumber, \n\t\tcast(NULL as varchar(50)) AS MemberName \n\t\tFROM MFCICSFile mf \n\t\tINNER JOIN Files f on mf.DDName = f.LogicalName and f.TypeCode IS NULL AND (mf.DSName IS NOT NULL AND mf.DSName <> '')";
    public static final String AVAILABLE_PROGRAMS_FORFLOWCHART_QUERY;
    public static final String AVAILABLE_PROGRAMS_FORPRGFLOW_QUERY = "SELECT ProgramName, ProgramTypeID, ProgramID FROM Programs where OccurID <> 0 and ProgramTypeID in (1, 2, 3, 10) order by ProgramName";
    public static final String SCL_STANDARD_PROCEDURES_TABLE_NAME = "SCLStandardProcedures";
    public static final String USE_DB_SCL_PROCEDURES_PROPERTY_NAME = "useDbSclProcedures";
    public static final String IS_SCL_PROGRAM = "is program scl having procedure's information";

    static {
        Set<String> utilities = Utils.readUtilities();
        if (utilities != null) {
            Utils.utilities.addAll(utilities);
        } else {
            Utils.utilities.add("IDCAMS");
            Utils.utilities.add("IEBCOMPR");
            Utils.utilities.add("IEBCOPY");
            Utils.utilities.add("IEBDG");
            Utils.utilities.add("IEBEDIT");
            Utils.utilities.add("IEBGENER");
            Utils.utilities.add("IEBIMAGE");
            Utils.utilities.add("IEBISAM");
            Utils.utilities.add("IEBPTPCH");
            Utils.utilities.add("IEBUPDTE");
            Utils.utilities.add("IEFBR14");
            Utils.utilities.add("ICKDSF");
            Utils.utilities.add("IEHDASDR");
            Utils.utilities.add("IEHINITT");
            Utils.utilities.add("IEHLIST");
            Utils.utilities.add("IEHMOVE");
            Utils.utilities.add("IEHPROGM");
            Utils.utilities.add("SORT");
            Utils.utilities.add("DFSMS");
        }
        PRGS_OCCUR_IN_QUERY = PRGS_OCCUR_QUERY.replace(CONDITION_MARKER, " pgm.ProgramTypeID IN (MARKER) ");
        PRGS_OCCUR_NOTIN_QUERY = PRGS_OCCUR_QUERY.replace(CONDITION_MARKER, " pgm.ProgramTypeID NOT IN (MARKER) ");
        PRGS_OCCUR_NOTIN_OR_COBOLNOANCESTOR_QUERY = PRGS_OCCUR_QUERY.replace(CONDITION_MARKER, " ((pgm.ProgramTypeID = 1 and (pgm.Ancestor IS NULL OR pgm.Ancestor='')) \n OR (pgm.ProgramTypeID not IN (MARKER) ) ) ");
        AVAILABLE_PROGRAMS_4FUJITSU_QUERY = PRGS_OCCUR_NOTIN_QUERY.replace(TYPE_ID_MARKER, " 9, 13, 14, 15, 16, 19 ");
        AVAILABLE_PROGRAMS_4REPORTS_QUERY = PRGS_OCCUR_NOTIN_QUERY.replace(TYPE_ID_MARKER, "9, 10, 11, 13, 14, 15, 16, 19");
        AVAILABLE_PROGRAMS_FORFLOWCHART_QUERY = PRGS_OCCUR_IN_QUERY.replace(TYPE_ID_MARKER, " 1, 2, 3, 8, 13");
    }

    public static String getExternalizedType(Integer type, boolean notConsiderChildren) {
        if (notConsiderChildren && (type == 15 || type == 16)) {
            type = 8;
        }
        switch (type) {
            case 1: {
                return Messages.getString(Utils.class, "programType.1");
            }
            case 2: {
                return Messages.getString(Utils.class, "programType.2");
            }
            case 3: {
                return Messages.getString(Utils.class, "programType.3");
            }
            case 4: {
                return Messages.getString(Utils.class, "programType.4");
            }
            case 5: {
                return Messages.getString(Utils.class, "programType.5");
            }
            case 6: {
                return Messages.getString(Utils.class, "programType.6");
            }
            case 7: {
                return Messages.getString(Utils.class, "programType.7");
            }
            case 8: {
                return Messages.getString(Utils.class, "programType.8");
            }
            case 9: {
                return Messages.getString(Utils.class, "programType.9");
            }
            case 10: {
                return Messages.getString(Utils.class, "programType.10");
            }
            case 11: {
                return Messages.getString(Utils.class, "programType.11");
            }
            case 13: {
                return Messages.getString(Utils.class, "programType.13");
            }
            case 14: {
                return Messages.getString(Utils.class, "programType.14");
            }
            case 15: {
                return Messages.getString(Utils.class, "programType.15");
            }
            case 16: {
                return Messages.getString(Utils.class, "programType.16");
            }
            case 19: {
                return Messages.getString(Utils.class, "programType.19");
            }
            case 118: {
                return Messages.getString(Utils.class, "ads.map.type");
            }
            case 119: {
                return Messages.getString(Utils.class, "bms.map.type");
            }
            case 120: {
                return Messages.getString(Utils.class, "natural.map.type");
            }
            case 121: {
                return Messages.getString(Utils.class, "asm400.screen.type");
            }
            case 21: {
                return Messages.getString(Utils.class, "mf.resType.21");
            }
            case 22: {
                return Messages.getString(Utils.class, "mf.resType.22");
            }
            case 23: {
                return Messages.getString(Utils.class, "mf.resType.23");
            }
            case 65: {
                return Messages.getString(Utils.class, "programType.21");
            }
            case 220: {
                return Messages.getString(Utils.class, "gen.scr.220");
            }
        }
        return type.toString();
    }

    public static String getExternalizedType(Integer type) {
        return Utils.getExternalizedType(type, false);
    }

    public static String getExternalizedType4DDCLComponent(Integer idType) {
        String desc = null;
        switch (idType) {
            case 25: {
                desc = Messages.getString(Utils.class, "ddcl.resType.25");
                break;
            }
            case 17: {
                desc = Messages.getString(Utils.class, "ddcl.resType.17");
                break;
            }
            case 28: {
                desc = Messages.getString(Utils.class, "ddcl.resType.28");
                break;
            }
            case 15: {
                desc = Messages.getString(Utils.class, "ddcl.resType.15");
                break;
            }
            case 18: {
                desc = Messages.getString(Utils.class, "ddcl.resType.18");
                break;
            }
            case 11: {
                desc = Messages.getString(Utils.class, "ddcl.resType.11");
                break;
            }
            case 5: {
                desc = Messages.getString(Utils.class, "ddcl.resType.5");
                break;
            }
            case 30: {
                desc = Messages.getString(Utils.class, "ddcl.resType.30");
                break;
            }
            case 8: {
                desc = Messages.getString(Utils.class, "ddcl.resType.8");
                break;
            }
            case 26: {
                desc = Messages.getString(Utils.class, "ddcl.resType.26");
                break;
            }
            case 23: {
                desc = Messages.getString(Utils.class, "ddcl.resType.23");
                break;
            }
            case 16: {
                desc = Messages.getString(Utils.class, "ddcl.resType.16");
                break;
            }
            case 12: {
                desc = Messages.getString(Utils.class, "ddcl.resType.12");
                break;
            }
            case 21: {
                desc = Messages.getString(Utils.class, "ddcl.resType.21");
                break;
            }
            case 19: {
                desc = Messages.getString(Utils.class, "ddcl.resType.19");
                break;
            }
            case 2: {
                desc = Messages.getString(Utils.class, "ddcl.resType.2");
                break;
            }
            case 22: {
                desc = Messages.getString(Utils.class, "ddcl.resType.22");
                break;
            }
            case 1: {
                desc = Messages.getString(Utils.class, "ddcl.resType.1");
                break;
            }
            case 31: {
                desc = Messages.getString(Utils.class, "ddcl.resType.31");
                break;
            }
            case 4: {
                desc = Messages.getString(Utils.class, "ddcl.resType.4");
                break;
            }
            case 3: {
                desc = Messages.getString(Utils.class, "ddcl.resType.3");
                break;
            }
            case 29: {
                desc = Messages.getString(Utils.class, "ddcl.resType.29");
                break;
            }
            case 27: {
                desc = Messages.getString(Utils.class, "ddcl.resType.27");
                break;
            }
            case 6: {
                desc = Messages.getString(Utils.class, "ddcl.resType.6");
                break;
            }
            case 14: {
                desc = Messages.getString(Utils.class, "ddcl.resType.14");
                break;
            }
            case 10: {
                desc = Messages.getString(Utils.class, "ddcl.resType.10");
                break;
            }
            case 13: {
                desc = Messages.getString(Utils.class, "ddcl.resType.13");
                break;
            }
            case 9: {
                desc = Messages.getString(Utils.class, "ddcl.resType.9");
                break;
            }
            case 7: {
                desc = Messages.getString(Utils.class, "ddcl.resType.7");
                break;
            }
            case 20: {
                desc = Messages.getString(Utils.class, "ddcl.resType.20");
                break;
            }
            case 24: {
                desc = Messages.getString(Utils.class, "ddcl.resType.24");
                break;
            }
            case 36: {
                desc = Messages.getString(Utils.class, "ddcl.resType.36");
                break;
            }
            case 34: {
                desc = Messages.getString(Utils.class, "ddcl.resType.34");
                break;
            }
            case 32: {
                desc = Messages.getString(Utils.class, "ddcl.resType.32");
                break;
            }
            case 33: {
                desc = Messages.getString(Utils.class, "ddcl.resType.33");
                break;
            }
            case 35: {
                desc = Messages.getString(Utils.class, "ddcl.resType.35");
                break;
            }
            default: {
                L.warn("search for a DDCL unknown type: {}", (Object)idType);
                desc = Messages.getString(Utils.class, "ddcl.resType.generic");
            }
        }
        return desc;
    }

    public static final String filterNullValue(String value) {
        if (value != null && value.equalsIgnoreCase(VT_NULL_VALUE)) {
            return null;
        }
        return value;
    }

    public static String getTempTableName(EZSourceConnection bridge, String tempTableName) {
        ServerType dbEngine = bridge.getProjectInfo().getDbEngine();
        return Utils.getTempTableName(dbEngine, tempTableName);
    }

    public static String getTempTableName(ServerType dbEngine, String tempTableName) {
        String tempTable = null;
        switch (dbEngine) {
            case SqlServer: {
                tempTable = "#" + tempTableName;
                break;
            }
            case Db2: 
            case Db2Z: {
                tempTable = "SESSION." + tempTableName;
            }
        }
        return tempTable;
    }

    public static void dropTempTable(EZSourceConnection bridge, String tempTableName) {
        bridge.executeUpdate("drop table " + Utils.getTempTableName(bridge, tempTableName));
    }

    public static void createTempTable(EZSourceConnection bridge, String tempTableName) {
        Utils.createTempTable(bridge, tempTableName, EZSourceDataType.String);
    }

    public static void createTempTable(EZSourceConnection conn, String tempTableName, EZSourceDataType type) {
        String createTempSql = Utils.buildCreateTempTableStr(conn, tempTableName, type);
        if (createTempSql != null) {
            conn.executeUpdate(createTempSql);
        }
    }

    public static String buildCreateTempTableStr(EZSourceConnection conn, String tempTableName, EZSourceDataType type) {
        return Utils.buildCreateTempTableStr(conn, tempTableName, "Param", type);
    }

    public static String buildCreateTempTableStr(EZSourceConnection conn, String tempTableName, String columnName, EZSourceDataType type) {
        String createTempSql = null;
        String tblName = Utils.getTempTableName(conn, tempTableName);
        ServerType dbEngine = conn.getProjectInfo().getDbEngine();
        boolean isInteger = EZSourceDataType.Integer.equals((Object)type);
        switch (dbEngine) {
            case SqlServer: {
                createTempSql = "create table " + tblName;
                if (isInteger) {
                    createTempSql = String.valueOf(createTempSql) + "( " + columnName + " [int] NOT NULL)";
                    break;
                }
                createTempSql = String.valueOf(createTempSql) + "( " + columnName + " [nvarchar] (250) NOT NULL)";
                break;
            }
            case Db2Z: {
                createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tblName;
                createTempSql = isInteger ? String.valueOf(createTempSql) + "( " + columnName + " INTEGER NOT NULL)" : String.valueOf(createTempSql) + "( " + columnName + " VARGRAPHIC(250) NOT NULL) " + " CCSID UNICODE ";
                createTempSql = String.valueOf(createTempSql) + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
            case Db2: {
                createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tblName;
                createTempSql = isInteger ? String.valueOf(createTempSql) + "( " + columnName + " INTEGER NOT NULL)" : String.valueOf(createTempSql) + "( " + columnName + " VARGRAPHIC(250) NOT NULL) ";
                createTempSql = String.valueOf(createTempSql) + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
        }
        if (createTempSql == null) {
            L.warn("null CREATE string for tableName={}, dbEngine={} and dataType={}", new Object[]{tblName, dbEngine, type});
        }
        return createTempSql;
    }

    public static void cleanTable(EZSourceConnection bridge, String tempTableName) {
        bridge.executeUpdate("delete from " + Utils.getTempTableName(bridge, tempTableName));
    }

    public static void insertValues(EZSourceConnection bridge, String tempTableName, EZSourceDataType type, Collection values) {
        L.debug("before insert into temp table {} values: {}", (Object)Utils.getTempTableName(bridge, tempTableName), (Object)values);
        ArrayList<EZSourceDataType> param = new ArrayList<EZSourceDataType>();
        param.add(type);
        String[][] pVals = new String[values.size()][1];
        Iterator it = values.iterator();
        int j = 0;
        while (it.hasNext()) {
            String proc;
            pVals[j][0] = proc = it.next().toString();
            ++j;
        }
        bridge.insertBatch(Utils.getTempTableName(bridge, tempTableName), pVals, param);
        L.debug("after insert into temp table {}", (Object)Utils.getTempTableName(bridge, tempTableName));
        pVals = null;
    }

    public static String getProjectPathName(String projectName) {
        File prjsFolder = new File(String.valueOf(PathUtils.METADATA_FOLDER.getAbsolutePath()) + File.separator + PROJECTS);
        String path = prjsFolder.getAbsolutePath().concat(File.separator).concat(projectName);
        File folder = new File(path);
        if (!folder.exists()) {
            try {
                folder.mkdirs();
            }
            catch (Exception e) {
                L.error("error at creating project setting directory: {}", (Object)path, (Object)e);
            }
        }
        return path;
    }

    public static Properties readSettings(File pFile) {
        Properties prop = new Properties();
        FileInputStream fileInputStream = null;
        try {
            try {
                if (!pFile.exists()) {
                    String parent = pFile.getParent();
                    File parentDir = new File(parent);
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    pFile.createNewFile();
                } else {
                    L.debug("Utils.readSettings(): loading properties from file {}", (Object)pFile.getAbsolutePath());
                    fileInputStream = new FileInputStream(pFile);
                    prop.load(fileInputStream);
                }
            }
            catch (FileNotFoundException e) {
                L.error("error at loading properties from file: {}", (Object)pFile, (Object)e);
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e2) {
                    L.error("readSettings", (Throwable)e2);
                }
            }
            catch (IOException e) {
                L.error("error at loading properties from file: {}", (Object)pFile, (Object)e);
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e3) {
                    L.error("readSettings", (Throwable)e3);
                }
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                L.error("readSettings", (Throwable)e);
            }
        }
        return prop;
    }

    public static List readAvailableStmtGroups(int reportType, ProjectInfo pInfo) {
        ArrayList<StmtGroup> availableGroups = new ArrayList<StmtGroup>();
        allStmtTypes = Utils.readStmtTypes();
        Properties prop = Utils.loadPropFile(STMTGROUPS_PATH_IN_PROJECT);
        if (prop == null) {
            L.error("cannot load statement groups; an empty map it will be used");
            prop = new Properties();
        }
        int nGroups = Integer.valueOf(prop.getProperty("groups"));
        int i = 1;
        while (i <= nGroups) {
            StmtGroup group = new StmtGroup();
            group.setId(new Integer(i));
            group.setName(prop.getProperty("group." + i + ".name"));
            L.debug("processing group {}", (Object)group.getName());
            boolean isAvailable = Manager.getInstance().checkAvailability(pInfo, "stmtType", new Integer(i).toString());
            String stmtTypes = prop.getProperty("group." + i);
            if (isAvailable && stmtTypes != null && !stmtTypes.equals("")) {
                availableGroups.add(group);
                Utils.buildStmtTypesForGroup(group, stmtTypes, allStmtTypes);
            }
            ++i;
        }
        return availableGroups;
    }

    public static Map readStmtTypes() {
        if (!allStmtTypes.isEmpty()) {
            return allStmtTypes;
        }
        String whereFile = STATEMENTS_PATH_IN_PROJECT;
        Properties prop = Utils.loadPropFile(whereFile);
        if (prop != null) {
            for (String string : prop.keySet()) {
                Integer stmtId = Integer.valueOf(string);
                String stmtName = prop.getProperty(string);
                StmtType stmtType = new StmtType(stmtId, stmtName);
                allStmtTypes.put(stmtId, stmtType);
            }
        } else {
            L.error("cannot load {}; statementTypes is empty", (Object)whereFile);
        }
        return allStmtTypes;
    }

    public static void buildStmtTypesForGroup(StmtGroup group, String stmtTypes, Map allStmtTypes) {
        if (stmtTypes.trim().equals("*")) {
            Set idSet = allStmtTypes.keySet();
            for (Integer id : idSet) {
                StmtType type = (StmtType)allStmtTypes.get(id);
                if (type == null) continue;
                type.setGroup(group);
                group.addType(type);
            }
            return;
        }
        String[] orValues = stmtTypes.split(",");
        int i = 0;
        while (i < orValues.length) {
            String orValue = orValues[i];
            int rangePos = orValue.indexOf("^");
            if (rangePos != -1) {
                int startIdx = Integer.parseInt(orValue.substring(0, rangePos));
                int endIdx = Integer.parseInt(orValue.substring(rangePos + 1));
                int stmtIdx = startIdx;
                while (stmtIdx <= endIdx) {
                    StmtType type = (StmtType)allStmtTypes.get(new Integer(stmtIdx));
                    if (type != null) {
                        if (group == null) {
                            allStmtTypes.remove(stmtIdx);
                        } else {
                            type.setGroup(group);
                            group.addType(type);
                        }
                    }
                    ++stmtIdx;
                }
            } else {
                Integer stmtId = Integer.valueOf(orValue);
                StmtType type = (StmtType)allStmtTypes.get(stmtId);
                if (type != null) {
                    if (group == null) {
                        allStmtTypes.remove(stmtId);
                    } else {
                        type.setGroup(group);
                        group.addType(type);
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties loadPropFile(String filePath) {
        Properties prop = null;
        InputStream inputFile = null;
        try {
            try {
                inputFile = Utils.class.getResourceAsStream(filePath);
                if (inputFile != null) {
                    prop = new Properties();
                    prop.load(inputFile);
                    return prop;
                } else {
                    L.info("file {} cannot be load", (Object)filePath);
                }
                return prop;
            }
            catch (FileNotFoundException e) {
                L.error("error at reading properties file: {}", (Object)filePath, (Object)e);
                if (inputFile == null) return prop;
                try {
                    inputFile.close();
                    return prop;
                }
                catch (IOException e2) {
                    L.error("loadPropFile()", (Throwable)e2);
                }
                return prop;
            }
            catch (IOException e) {
                L.error("error at reading properties file: {}", (Object)filePath, (Object)e);
                if (inputFile == null) return prop;
                try {
                    inputFile.close();
                    return prop;
                }
                catch (IOException e3) {
                    L.error("loadPropFile()", (Throwable)e3);
                }
                return prop;
            }
        }
        finally {
            if (inputFile != null) {
                try {
                    inputFile.close();
                }
                catch (IOException e) {
                    L.error("loadPropFile()", (Throwable)e);
                }
            }
        }
    }

    public static final String escapeForDbLikeValueExactMatch(String value) {
        return Utils.escapeForDbLikeValueExactMatch(value, '\\');
    }

    public static final String escapeForDbLikeValueExactMatch(String value, char escapeCharacter) {
        String regexEscape = Utils.escapeAdapt(escapeCharacter);
        if (value != null) {
            value = value.replaceAll("([" + regexEscape + "?*])", String.valueOf(regexEscape) + "$1");
        }
        return value;
    }

    public static final String convertDbLikeValue(String value) {
        return Utils.convertDbLikeValue(value, false);
    }

    public static final String convertDbLikeValue(String value, boolean lookaround) throws IllegalArgumentException {
        return Utils.convertDbLikeValue(value, lookaround, '\\');
    }

    public static final String convertDbLikeValue(String value, boolean lookaround, char escapeCharacter) throws IllegalArgumentException {
        if (value != null) {
            String regexEscape = Utils.escapeAdapt(escapeCharacter);
            value = value.replaceAll("&", "&amp");
            value = value.replaceAll(String.valueOf(regexEscape) + regexEscape, "&esch");
            value = value.replaceAll("(?<=" + regexEscape + ")[\\[]", "[[]");
            value = value.replaceAll("[%_]", String.valueOf(regexEscape) + "$0");
            if (lookaround) {
                if (!value.isEmpty()) {
                    int length = value.length();
                    if (value.charAt(0) == '*') {
                        value = "%" + value.substring(1);
                    }
                    if (value.charAt(0) == '?') {
                        value = "_" + value.substring(1);
                    }
                    if (value.charAt(length - 1) == '*' && (length == 1 || value.charAt(length - 2) != escapeCharacter)) {
                        value = String.valueOf(value.substring(0, length - 1)) + "%";
                    }
                    if (value.charAt(length - 1) == '?' && (length == 1 || value.charAt(length - 2) != escapeCharacter)) {
                        value = String.valueOf(value.substring(0, length - 1)) + "_";
                    }
                }
            } else {
                value = value.replaceAll("(?<!" + regexEscape + ")[*]", "%").replaceAll("(?<!" + regexEscape + ")[?]", "_");
            }
            value = value.replaceAll(String.valueOf(regexEscape) + "([^%_])", "$1");
            value = value.replaceAll("'", "''");
            value = value.replaceAll("&esch", regexEscape);
            value = value.replaceAll("&amp", "&");
            value = value.replaceAll("\\\\(?![%_])", "\\\\\\\\");
        }
        return value;
    }

    public static String escapeAdapt(char escapeCharacter) {
        return escapeCharacter == '\\' ? "\\\\" : "" + escapeCharacter;
    }

    private static Set<String> readUtilities() {
        HashSet<String> rez;
        block17: {
            File utilitiesFile;
            rez = new HashSet<String>();
            String utilitiesFileName = System.getProperty("mainframe.utilities", null);
            if (utilitiesFileName != null && (utilitiesFile = new File(utilitiesFileName)).isFile() && utilitiesFile.exists()) {
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new FileReader(utilitiesFile));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            rez.add(line.trim().toUpperCase());
                        }
                    }
                    catch (IOException e) {
                        L.error("could not read {}", (Object)utilitiesFile, (Object)e);
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                L.error("could not close stream", (Throwable)e2);
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            L.error("could not close stream", (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        L.error("could not close stream", (Throwable)e);
                    }
                }
            }
        }
        if (rez.isEmpty()) {
            rez = null;
        }
        return rez;
    }

    public static boolean isUtility(String name) {
        return utilities.contains(name.toUpperCase());
    }

    public static void queryForProgramChildren(EZSourceConnection conn, Set<String> parents, List<ProgramInputNoGUI> toComplete) {
        block15: {
            try {
                String tempTblName = null;
                ServerType engine = Utils.getDbEngine(conn);
                switch (engine) {
                    case Db2: 
                    case Db2Z: {
                        tempTblName = "SESSION.string_param_temp";
                        break;
                    }
                    case SqlServer: {
                        tempTblName = "#string_param_temp";
                        break;
                    }
                }
                if (tempTblName == null) break block15;
                String query = "select distinct child.programid, parent.programname from programs child join programs parent on child.ancestor=parent.programname where parent.programname in (select * from  " + tempTblName + ") " + "order by parent.programname";
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[parents.size()]);
                Collections.fill(types, EZSourceDataType.String);
                String[][] programs = conn.executeSQL(query, types, new ArrayList<String>(parents));
                if (programs != null) {
                    Collections.sort(toComplete);
                    int i = 0;
                    boolean cont = true;
                    while (cont) {
                        String prgName = programs[i][1];
                        ProgramInputNoGUI inpt = null;
                        try {
                            inpt = toComplete.get(0);
                            L.trace("1. prgName={} ;;; inpt={}", (Object)prgName, (Object)inpt.getName());
                        }
                        catch (Exception e) {
                            L.error("1. not found prg {} to complete!", (Object)prgName, (Object)e);
                            cont = false;
                        }
                        if (inpt == null) continue;
                        int j = 0;
                        while (inpt != null && !inpt.getName().equalsIgnoreCase(prgName)) {
                            try {
                                inpt = toComplete.get(j);
                                L.trace("2. prgName={} ;;; inpt={}", (Object)prgName, (Object)inpt.getName());
                                ++j;
                            }
                            catch (Exception e) {
                                L.error("2. not found prg {} to complete!", (Object)prgName, (Object)e);
                                inpt = null;
                                cont = false;
                            }
                        }
                        if (inpt == null) continue;
                        toComplete.remove((Object)inpt);
                        while (i < programs.length && programs[i][1].equalsIgnoreCase(prgName)) {
                            String childId = programs[i][0];
                            inpt.addChildId(childId);
                            prgName = programs[i][1];
                            ++i;
                        }
                        boolean bl = cont = i < programs.length;
                    }
                }
                parents = null;
                toComplete = null;
            }
            catch (EZSourceNativeException e) {
                L.error("exception at getting children of assembler programs: {}", parents, (Object)e);
                throw e;
            }
            catch (Throwable ex) {
                L.error("completeSelectedPrograms()", ex);
            }
        }
    }

    public static ServerType getDbEngine(EZSourceConnection conn) {
        ServerType engine = conn.getProjectInfo().getDbEngine();
        return engine;
    }

    public static boolean prepareCache(EZSourceConnection conn, String viewName, IProgressMonitor pMonitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pMonitor);
        sm.setTaskName(Messages.getString(Utils.class, "cacheData.taskName"));
        if (viewName == null) {
            return true;
        }
        boolean ok = false;
        ServerType engine = Utils.getDbEngine(conn);
        conn.beginTransaction();
        try {
            try {
                switch (engine) {
                    case Db2: 
                    case Db2Z: {
                        String schemaName = conn.getProjectInfo().getDatabaseInfo().getSchema();
                        if (schemaName == null) {
                            String projectName = conn.getProjectInfo().getProjectName();
                            L.error("null schema name for project: {}; please check settings!", (Object)projectName);
                            throw new RuntimeException(Messages.getString(Utils.class, "noSchemaForProject.exception", new String[]{projectName}));
                        }
                        Object[] objectArray = new Object[4];
                        objectArray[0] = viewName;
                        objectArray[1] = schemaName;
                        objectArray[2] = 3000;
                        Object[] paramsList = objectArray;
                        ParameterInfo[] paramsInfo = new ParameterInfo[]{ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)12), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)12), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Output, (int)4)};
                        conn.execNonTransactionalStoredProc("EZViewer_Prepare_Cache", paramsList, paramsInfo);
                        if (paramsList == null || paramsList.length <= 3) break;
                        ok = (Integer)paramsList[3] >= 0;
                        break;
                    }
                    case SqlServer: {
                        String[][] rez = conn.executeSQL("declare @result int\nexec @result=EZViewer_Prepare_Cache '" + viewName + "', " + lockTimeout + "\n" + "select @result ");
                        if (rez == null || rez.length <= 0) break;
                        ok = Integer.valueOf(rez[0][0]) >= 0;
                    }
                }
                conn.voteCommitTransaction();
            }
            catch (Exception e) {
                L.error("while preparing cache", (Throwable)e);
                conn.endTransaction();
            }
        }
        finally {
            conn.endTransaction();
        }
        return ok;
    }

    public static String getPrgType(String prgTypeID) {
        String prgType = "";
        if (Utils.filterNullValue(prgTypeID) == null) {
            L.warn("null type for id: {}", (Object)prgTypeID);
            prgTypeID = "0";
        }
        int dbPrgTypeID = Integer.valueOf(prgTypeID);
        switch (dbPrgTypeID) {
            case 0: {
                prgType = GraphNode.UNKNOWN_CALLED_PROGRAM_TYPE;
                break;
            }
            case -1: {
                prgType = GraphNode.DYNAMIC_CALLED_PROGRAM_TYPE;
                break;
            }
            default: {
                ProgramType[] prgTypes = ProgramType.values();
                if (dbPrgTypeID < prgTypes.length) {
                    prgType = prgTypes[dbPrgTypeID].toString();
                    break;
                }
                L.warn("unknown type of program: {}", (Object)dbPrgTypeID);
            }
        }
        return prgType;
    }

    public static boolean isSCLStandardProcedure(String name) {
        boolean ret = false;
        L.info("read standard procedures from JSON");
        ret = SCLProceduresReader.getSCLProceduresContainer().isSCLStandardProcedure(name);
        return ret;
    }

    public static String[][] runStoredProcedure(EZSourceConnection conn, String procName, Object[] procParams, ParameterInfo[] paramInfo, List<? extends Object> params, EZSourceDataType paramType, IProgressMonitor pmonitor) {
        String[][] result = null;
        if (procParams == null) {
            procParams = new Object[]{};
        }
        try {
            List<EZSourceDataType> types = null;
            if (params != null && !params.isEmpty()) {
                types = Arrays.asList(new EZSourceDataType[params.size()]);
                Collections.fill(types, paramType);
                result = paramInfo != null ? conn.execNonTransactionalStoredProc(procName, procParams, paramInfo, types, params) : conn.execNonTransactionalStoredProc(procName, procParams, types, params);
            } else {
                result = paramInfo != null ? conn.execNonTransactionalStoredProc(procName, procParams, paramInfo) : conn.execNonTransactionalStoredProc(procName, procParams);
            }
        }
        catch (Exception e) {
            L.error("error at executing procedure {} with params: {} and temporaryTblParams: {}", new Object[]{procName, procParams != null ? Arrays.toString(procParams) : "null", params, e});
        }
        pmonitor.done();
        return result;
    }

    public static List<StmtGroup> getStmtGroups(Map<Integer, StmtType> allStmtTypes, List<Integer> parents, List<Integer> children) {
        ArrayList<StmtGroup> groups = new ArrayList<StmtGroup>();
        Properties prop = Utils.loadPropFile(STMTGROUPS_PATH_IN_PROJECT);
        if (prop == null) {
            L.error("cannot load statement groups; an empty map it will be used");
            prop = new Properties();
        }
        int nGroups = Integer.valueOf(prop.getProperty("groups", "0"));
        int i = 0;
        while (i <= nGroups) {
            String parent = prop.getProperty("group." + i + ".parent");
            boolean allowGroup = true;
            if (parent != null && parents != null && children != null && parents.contains(Integer.parseInt(parent))) {
                allowGroup = false;
                L.debug("parent {} has subgoups that should be filtered", (Object)parent);
                int j = 0;
                while (j < children.size()) {
                    if (children.get(j) == i) {
                        L.debug("group {} will not be filtered", (Object)i);
                        allowGroup = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!allowGroup) {
                String stmtTypes = prop.getProperty("group." + i);
                if (stmtTypes != null && !stmtTypes.equals("")) {
                    Utils.buildStmtTypesForGroup(null, stmtTypes, allStmtTypes);
                }
                groups.add(i, null);
            } else {
                String subgroupsString;
                StmtGroup group = new StmtGroup();
                group.setId(new Integer(i));
                group.setName(prop.getProperty("group." + i + ".name"));
                L.debug("processing group {}", (Object)group.getName());
                if (parent != null && !parent.equals("")) {
                    group.setParent(parent);
                }
                if ((subgroupsString = prop.getProperty("group." + i + ".subgroups")) != null && !subgroupsString.equals("")) {
                    HashSet<Integer> subgroupsSet = new HashSet<Integer>();
                    String[] subgroups = subgroupsString.split(",");
                    int k = 0;
                    while (k < subgroups.length) {
                        subgroupsSet.add(new Integer(subgroups[k]));
                        ++k;
                    }
                    group.setSubgroups(subgroupsSet);
                }
                groups.add(i, group);
                String stmtTypes = prop.getProperty("group." + i);
                if (stmtTypes != null && !stmtTypes.equals("")) {
                    Utils.buildStmtTypesForGroup(group, stmtTypes, allStmtTypes);
                }
            }
            ++i;
        }
        ((StmtGroup)groups.get(0)).getTypes().clear();
        return groups;
    }
}

