/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.data.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextSelectionInFile {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TextSelectionInFile.class);
    public static final String VERTEX_ID_KEY = "vertexID";
    private String fileName;
    private int[] bounds;
    private String prgType;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public TextSelectionInFile(String fileName, String prgType) {
        this.fileName = fileName;
        this.prgType = prgType;
    }

    public TextSelectionInFile(String fileName, String prgType, Integer ... intPositionInfo) {
        this.fileName = fileName;
        this.prgType = prgType;
        if (intPositionInfo != null) {
            int[] bounds = new int[intPositionInfo.length];
            int i = 0;
            while (i < intPositionInfo.length) {
                bounds[i] = intPositionInfo[i];
                ++i;
            }
            this.bounds = bounds;
        }
    }

    public TextSelectionInFile(String fileName, String prgType, String ... positionInfos) {
        this.fileName = fileName;
        this.prgType = prgType;
        if (positionInfos != null) {
            int[] bounds = new int[positionInfos.length];
            int i = 0;
            while (i < positionInfos.length) {
                int pos;
                bounds[i] = pos = Integer.parseInt(positionInfos[i]);
                ++i;
            }
            this.bounds = bounds;
        }
    }

    public void setBounds(int[] bounds) {
        this.bounds = bounds;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int[] getBounds() {
        return this.bounds;
    }

    public String getPrgType() {
        return this.prgType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bounds);
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.prgType == null ? 0 : this.prgType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextSelectionInFile other = (TextSelectionInFile)obj;
        if (!Arrays.equals(this.bounds, other.bounds)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        return !(this.prgType == null ? other.prgType != null : !this.prgType.equals(other.prgType));
    }

    public String toString() {
        return "TextSelectionInFile [fileName=" + this.fileName + ", bounds=" + Arrays.toString(this.bounds) + ", prgType=" + this.prgType + "]";
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }
}

