/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.data.utils;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramInputsFactory<T extends ProgramInputNoGUI> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramInputsFactory.class);
    protected static ProgramInputsFactory _INSTANCE = null;
    private boolean hasImages = false;
    private static String programsQuery = "SELECT ProgramAliases.AliasName, ProgramAliases.ProgramId FROM Programs INNER JOIN ProgramAliases \t\tON Programs.ProgramID = ProgramAliases.ProgramId WHERE OccurID <> 0  \tAND (Programs.ProgramTypeID not in (9, 13, 15, 16, 14) ) \t\tAND ProgramAliases.AliasType = 0 ORDER BY ProgramAliases.AliasName";
    public static String programsQryWithType = Utils.PRGS_OCCUR_NOTIN_QUERY.replace("MARKER", " 9, 13, 14, 15, 16 ");
    @Deprecated
    public static String programsQryWithTypeWithoutOccurCondition = "SELECT ProgramName, ProgramTypeID, ProgramID FROM Programs \n\twhere (Programs.ProgramTypeID in (1, 2, 3, 7, 8, 10, 11) ) \n\tor (Programs.ProgramTypeID = 19 and Programs.ProgramName not in (select Name from SCLStandardProcedures))\n   order by ProgramName";

    public static ProgramInputsFactory getInstance() {
        if (_INSTANCE == null) {
            ProgramInputsFactory.instantiator();
        }
        return _INSTANCE;
    }

    protected static void instantiator() {
        _INSTANCE = new ProgramInputsFactory();
        _INSTANCE.setHasImages(false);
    }

    public List<ProgramInputNoGUI> buildProgramInputs(String[][] programs, boolean considerAssChildren) {
        this.init();
        ArrayList ret = null;
        if (programs != null) {
            TreeSet<ProgramInputNoGUI> availablePrograms = new TreeSet<ProgramInputNoGUI>();
            ProgramInputNoGUI inpt = null;
            int i = 0;
            while (i < programs.length) {
                boolean added;
                String prgName = programs[i][0];
                inpt = this.instantiateObj(prgName);
                String appName = "";
                if (programs[0].length > 1) {
                    if (!programs[i][1].isEmpty()) {
                        Integer prgType = Integer.valueOf(programs[i][1]);
                        inpt.setType(prgType);
                        L.debug("{} has type: {}", (Object)prgName, (Object)prgType);
                        this.buildImages4Wizard(considerAssChildren, prgType);
                    }
                    if (programs[0].length > 2) {
                        appName = Utils.filterNullValue(programs[i][2]);
                        if (programs[0].length > 3) {
                            Integer dbID = Integer.valueOf(programs[i][3]);
                            inpt.setProgramID(dbID);
                            L.debug("{} has ID: {}", (Object)prgName, (Object)dbID);
                            if (programs[0].length > 4) {
                                String parentName = programs[i][4];
                                inpt.setAncestorName(parentName);
                                L.debug("{} has parent: {}", (Object)prgName, (Object)parentName);
                            }
                        }
                    }
                }
                if (!(added = availablePrograms.add(inpt)) && appName != null && !appName.isEmpty()) {
                    if ((inpt = ProgramInputsFactory.get(availablePrograms, inpt)) != null) {
                        inpt.addApplicationName(appName);
                    }
                } else if (appName != null && !appName.isEmpty()) {
                    inpt.addApplicationName(appName);
                } else {
                    L.info("no appName for program: {}", (Object)prgName);
                }
                ++i;
            }
            ret = new ArrayList(availablePrograms);
        }
        return ret;
    }

    protected ProgramInputNoGUI instantiateObj(String prgName) {
        return new ProgramInputNoGUI(prgName);
    }

    public List<ProgramInputNoGUI> buildProgramInputs(String[][] programs) {
        return this.buildProgramInputs(programs, false);
    }

    public List<ProgramInputNoGUI> getAvailablePrograms(EZSourceConnection bridge) {
        ArrayList<ProgramInputNoGUI> availablePrograms = new ArrayList<ProgramInputNoGUI>();
        String[][] programs = bridge.executeSQL(programsQuery);
        if (programs != null) {
            int i = 0;
            while (i < programs.length) {
                ProgramInputNoGUI inpt = this.instantiateObj(programs[i][0]);
                if (programs[i].length > 1) {
                    inpt.setProgramID(Integer.valueOf(programs[i][1]));
                }
                availablePrograms.add(inpt);
                L.debug(programs[i][0]);
                ++i;
            }
        }
        return availablePrograms;
    }

    public List<ProgramInputNoGUI> getAvailableProgramsForApp(String programsQuery, Set appIDs, EZSourceConnection bridge) {
        if (appIDs == null || appIDs.isEmpty()) {
            return this.getAvailablePrograms(bridge);
        }
        String qryStr = programsQuery;
        String[][] programs = null;
        try {
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[appIDs.size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            programs = bridge.executeSQL(qryStr, types, new ArrayList(appIDs));
        }
        catch (EZSourceNativeException e) {
            L.error("exception at getting available programs of applications: {}", (Object)appIDs, (Object)e);
        }
        List<ProgramInputNoGUI> ret = this.buildProgramInputs(programs);
        return ret;
    }

    @Deprecated
    public List<ProgramInputNoGUI> getAvailableProgramsWithTypesForApp(String programsQuery, Set appIDs) {
        return this.getAvailableProgramsWithTypesForApp(null, programsQuery, appIDs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ProgramInputNoGUI> getAvailableProgramsWithTypesForApp(EZSourceConnection conn, String programsQuery, Set appIDs) {
        EZSourceConnection bridge;
        String[][] programs;
        block5: {
            programs = null;
            bridge = null;
            EZSourceConnection eZSourceConnection = bridge = conn == null ? EZSourceConnectionManager.getCurrent() : conn;
            if (appIDs != null && !appIDs.isEmpty()) break block5;
            List<ProgramInputNoGUI> list = this.getAvailableProgramsWithTypes(bridge);
            if (conn != null) return list;
            if (bridge == null) return list;
            EZSourceConnectionManager.release((EZSourceConnection)bridge);
            return list;
        }
        try {
            try {
                String qryStr = programsQuery;
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[appIDs.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                programs = bridge.executeSQL(qryStr, types, new ArrayList(appIDs));
            }
            catch (EZSourceNativeException e) {
                L.error("exception at getting available programs of applications: {}", (Object)appIDs, (Object)e);
                if (conn != null) return this.buildProgramInputs(programs);
                if (bridge == null) return this.buildProgramInputs(programs);
                EZSourceConnectionManager.release((EZSourceConnection)bridge);
                return this.buildProgramInputs(programs);
            }
        }
        catch (Throwable throwable) {
            if (conn != null) throw throwable;
            if (bridge == null) throw throwable;
            EZSourceConnectionManager.release((EZSourceConnection)bridge);
            throw throwable;
        }
        if (conn != null) return this.buildProgramInputs(programs);
        if (bridge == null) return this.buildProgramInputs(programs);
        EZSourceConnectionManager.release((EZSourceConnection)bridge);
        return this.buildProgramInputs(programs);
    }

    public List<ProgramInputNoGUI> getAvailableProgramsWithTypes(EZSourceConnection bridge) {
        ArrayList<ProgramInputNoGUI> availablePrograms = new ArrayList<ProgramInputNoGUI>();
        this.init();
        String[][] programs = bridge.executeSQL(programsQryWithType);
        if (programs != null) {
            int i = 0;
            while (i < programs.length) {
                String prgName = programs[i][0];
                Integer prgType = Integer.valueOf(programs[i][1]);
                Integer dbID = new Integer(0);
                if (programs[i].length > 2) {
                    dbID = Integer.valueOf(programs[i][2]);
                }
                String path = null;
                if (programs[i].length > 3) {
                    path = programs[i][3];
                }
                availablePrograms.add(this.instantiateObj(prgName, prgType, dbID, path));
                L.debug("{} has type: {}", (Object)prgName, (Object)prgType);
                this.buildImages4Wizard(prgType, false);
                ++i;
            }
        }
        return availablePrograms;
    }

    public List<ProgramInputNoGUI> getProgramsWithTypes(String programsQuery, EZSourceConnection bridge) {
        if (programsQuery == null) {
            return this.getAvailableProgramsWithTypes(bridge);
        }
        this.init();
        HashSet<ProgramInputNoGUI> availablePrograms = new HashSet<ProgramInputNoGUI>();
        String[][] programs = bridge.executeSQL(programsQuery);
        if (programs != null) {
            int i = 0;
            while (i < programs.length) {
                String prgName = programs[i][0];
                Integer prgType = Integer.valueOf(programs[i][1]);
                Integer dbID = new Integer(0);
                if (programs[i].length > 2) {
                    dbID = Integer.valueOf(programs[i][2]);
                }
                String path = null;
                if (programs[i].length > 3) {
                    path = programs[i][3];
                }
                availablePrograms.add(this.instantiateObj(prgName, prgType, dbID, path));
                L.debug("{} has type: {}", (Object)prgName, (Object)prgType);
                this.buildImages4Wizard(prgType, true);
                ++i;
            }
        }
        return new ArrayList<ProgramInputNoGUI>(availablePrograms);
    }

    protected ProgramInputNoGUI instantiateObj(String prgName, Integer prgType, Integer dbID, String path) {
        return new ProgramInputNoGUI(prgName, prgType, dbID);
    }

    public List<ProgramInputNoGUI> getAvailablePrograms(String programsQuery, EZSourceConnection bridge) {
        if (programsQuery == null) {
            return this.getAvailablePrograms(bridge);
        }
        ArrayList<ProgramInputNoGUI> availablePrograms = new ArrayList<ProgramInputNoGUI>();
        String[][] programs = bridge.executeSQL(programsQuery);
        if (programs != null) {
            int i = 0;
            while (i < programs.length) {
                ProgramInputNoGUI inpt = this.instantiateObj(programs[i][0]);
                if (programs[i].length > 1) {
                    inpt.setProgramID(Integer.valueOf(programs[i][1]));
                }
                availablePrograms.add(inpt);
                L.debug(programs[i][0]);
                ++i;
            }
        }
        return availablePrograms;
    }

    private static ProgramInputNoGUI get(Set<ProgramInputNoGUI> prgs, ProgramInputNoGUI toFind) {
        for (ProgramInputNoGUI programInput : prgs) {
            if (!programInput.equals((Object)toFind)) continue;
            return programInput;
        }
        return null;
    }

    protected void init() {
    }

    protected void buildImages4Wizard(Integer prgType, boolean bool) {
    }

    protected void buildImages4Wizard(boolean considerAssChildren, Integer prgType) {
    }

    public boolean isHasImages() {
        return this.hasImages;
    }

    public void setHasImages(boolean hasImages) {
        this.hasImages = hasImages;
    }
}

