/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.data.callgraph;

import com.ez.mainframe.data.callgraph.ResourceLink;
import com.ez.mainframe.data.internal.Messages;
import com.ez.mainframe.data.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphNode
implements Serializable,
Comparable<GraphNode> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer dbId;
    private int id;
    private List<GraphNode> followings;
    private Map<GraphNode, Map<String, List<String>>> attributes = new HashMap<GraphNode, Map<String, List<String>>>();
    private List<GraphNode> parents;
    private Map<String, Object> properties;
    private List<ResourceLink> resources;
    private static int idx = 0;
    private String path;
    public static final String ANCESTOR_NAME = "ANCESTOR_NAME";
    public static final String ANCESTOR_PROGRAM_ID = "ANCESTOR_PRG_ID";
    public static final String PROGRAM_TYPE_ID = "PROGRAM_TYPE_ID";
    public static final String PROGRAM_ID = "PROGRAM_ID";
    public static final String DYNAMIC_CALLED_PROGRAM_TYPE = Messages.getString(GraphNode.class, "call.programType.dynamic");
    public static final String UNKNOWN_CALLED_PROGRAM_TYPE = Messages.getString(GraphNode.class, "call.programType.unknown");

    public GraphNode(String name) {
        this.name = name;
        this.id = idx++;
        this.followings = new ArrayList<GraphNode>();
        this.parents = new ArrayList<GraphNode>();
        this.resources = new ArrayList<ResourceLink>();
    }

    public GraphNode(String name, Integer dbID) {
        this(name);
        this.dbId = dbID;
    }

    @Override
    public int compareTo(GraphNode other) {
        return this.name.compareToIgnoreCase(other.getName());
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphNode other = (GraphNode)obj;
        return this.id == other.id;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithAncestor() {
        String ancestorName = (String)this.getProperty(ANCESTOR_NAME);
        return ancestorName != null && !ancestorName.isEmpty() ? ancestorName.concat(":").concat(this.name) : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<GraphNode> getFollowings() {
        return this.followings;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addFollowing(GraphNode follow) {
        if (!this.followings.contains(follow)) {
            this.followings.add(follow);
        }
    }

    public void setFollowingOrParentAttribute(GraphNode followOrParent, String attrKey, String attrValue) {
        List<String> l;
        if (attrKey == null) {
            return;
        }
        Map<String, List<String>> attrs = this.attributes.get(followOrParent);
        if (attrs == null) {
            attrs = new HashMap<String, List<String>>();
            this.attributes.put(followOrParent, attrs);
        }
        if ((l = attrs.get(attrKey)) == null) {
            l = new ArrayList<String>();
            attrs.put(attrKey, l);
        }
        l.add(attrValue);
    }

    public List<String> getFollowingOrParentAttribute(GraphNode followOrParent, String attrKey) {
        List<String> ret = null;
        Map<String, List<String>> attrs = this.attributes.get(followOrParent);
        if (attrs != null) {
            ret = attrs.get(attrKey);
        }
        return ret;
    }

    public void addTestFollowing(GraphNode follow) {
        this.followings.add(follow);
        follow.addParent(this);
    }

    public List<GraphNode> getParents() {
        return this.parents;
    }

    public void setParents(List<GraphNode> parents) {
        this.parents = parents;
    }

    public void addParent(GraphNode parent) {
        if (!this.parents.contains(parent)) {
            this.parents.add(parent);
        }
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public void addProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    public boolean isDynamic() {
        Object val = this.getProperty(PROGRAM_TYPE_ID);
        if (val != null) {
            String prgType = Utils.getPrgType((String)val);
            return DYNAMIC_CALLED_PROGRAM_TYPE.equals(prgType);
        }
        return false;
    }

    public boolean isUnknown() {
        Object val = this.getProperty(PROGRAM_TYPE_ID);
        if (val != null) {
            String prgType = Utils.getPrgType((String)val);
            return UNKNOWN_CALLED_PROGRAM_TYPE.equals(prgType);
        }
        return false;
    }

    public void addResourceLink(ResourceLink rl) {
        this.resources.add(rl);
    }

    public List<ResourceLink> getResourceLinks() {
        return this.resources;
    }
}

