/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.computation;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.computation.ProgramsVsCollector;
import com.ez.mainframe.data.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramVsIncludesCollector
extends ProgramsVsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramVsIncludesCollector.class);

    public ProgramVsIncludesCollector(boolean selective, boolean considerChildrens) {
        this.isSelective = selective;
        this.considerChildrens = considerChildrens;
    }

    @Override
    public String[][] compute(IProgressMonitor monitor, Collection<Integer> ids, EZSourceConnection conn) {
        String[][] no = null;
        monitor.subTask(ProgramVsIncludesCollector.getExecutingQuerySubtaskName());
        String procName = this.isSelective ? "EZReports_ListingOfAllIncludeFilesUsedInProgram_Selective" : "EZReports_ListingOfAllIncludeFilesUsedInProgram";
        try {
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            no = conn.execNonTransactionalStoredProc(procName, new String[0], types, new ArrayList<Integer>(ids));
        }
        catch (EZSourceConnectionException e) {
            L.error("exception at executing stored procedure", (Throwable)e);
        }
        monitor.subTask(ProgramVsIncludesCollector.getPreparingDataSubtaskName());
        String[][] result = null;
        if (no != null) {
            ArrayList<String[]> res = new ArrayList<String[]>();
            HashMap<String, Integer> temp = new HashMap<String, Integer>();
            String prevProgram = null;
            String prevParentID = null;
            String prevProgramID = null;
            int i = 0;
            while (i < no.length) {
                String prgName = no[i][0];
                String inclName = no[i][1];
                String stmtCount = no[i][2];
                String parentName = no[i][3];
                String prgID = no[i][4];
                String parentID = no[i][5];
                L.debug("program: {}", (Object)prgName);
                L.debug("numberOfStatements value: {}", (Object)stmtCount);
                L.debug("\n");
                if (Utils.filterNullValue(parentName) == null || parentName.isEmpty()) {
                    this.storeData(res, temp, prevProgram, prevProgramID, prevParentID);
                    prevProgram = null;
                    temp = null;
                    res.add(no[i]);
                } else {
                    String name;
                    String string = name = this.considerChildrens ? prgName : parentName;
                    if (prgID.equalsIgnoreCase(prevProgramID)) {
                        Integer v = (Integer)temp.get(inclName);
                        if (v == null) {
                            v = new Integer(0);
                        }
                        v = new Integer(v + Integer.valueOf(stmtCount));
                        temp.put(inclName, v);
                    } else {
                        this.storeData(res, temp, prevProgram, prevProgramID, prevParentID);
                        prevProgram = name;
                        prevProgramID = prgID;
                        prevParentID = parentID;
                        temp = new HashMap();
                        temp.put(inclName, Integer.valueOf(stmtCount));
                    }
                }
                ++i;
            }
            this.storeData(res, temp, prevProgram, prevProgramID, prevParentID);
            prevProgram = null;
            temp = null;
            result = (String[][])res.toArray((T[])new String[0][]);
        }
        return result;
    }

    private void storeData(Collection<String[]> res, Map<String, Integer> temp, String prevProgram, String progID, String parentprogID) {
        if (prevProgram != null) {
            ArrayList<String> includes = new ArrayList<String>(temp.keySet());
            Collections.sort(includes);
            for (String include : includes) {
                String[] v = new String[]{prevProgram, include, temp.get(include).toString(), progID, parentprogID};
                res.add(v);
            }
        }
    }
}

