/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.computation;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.computation.ProgramsVsCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramVsIMSDBCollector
extends ProgramsVsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramVsIMSDBCollector.class);

    public ProgramVsIMSDBCollector(boolean selective, boolean considerChildrens) {
        this.isSelective = selective;
        this.considerChildrens = considerChildrens;
    }

    @Override
    public String[][] compute(IProgressMonitor monitor, Collection<Integer> ids, EZSourceConnection conn) {
        String[][] no = null;
        monitor.subTask(ProgramVsIMSDBCollector.getExecutingQuerySubtaskName());
        String procName = "EZViewer_IMSDBProgVsSegUsage";
        if (procName != null && !procName.isEmpty()) {
            try {
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                no = conn.execNonTransactionalStoredProc(procName, new String[0], types, new ArrayList<Integer>(ids));
            }
            catch (EZSourceConnectionException e) {
                L.error("exception at executing stored procedure", (Throwable)e);
            }
        }
        monitor.subTask(ProgramVsIMSDBCollector.getPreparingDataSubtaskName());
        String[][] result = null;
        if (no != null) {
            ArrayList<String[]> res = new ArrayList<String[]>();
            HashMap<String, Map<String, Integer>> temp = new HashMap<String, Map<String, Integer>>();
            String prevProgramID = null;
            String prevProgram = null;
            int i = 0;
            while (i < no.length) {
                HashMap<String, Integer> temp1;
                String prgName = no[i][0];
                String prgID = no[i][1];
                String dbName = no[i][3];
                String stmtType = no[i][10];
                Integer stmtCount = new Integer(Integer.parseInt(no[i][11]));
                L.debug("fileName: {}", (Object)prgName);
                L.debug("stmt: {}", (Object)stmtType);
                L.debug("numberOfStatements value: {}", (Object)stmtCount);
                L.debug("\n");
                if (prgID.equalsIgnoreCase(prevProgramID)) {
                    Integer v;
                    temp1 = (HashMap<String, Integer>)temp.get(dbName);
                    if (temp1 == null) {
                        temp1 = new HashMap<String, Integer>();
                        temp.put(dbName, temp1);
                    }
                    if ((v = (Integer)temp1.get(stmtType)) == null) {
                        v = new Integer(0);
                    }
                    v = new Integer(v + Integer.valueOf(stmtCount));
                    temp1.put(stmtType, v);
                } else {
                    this.storeData(res, temp, prevProgram, prevProgramID);
                    prevProgram = prgName;
                    prevProgramID = prgID;
                    temp = new HashMap();
                    temp1 = new HashMap();
                    temp1.put(stmtType, stmtCount);
                    temp.put(dbName, temp1);
                }
                ++i;
            }
            this.storeData(res, temp, prevProgram, prevProgramID);
            prevProgram = null;
            temp = null;
            result = (String[][])res.toArray((T[])new String[0][]);
        }
        return result;
    }

    private void storeData(Collection<String[]> res, Map<String, Map<String, Integer>> temp, String prevProgram, String prgID) {
        if (prevProgram != null) {
            ArrayList<String> files = new ArrayList<String>(temp.keySet());
            Collections.sort(files);
            for (String file : files) {
                Map<String, Integer> temp1 = temp.get(file);
                ArrayList<String> stmts = new ArrayList<String>(temp1.keySet());
                Collections.sort(stmts);
                for (String stmt : stmts) {
                    String[] v = new String[]{prevProgram, file, stmt, temp1.get(stmt).toString(), prgID};
                    res.add(v);
                }
            }
        }
    }
}

