/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.computation;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.computation.ProgramsVsCollector;
import com.ez.mainframe.data.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramVsIDMSRecordsAndSetsCollector
extends ProgramsVsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramVsIDMSRecordsAndSetsCollector.class);
    private int reportType = -1;

    public ProgramVsIDMSRecordsAndSetsCollector(boolean selective, boolean considerChildrens, int reportType) {
        this.isSelective = selective;
        this.considerChildrens = considerChildrens;
        this.reportType = reportType;
    }

    @Override
    public String[][] compute(IProgressMonitor monitor, Collection<Integer> ids, EZSourceConnection conn) {
        String[][] no = null;
        monitor.subTask(ProgramVsIDMSRecordsAndSetsCollector.getExecutingQuerySubtaskName());
        String procName = "";
        switch (this.reportType) {
            case 0: {
                procName = this.isSelective ? "EZReports_ProgramsVsIdmsRecordsUsage_Selective" : "EZReports_ProgramsVsIdmsRecordsUsage";
                break;
            }
            case 1: {
                String string = procName = this.isSelective ? "EZReports_ProgramsVsIdmsSetUsage2_Selective" : "EZReports_ProgramsVsIdmsSetUsage2";
            }
        }
        if (procName != null && !procName.isEmpty()) {
            try {
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                no = conn.execNonTransactionalStoredProc(procName, new String[0], types, new ArrayList<Integer>(ids));
            }
            catch (EZSourceConnectionException e) {
                L.error("exception at executing stored procedure", (Throwable)e);
            }
        }
        monitor.subTask(ProgramVsIDMSRecordsAndSetsCollector.getPreparingDataSubtaskName());
        String[][] result = null;
        if (no != null) {
            ArrayList<String[]> res = new ArrayList<String[]>();
            HashMap<String, Map<String, Integer>> temp = new HashMap<String, Map<String, Integer>>();
            String prevProgram = null;
            String key = null;
            String prevProgramID = null;
            int i = 0;
            while (i < no.length) {
                String prgName = no[i][0];
                String fileName = no[i][1];
                String stmtType = no[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(no[i][3]));
                String prgID = no[i][5];
                String prgAncestorID = no[i][6];
                String parentName = no[i][4];
                L.debug("program: {}", (Object)(!"".equals(parentName) ? String.valueOf(parentName) + ":" + prgName : prgName));
                L.debug("fileName: {}", (Object)fileName);
                L.debug("stmt: {}", (Object)stmtType);
                L.debug("numberOfStatements value: {}", (Object)stmtCount);
                L.debug("\n");
                String string = prevProgram != null ? key : (this.considerChildrens ? (prgAncestorID == null ? prgID : prgAncestorID) : (key = ""));
                if (Utils.filterNullValue(parentName) == null || parentName.isEmpty()) {
                    this.storeData(res, temp, prevProgram, prevProgramID, key);
                    prevProgram = null;
                    temp = null;
                    res.add(no[i]);
                } else {
                    HashMap<String, Integer> temp1;
                    String name;
                    String string2 = name = this.considerChildrens ? prgName : parentName;
                    if (prgID.equalsIgnoreCase(prevProgramID)) {
                        Integer v;
                        temp1 = (HashMap<String, Integer>)temp.get(fileName);
                        if (temp1 == null) {
                            temp1 = new HashMap<String, Integer>();
                            temp.put(fileName, temp1);
                        }
                        if ((v = (Integer)temp1.get(stmtType)) == null) {
                            v = new Integer(0);
                        }
                        v = new Integer(v + Integer.valueOf(stmtCount));
                        temp1.put(stmtType, v);
                    } else {
                        this.storeData(res, temp, prevProgram, prevProgramID, key);
                        prevProgram = name;
                        key = prgAncestorID;
                        prevProgramID = prgID;
                        temp = new HashMap();
                        temp1 = new HashMap();
                        temp1.put(stmtType, stmtCount);
                        temp.put(fileName, temp1);
                    }
                }
                ++i;
            }
            this.storeData(res, temp, prevProgram, prevProgramID, key);
            prevProgram = null;
            temp = null;
            result = (String[][])res.toArray((T[])new String[0][]);
        }
        return result;
    }

    private void storeData(Collection<String[]> res, Map<String, Map<String, Integer>> temp, String prevProgram, String prevProgramID, String key) {
        if (prevProgram != null) {
            ArrayList<String> files = new ArrayList<String>(temp.keySet());
            Collections.sort(files);
            for (String file : files) {
                Map<String, Integer> temp1 = temp.get(file);
                ArrayList<String> stmts = new ArrayList<String>(temp1.keySet());
                Collections.sort(stmts);
                for (String stmt : stmts) {
                    String[] v = new String[]{prevProgram, file, stmt, temp1.get(stmt).toString(), prevProgramID, key};
                    res.add(v);
                }
            }
        }
    }
}

