/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.computation;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.computation.ProgramsVsCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramVsDALCollector
extends ProgramsVsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramVsDALCollector.class);

    public ProgramVsDALCollector(boolean selective) {
        this.isSelective = selective;
    }

    @Override
    public String[][] compute(IProgressMonitor monitor, Collection<Integer> ids, EZSourceConnection conn) {
        String[][] no = null;
        monitor.subTask(ProgramVsDALCollector.getExecutingQuerySubtaskName());
        String procName = this.isSelective ? "EZReports_ProgramsVsDAL_Selective" : "EZReports_ProgramsVsDAL";
        try {
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            no = conn.execNonTransactionalStoredProc(procName, new String[0], types, new ArrayList<Integer>(ids));
        }
        catch (EZSourceConnectionException e) {
            L.error("exception at executing stored procedure", (Throwable)e);
        }
        monitor.subTask(ProgramVsDALCollector.getPreparingDataSubtaskName());
        String[][] result = null;
        if (no != null) {
            ArrayList<String[]> res = new ArrayList<String[]>();
            HashMap<String, Map<String, Integer>> temp = new HashMap<String, Map<String, Integer>>();
            Object prevProgram = null;
            int i = 0;
            while (i < no.length) {
                String prgName = no[i][0];
                String dalResName = no[i][1];
                String stmtName = no[i][2];
                String stmtCount = no[i][3];
                L.debug("program: {}", (Object)prgName);
                L.debug("DAL resource: {}", (Object)dalResName);
                L.debug("stmt: {}", (Object)stmtName);
                L.debug("numberOfStatements value: {}", (Object)stmtCount);
                L.debug("\n");
                this.storeData(res, temp, prevProgram);
                prevProgram = null;
                temp = null;
                res.add(no[i]);
                ++i;
            }
            this.storeData(res, temp, prevProgram);
            prevProgram = null;
            temp = null;
            result = (String[][])res.toArray((T[])new String[0][]);
        }
        return result;
    }

    private void storeData(Collection<String[]> res, Map<String, Map<String, Integer>> temp, String prevProgram) {
        if (prevProgram != null) {
            ArrayList<String> sqlTables = new ArrayList<String>(temp.keySet());
            Collections.sort(sqlTables);
            for (String dalRes : sqlTables) {
                Map<String, Integer> temp1 = temp.get(dalRes);
                ArrayList<String> stmts = new ArrayList<String>(temp1.keySet());
                Collections.sort(stmts);
                for (String stmt : stmts) {
                    String[] v = new String[]{prevProgram, dalRes, stmt, temp1.get(stmt).toString()};
                    res.add(v);
                }
            }
        }
    }
}

