/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.computation;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.mainframe.computation.ProgramsVsCollector;
import com.ez.mainframe.data.internal.Messages;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberOfStatementsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(NumberOfStatementsCollector.class);
    private boolean isSelective = true;

    public NumberOfStatementsCollector() {
        this(true);
    }

    public NumberOfStatementsCollector(boolean selective) {
        this.isSelective = selective;
    }

    public String[][] compute(EZSourceConnection conn, Collection<ProgramInputNoGUI> prgList, IProgressMonitor monitor) {
        monitor.subTask(Messages.getString(NumberOfStatementsCollector.class, "preparingQueryParams.subtask"));
        new HashMap();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (ProgramInputNoGUI progInput : prgList) {
            if (progInput.getTypeCode() == 8) {
                Collection<Integer> childrenIDs = progInput.getChildrenIDs();
                if (childrenIDs != null) {
                    ids.addAll(childrenIDs);
                    continue;
                }
                L.warn("assembler program without children?! {}", (Object)progInput.getName());
                ids.add(progInput.getResourceID());
                continue;
            }
            ids.add(progInput.getResourceID());
        }
        monitor.worked(10);
        return this.compute(monitor, ids, conn);
    }

    public String[][] compute(IProgressMonitor monitor, Collection<ProgramInputNoGUI> prgList) {
        return this.compute(null, prgList, monitor);
    }

    private String[][] compute(IProgressMonitor monitor, List<Integer> ids, EZSourceConnection conn) {
        String[][] no;
        block17: {
            String procName = this.isSelective ? "EZReports_NumberOfStatements_Selective" : "EZReports_NumberOfStatements";
            monitor.subTask(ProgramsVsCollector.getExecutingQuerySubtaskName());
            EZSourceConnection bridge = null;
            no = null;
            try {
                try {
                    bridge = conn != null ? conn : EZSourceConnectionManager.getCurrent();
                    List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
                    Collections.fill(types, EZSourceDataType.Integer);
                    no = bridge.execNonTransactionalStoredProc(procName, new String[0], types, ids);
                }
                catch (EZSourceConnectionException e) {
                    L.error("exception at executing stored procedure", (Throwable)e);
                    if (conn == null && bridge != null) {
                        EZSourceConnectionManager.release((EZSourceConnection)bridge);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (conn == null && bridge != null) {
                    EZSourceConnectionManager.release((EZSourceConnection)bridge);
                }
                throw throwable;
            }
            if (conn == null && bridge != null) {
                EZSourceConnectionManager.release((EZSourceConnection)bridge);
            }
        }
        monitor.subTask(ProgramsVsCollector.getPreparingDataSubtaskName());
        String[][] result = null;
        if (no != null) {
            ArrayList<String[]> res = new ArrayList<String[]>();
            String prevParent = null;
            String[] vals = null;
            int i = 0;
            while (i < no.length) {
                String prgName = no[i][0];
                String stmtCount = no[i][1];
                String prgID = no[i][3];
                String ancestorID = no[i][4];
                L.debug("program: {}", (Object)prgName);
                L.debug("numberOfStatements value: {}", (Object)stmtCount);
                L.debug("\n");
                String parentName = no[i][2];
                if (Utils.filterNullValue(parentName) != null && !parentName.isEmpty()) {
                    if (parentName.equals(prevParent)) {
                        vals[1] = String.valueOf(Integer.valueOf((String)vals[1]) + Integer.valueOf(stmtCount));
                    } else {
                        if (vals != null) {
                            res.add(vals);
                        }
                        vals = new String[]{parentName, stmtCount, ancestorID};
                        prevParent = parentName;
                    }
                } else {
                    if (vals != null) {
                        res.add(vals);
                        vals = null;
                    }
                    res.add(new String[]{prgName, stmtCount, prgID});
                }
                ++i;
            }
            if (vals != null) {
                res.add(vals);
            }
            result = (String[][])res.toArray((T[])new String[0][]);
        }
        return result;
    }
}

