/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.computation;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.mainframe.data.internal.Messages;
import com.ez.mainframe.data.utils.CloseTestRunnable;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McCabeValue {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(McCabeValue.class);

    public Map<String, Integer> computeCyclomatic(SubMonitor monitor, Set<ProgramInputNoGUI> prgList) {
        return this.computeCyclomatic(monitor, prgList, null);
    }

    public Map<String, Integer> computeCyclomatic(SubMonitor monitor, Set<ProgramInputNoGUI> prgList, EZSourceConnection conn) {
        String[][] cyclomaticResults;
        HashMap<Integer, ProgramInputNoGUI> inputMap;
        HashMap<String, Integer> generalCyclomaticResults;
        block15: {
            monitor.setTaskName(Messages.getString(McCabeValue.class, "prepareData.taskName"));
            monitor.subTask(Messages.getString(McCabeValue.class, "preparingQuery.subtask"));
            generalCyclomaticResults = new HashMap<String, Integer>();
            inputMap = new HashMap<Integer, ProgramInputNoGUI>();
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (ProgramInputNoGUI progInput : prgList) {
                generalCyclomaticResults.put(progInput.getListableName(), 0);
                inputMap.put(progInput.getProgramID(), progInput);
                if (progInput.getTypeCode() == 8) {
                    Collection<Integer> childrenIDs = progInput.getChildrenIDs();
                    if (childrenIDs != null) {
                        ids.addAll(childrenIDs);
                        continue;
                    }
                    L.warn("assembler program without children?! {}", (Object)progInput.getName());
                    ids.add(progInput.getResourceID());
                    continue;
                }
                ids.add(progInput.getResourceID());
            }
            monitor.worked(10);
            monitor.setTaskName(Messages.getString(McCabeValue.class, "getData.taskName"));
            cyclomaticResults = null;
            EZSourceConnection bridge = null;
            try {
                try {
                    monitor.subTask(Messages.getString(McCabeValue.class, "executingQuery.subtask"));
                    bridge = conn != null ? conn : EZSourceConnectionManager.getCurrent();
                    new CloseTestRunnable((IProgressMonitor)monitor);
                    List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
                    Collections.fill(types, EZSourceDataType.Integer);
                    cyclomaticResults = bridge.execNonTransactionalStoredProc("EZReports_DecisionStmt", new String[0], types, ids);
                    ids = null;
                }
                catch (EZSourceNativeException e) {
                    L.error("exception at executing stored procedure", (Throwable)e);
                    if (conn == null && bridge != null) {
                        EZSourceConnectionManager.release((EZSourceConnection)bridge);
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (conn == null && bridge != null) {
                    EZSourceConnectionManager.release(bridge);
                }
                throw throwable;
            }
            if (conn == null && bridge != null) {
                EZSourceConnectionManager.release((EZSourceConnection)bridge);
            }
        }
        monitor.worked(50);
        monitor.subTask(Messages.getString(McCabeValue.class, "preparingData.subtask"));
        if (cyclomaticResults == null) {
            L.warn("no results for base cyclomatic report");
        } else {
            L.debug("CYCLOMATIC results:");
            SubMonitor resMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(40), (int)cyclomaticResults.length);
            int i = 0;
            while (i < cyclomaticResults.length) {
                String programName = cyclomaticResults[i][0];
                String prgID = cyclomaticResults[i][3];
                ProgramInputNoGUI prg = (ProgramInputNoGUI)((Object)inputMap.get(Integer.valueOf(prgID)));
                programName = prg != null ? prg.getListableName() : programName;
                String value = cyclomaticResults[i][1];
                String parent = cyclomaticResults[i][2];
                L.debug("program: {}", (Object)programName);
                L.debug("base cyclomatic value: {}", (Object)value);
                L.debug("\n");
                String key = Utils.filterNullValue(parent) != null && !parent.isEmpty() ? parent : programName;
                Integer existing = (Integer)generalCyclomaticResults.get(key);
                if (existing == null) {
                    existing = new Integer(0);
                    L.warn("null value for programname={}, parent={} (key={})", new Object[]{programName, parent, key});
                }
                generalCyclomaticResults.put(key, existing + Integer.valueOf(value));
                resMonitor.worked(1);
                ++i;
            }
            resMonitor.setWorkRemaining(0);
        }
        return generalCyclomaticResults;
    }
}

