/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.computation;

import com.ez.common.model.LogMessage;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.analysis.AnalysisType;
import com.ez.mainframe.data.internal.Messages;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.StmtGroup;
import com.ez.mainframe.model.StmtType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HalsteadValue {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(HalsteadValue.class);
    public static final String DEFAULT_STATE = "true";
    static final String stmtTempTable = "stmtTypes";
    static final String procName = "EZViewer_Halstead";
    private Map<String, Object> reportProp = new HashMap<String, Object>();
    private Properties defaultProp;
    private String projectName;
    protected Queue<LogMessage> messages = new LinkedList<LogMessage>();

    public HalsteadValue(boolean readReportDefaultProperties, String projectName) {
        if (!readReportDefaultProperties) {
            this.defaultProp = new Properties();
        }
        this.projectName = projectName;
    }

    public String[][] computeHalsteadResults(SubMonitor monitor, Set prgList, Map params, Map<Integer, ProgramInputNoGUI> inputMap, ProjectInfo pInfo) {
        return this.computeHalsteadResults(monitor, prgList, params, inputMap, pInfo, null);
    }

    public String[][] computeHalsteadResults(SubMonitor monitor, Set prgList, Map params, Map<Integer, ProgramInputNoGUI> inputMap, ProjectInfo pInfo, EZSourceConnection conn) {
        String[][] halResults;
        HashMap<String, String> temp;
        ArrayList<Integer> paramHalst;
        List<Integer> operatorsSelList;
        block16: {
            operatorsSelList = this.prepareStatements(params, pInfo);
            monitor.setTaskName(Messages.getString(HalsteadValue.class, "prepareData.taskName"));
            monitor.subTask(Messages.getString(HalsteadValue.class, "prepareParameters.subtaskName"));
            L.trace("before find program IDs for Halstead procedure");
            paramHalst = new ArrayList<Integer>();
            temp = new HashMap<String, String>();
            for (ProgramInputNoGUI pi : prgList) {
                if (inputMap != null) {
                    inputMap.put(pi.getProgramID(), pi);
                }
                if (pi.getTypeCode() == 8) {
                    Collection<Integer> childrenIDs = pi.getChildrenIDs();
                    if (childrenIDs != null) {
                        for (Integer id : childrenIDs) {
                            paramHalst.add(id);
                            temp.put(id.toString(), pi.getResourceID().toString());
                        }
                        continue;
                    }
                    L.warn("assembler program without children?! {}", (Object)pi.getName());
                    paramHalst.add(pi.getResourceID());
                    continue;
                }
                paramHalst.add(pi.getResourceID());
            }
            monitor.worked(10);
            L.trace("before execute Halstead procedure");
            monitor.subTask(Messages.getString(HalsteadValue.class, "executingProcedure.subtaskName"));
            halResults = null;
            EZSourceConnection bridge = null;
            try {
                try {
                    bridge = conn != null ? conn : EZSourceConnectionManager.getCurrent();
                    Utils.createTempTable(bridge, stmtTempTable, EZSourceDataType.Integer);
                    Utils.insertValues(bridge, stmtTempTable, EZSourceDataType.Integer, operatorsSelList);
                    L.trace("operators: {}", operatorsSelList);
                    List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[paramHalst.size()]);
                    Collections.fill(types, EZSourceDataType.Integer);
                    halResults = bridge.execNonTransactionalStoredProc(procName, new String[0], types, paramHalst);
                }
                catch (EZSourceConnectionException e) {
                    L.error("exception at executing stored procedure", (Throwable)e);
                    this.messages.add(new LogMessage(Messages.getString(HalsteadValue.class, "storedProcedureError.logMessage"), 4, "com.ez.mainframe.data", (Throwable)e));
                    if (bridge != null) {
                        Utils.cleanTable(bridge, stmtTempTable);
                        Utils.dropTempTable(bridge, stmtTempTable);
                        L.debug("after cleaning temporary table");
                        if (conn == null && bridge != null) {
                            EZSourceConnectionManager.release((EZSourceConnection)bridge);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (bridge != null) {
                    Utils.cleanTable(bridge, stmtTempTable);
                    Utils.dropTempTable(bridge, stmtTempTable);
                    L.debug("after cleaning temporary table");
                    if (conn == null && bridge != null) {
                        EZSourceConnectionManager.release((EZSourceConnection)bridge);
                    }
                }
                throw throwable;
            }
            if (bridge != null) {
                Utils.cleanTable(bridge, stmtTempTable);
                Utils.dropTempTable(bridge, stmtTempTable);
                L.debug("after cleaning temporary table");
                if (conn == null && bridge != null) {
                    EZSourceConnectionManager.release((EZSourceConnection)bridge);
                }
            }
        }
        operatorsSelList.clear();
        paramHalst.clear();
        monitor.worked(30);
        L.trace("after execute Halstead procedure");
        monitor.subTask(Messages.getString(HalsteadValue.class, "preparingData.subtaskName"));
        Map<String, String[]> newRes = this.prepareData(temp, halResults);
        return (String[][])newRes.values().toArray((T[])new String[0][]);
    }

    private Map<String, String[]> prepareData(Map<String, String> temp, String[][] halResults) {
        HashMap<String, String[]> newRes = new HashMap<String, String[]>();
        if (halResults == null) {
            L.warn("no results for HALSTEAD report");
        } else {
            L.debug("HALSTEAD results number: {}", (Object)halResults.length);
            int i = 0;
            while (i < halResults.length) {
                String prgId = halResults[i][0];
                String N1 = halResults[i][1];
                String n1 = halResults[i][2];
                String N2 = halResults[i][3];
                String n2 = halResults[i][4];
                halResults[i][5] = null;
                L.trace("program id: {}", (Object)prgId);
                L.trace("N2: {}", (Object)N2);
                L.trace("n2: {}", (Object)n2);
                L.trace("N1: {}", (Object)N1);
                L.trace("n1: {}", (Object)n1);
                L.trace("\n");
                String parentID = temp.get(prgId);
                if (parentID == null) {
                    newRes.put(prgId, halResults[i]);
                } else {
                    String[] prevRes = (String[])newRes.get(parentID);
                    if (prevRes != null) {
                        prevRes[4] = String.valueOf(Integer.valueOf(prevRes[4]) + Integer.valueOf(n2));
                        prevRes[3] = String.valueOf(Integer.valueOf(prevRes[3]) + Integer.valueOf(N2));
                        prevRes[1] = String.valueOf(Integer.valueOf(prevRes[1]) + Integer.valueOf(N1));
                        prevRes[2] = String.valueOf(Integer.valueOf(prevRes[2]) + Integer.valueOf(n1));
                    } else {
                        String[] save = new String[9];
                        save[0] = parentID;
                        save[1] = N1.toString();
                        save[2] = n1.toString();
                        save[3] = N2.toString();
                        save[4] = n2.toString();
                        newRes.put(parentID, save);
                    }
                }
                ++i;
            }
        }
        return newRes;
    }

    private List<Integer> prepareStatements(Map params, ProjectInfo pInfo) {
        ArrayList<Integer> operatorsSelList = new ArrayList<Integer>();
        List availableGroups = Utils.readAvailableStmtGroups(4, pInfo);
        Iterator availableGroupsIterator = availableGroups.iterator();
        L.debug("before get the operators names");
        String operatorNames = "";
        while (availableGroupsIterator.hasNext()) {
            StmtGroup gr = (StmtGroup)availableGroupsIterator.next();
            Set types = gr.getTypes();
            if (types == null || types.isEmpty()) continue;
            for (StmtType stmtType : types) {
                String name = stmtType.getListableName();
                String value = this.getStateValue(stmtType);
                if (!value.equalsIgnoreCase(DEFAULT_STATE)) continue;
                operatorsSelList.add(stmtType.getId());
                if (!operatorNames.equalsIgnoreCase("")) {
                    operatorNames = String.valueOf(operatorNames) + ", ";
                }
                operatorNames = String.valueOf(operatorNames) + name;
            }
        }
        if (params != null) {
            params.put("inputOperators", operatorNames);
        }
        availableGroupsIterator = null;
        availableGroups.clear();
        availableGroups = null;
        return operatorsSelList;
    }

    private String getStateValue(StmtType type) {
        String propValue;
        if (this.defaultProp == null) {
            this.defaultProp = this.readDefaultProperties();
        }
        String string = propValue = this.reportProp.get(type.getId().toString()) != null ? (String)this.reportProp.get(type.getId().toString()) : this.defaultProp.getProperty(type.getId().toString());
        if (propValue == null) {
            propValue = DEFAULT_STATE;
        }
        return propValue;
    }

    private Properties readDefaultProperties() {
        String prjPath = Utils.getProjectPathName(this.projectName);
        String path = prjPath.concat(File.separator).concat(AnalysisType.EZSOURCE_EZREPORT_HALSTEAD_ANALYSIS.toString()).concat(com.ez.internal.utils.Utils.SYSTEM_FILE_SEPARATOR_PROPERTY).concat("default.properties");
        File defaultFile = new File(path);
        Properties defProp = Utils.readSettings(defaultFile);
        return defProp;
    }

    public void setReportProperties(Map properties) {
        this.reportProp = properties;
    }

    public Queue<LogMessage> getMessages() {
        return this.messages;
    }
}

