/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.utils.mapDB;

import com.ez.workspace.preferences.Utils;
import java.io.File;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistentCollection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PersistentCollection.class);
    private File DB_FOLDER;
    private static int count = 0;
    protected File file;
    protected static final int CACHE_SIZE_DEFAULT = -1;
    protected int cacheSize = -1;
    protected DB db = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentCollection(Class clazz, int cacheSize, File tempFolder) {
        this.DB_FOLDER = tempFolder == null ? new File(String.valueOf(Utils.getTemporaryFolder()) + File.separator + "mapdb" + File.separator) : tempFolder;
        if (!this.DB_FOLDER.exists()) {
            this.DB_FOLDER.mkdirs();
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            this.file = new File(this.DB_FOLDER, "db" + count);
            while (this.file.exists()) {
                this.file = new File(this.DB_FOLDER, "db" + ++count);
            }
            ++count;
        }
        DBMaker.Maker dbMaker = DBMaker.fileDB((File)this.file);
        dbMaker.deleteFilesAfterClose();
        if (cacheSize != -1) {
            dbMaker.allocateStartSize((long)cacheSize);
            this.cacheSize = cacheSize;
        }
        this.db = dbMaker.make();
    }

    public PersistentCollection(Class clazz, int cacheSize) {
        this(clazz, cacheSize, null);
    }

    PersistentCollection(int cacheSize, File tempFolder) {
        this(PersistentCollection.class, cacheSize, tempFolder);
    }

    public void clear() {
        if (this.db != null && !this.db.isClosed()) {
            this.close();
        }
        this.deleteFile();
    }

    public void close() {
        try {
            this.db.close();
        }
        catch (Exception ex) {
            L.error("error at closing mapdb; it will be ignored", (Throwable)ex);
            this.deleteFile();
        }
    }

    public boolean isClosed() {
        boolean vb = this.db == null || this.db.isClosed();
        L.trace("isClosed={}", (Object)vb);
        return vb;
    }

    protected void deleteFile() {
        if (this.file != null && this.file.exists()) {
            try {
                boolean del = this.file.delete();
                L.debug("file{} deleted={}", (Object)this.file, (Object)del);
            }
            catch (Exception ex) {
                L.warn("error trying to delete mapdb file", (Throwable)ex);
            }
        }
    }
}

