/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.utils;

import com.ez.common.model.BaseResourceInput;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceLockException;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.PathUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.gui.internal.MainframeGUIErrorLog;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.selection.Manager;
import com.ez.report.application.utils.ProjectApplicationInput;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedResourcesUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SharedResourcesUtils.class);
    public static final String AVAILABLE_PROJECTS_KEY = "available projects";
    public static final String SELECTED_PROJECTS_KEY = "selected projects";
    public static final String NOT_ACCESSIBLE_PROJECTS_KEY = "not accessible projects";
    public static final String AVAILABLE_APPLICATIONS_FOR_SHARED_RES = "available applications for shared resources";
    public static final String SELECTED_APPLICATIONS_FOR_SHARED_RES = "selected applications for shared resources";
    public static final String NOT_ACCESSIBLE_APPLICATIONS_FOR_SHARED_RES = "not accessible applications for shared resources";
    public static final String INPUT_PROJECT_NAMES_SET = "input project names set";
    public static final String UCMDB_NAME_IDENTIFIER = "_UCMDB";
    private static final String HSQL_GET_RES_BY_NAME_AND_TYPE_QUERY = "select id from resources where name=? and type=?";
    private static final String HSQL_CREATE_CROSS_STRING = " CREATE TABLE prj_res ( \tid INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) PRIMARY KEY, \tid_resource INTEGER NOT NULL,  id_project INTEGER NOT NULL,  res_info varchar (200),  foreign key (id_resource) references resources(id) ON DELETE CASCADE,  foreign key (id_project) references projects(id) ON DELETE CASCADE );";
    private static final String HSQL_CREATE_RESOURCES_STRING = " CREATE TABLE resources ( \tid INTEGER NOT NULL PRIMARY KEY, \tname varchar (300) NOT NULL,  type INTEGER NOT NULL );";
    private static final String HSQL_CREATE_PROJECTS_STRING = " CREATE TABLE projects ( \tid INTEGER NOT NULL PRIMARY KEY, \tname varchar (200) NOT NULL );";
    private static final String HSQL_RESULT_SUMMARY_QUERY = "SELECT DISTINCT \n\tA.type, \n\tCOUNT(A.id) AS rescount \nFROM resources A \nWHERE A.id IN ( \n\tSELECT DISTINCT \n\t\tB.id_resource \n\tFROM prj_res B \n\t\tINNER JOIN resources C ON B.id_resource = C.id \n\tGROUP BY B.id_resource \n\tHAVING count(B.id) > 1 \n) \nGROUP BY A.type ";
    private static final String HSQL_INSERT_INTO_PROJECTS = "insert into projects values (?, ?) ";
    private static final String HSQL_INSERT_INTO_RESOURCES = "insert into resources values (?, ?, ?) ";
    private static final String HSQL_INSERT_INTO_PRJ_RES = "insert into prj_res values (null, ?, ?, ?) ";
    private static final String HSQL_SHARED_RES_BY_TYPE_QUERY = "SELECT \n\tA.name, \n\tB.res_info, \n\tC.name AS project_name \nFROM resources A \n\tINNER JOIN prj_res B ON A.id = B.id_resource \n\tINNER JOIN projects C ON B.id_project = C.id \nWHERE A.id IN ( \n\tSELECT \n\t\tA.id \n\tFROM resources A \n\t\tINNER JOIN prj_res B ON A.id = B.id_resource \n\tWHERE A.type = ? \n\tGROUP BY A.id \n\tHAVING (COUNT(B.id_project) > 1) \n) \nORDER BY A.name, project_name ";
    public static final String EZS_SEPARATOR = "##EZSRC##";
    public static final String FAKE_INFO = "FAKE";
    public static final int DUMMY_RESOURCE_TYPE_INCLUDE = -101;
    public static final int DUMMY_RESOURCE_TYPE_IDMSX_SUBSCHEMA_RECORD = -177;
    public static final int DUMMY_RESOURCE_TYPE_IDMSX_SUBSCHEMA_SET = -178;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$ez$report$application$utils$SharedResourcesUtils$Procedure;

    public static String getResTypeNameByResTypeId(Integer resTypeId) {
        String ret = "";
        if (resTypeId != null) {
            switch (resTypeId) {
                case 1: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.RDBMSTable");
                    break;
                }
                case 5: {
                    ret = Messages.getString(SharedResourcesUtils.class, "resourceName.program");
                    break;
                }
                case 9: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.File");
                    break;
                }
                case 13: {
                    ret = Messages.getString(SharedResourcesUtils.class, "resourceName.cobol.include");
                    break;
                }
                case 18: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.Database");
                    break;
                }
                case 30: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.JCL");
                    break;
                }
                case 56: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.AdabasFile");
                    break;
                }
                case 60: {
                    ret = Messages.getString(SharedResourcesUtils.class, "resourceName.natural.include");
                    break;
                }
                case 64: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.AIMFile");
                    break;
                }
                case 67: {
                    ret = Messages.getString(SharedResourcesUtils.class, "resourceName.pl1.include");
                    break;
                }
                case 70: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.AS400Printerfile");
                    break;
                }
                case 71: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.AS400DBFile");
                    break;
                }
                case 72: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.AS400CLFile");
                    break;
                }
                case 77: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.IDMSRecord");
                    break;
                }
                case -177: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.IDMSXRecord");
                    break;
                }
                case 78: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.IDMSSet");
                    break;
                }
                case -178: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.IDMSXSet");
                    break;
                }
                case 81: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.Queue");
                    break;
                }
                case 99: {
                    ret = Messages.getString(SharedResourcesUtils.class, "resourceName.assembler.include");
                    break;
                }
                case 182: {
                    ret = Messages.getString(SharedResourcesUtils.class, "fileName.DatacomTable");
                }
            }
        }
        if (ret.isEmpty()) {
            L.warn("Unhandled resource type id: {} when mapping type id to type name for shared resources analysis!", (Object)resTypeId);
        }
        return ret;
    }

    public static Pair<Map<Integer, Integer>, Set<String>> getDBData(IProgressMonitor pmonitor, List<EZSourceProjectInputType> selectedProjects, List<ProjectApplicationInput> selectedApplications, Collection<BaseResourceInput> selectedInputTypes, String dbName) {
        Boolean useApplications = Boolean.FALSE;
        HashMap<Integer, Integer> summaryCounts = new HashMap<Integer, Integer>();
        pmonitor.subTask(Messages.getString(SharedResourcesUtils.class, "preparingdata.progress.label"));
        Connection hsqlConn = SharedResourcesUtils.startHsqlDBServer(dbName);
        HashSet<String> notAccessible = null;
        if (hsqlConn != null) {
            boolean isAccessible;
            Triplet<Boolean, Integer, Integer> triplet;
            notAccessible = new HashSet<String>();
            Integer hsqlPrjIdCounter = 1;
            Integer hsqlResIdCounter = 1;
            if (useApplications.booleanValue()) {
                for (ProjectApplicationInput selectedApp : selectedApplications) {
                    if (pmonitor.isCanceled()) continue;
                    triplet = SharedResourcesUtils.prepareProjectData(hsqlConn, selectedApp.getProjectName(), hsqlPrjIdCounter, hsqlResIdCounter, selectedInputTypes, pmonitor, selectedApp);
                    isAccessible = (Boolean)triplet.getFirst();
                    hsqlPrjIdCounter = (Integer)triplet.getSecond();
                    hsqlResIdCounter = (Integer)triplet.getThird();
                    if (isAccessible) continue;
                    notAccessible.add(selectedApp.getDisplayName());
                }
            } else {
                for (EZSourceProjectInputType inputProject : selectedProjects) {
                    if (pmonitor.isCanceled()) continue;
                    triplet = SharedResourcesUtils.prepareProjectData(hsqlConn, inputProject.getName(), hsqlPrjIdCounter, hsqlResIdCounter, selectedInputTypes, pmonitor, null);
                    isAccessible = (Boolean)triplet.getFirst();
                    hsqlPrjIdCounter = (Integer)triplet.getSecond();
                    hsqlResIdCounter = (Integer)triplet.getThird();
                    if (isAccessible) continue;
                    notAccessible.add(inputProject.getName());
                }
            }
            if (!pmonitor.isCanceled()) {
                if (useApplications.booleanValue()) {
                    pmonitor.subTask(Messages.getString(SharedResourcesUtils.class, "applications.combineData.progress.label"));
                } else {
                    pmonitor.subTask(Messages.getString(SharedResourcesUtils.class, "projects.combineData.progress.label"));
                }
                boolean enoughAccessibleInputs = true;
                String errMessageInfo = null;
                if (useApplications.booleanValue()) {
                    if (selectedApplications.size() - notAccessible.size() < 2) {
                        enoughAccessibleInputs = false;
                        errMessageInfo = Messages.getString(SharedResourcesUtils.class, "applicationsNotAvailable.errorView.message");
                    }
                } else if (selectedProjects.size() - notAccessible.size() < 2) {
                    enoughAccessibleInputs = false;
                    errMessageInfo = Messages.getString(SharedResourcesUtils.class, "projectsNotAvailable.errorView.message");
                }
                if (enoughAccessibleInputs) {
                    try {
                        ResultSet rs = hsqlConn.createStatement().executeQuery(HSQL_RESULT_SUMMARY_QUERY);
                        while (rs.next()) {
                            Integer resTypeId = rs.getInt(1);
                            Integer count = rs.getInt(2);
                            L.debug("resType={} ::: count={}", (Object)resTypeId, (Object)count);
                            summaryCounts.put(resTypeId, count);
                        }
                    }
                    catch (SQLException e1) {
                        L.error("error at getting data from HSQL", (Throwable)e1);
                        MainframeGUIErrorLog.err(Messages.getString(SharedResourcesUtils.class, "getData.hsqlException.errorView.message"), e1);
                    }
                    try {
                        hsqlConn.close();
                    }
                    catch (SQLException e) {
                        L.error("Error at closing HSQL connection", (Throwable)e);
                    }
                    if (summaryCounts.size() == 0) {
                        L.warn("No results - no shared resources found.");
                        SharedResourcesUtils.closeHSqlServer(dbName);
                    }
                } else {
                    L.warn("Cannot access data for at least 2 projects/applications from the ones selected! No data to compare.");
                    MainframeGUIErrorLog.warn(errMessageInfo, null);
                    SharedResourcesUtils.closeHSqlServer(dbName);
                }
            } else {
                SharedResourcesUtils.closeHSqlServer(dbName);
            }
        } else {
            L.error("Failed to connnect to HSQL! Connection is null.");
            MainframeGUIErrorLog.err(Messages.getString(SharedResourcesUtils.class, "noHsql.errorView.message"), null);
        }
        return new Pair(summaryCounts, notAccessible);
    }

    /*
     * Unable to fully structure code
     */
    private static Triplet<Boolean, Integer, Integer> prepareProjectData(Connection hsqlConn, String projectName, Integer hsqlPrjIdCounter, Integer hsqlResIdCounter, Collection<BaseResourceInput> selectedInputTypes, IProgressMonitor pmonitor, ProjectApplicationInput selectedApp) {
        block82: {
            block85: {
                useApplications = Boolean.FALSE;
                prjOrAppName = useApplications != false ? selectedApp.getDisplayName() : projectName;
                msgParam = new String[]{prjOrAppName};
                isAccessible = true;
                hsqlSavepoint = null;
                SharedResourcesUtils.L.debug("Accessing project or application {}", (Object)prjOrAppName);
                if (useApplications.booleanValue()) {
                    pmonitor.subTask(Messages.getString(SharedResourcesUtils.class, "accessApplication.progress.label", msgParam));
                } else {
                    pmonitor.subTask(Messages.getString(SharedResourcesUtils.class, "accessProject.progress.label", msgParam));
                }
                if (useApplications.booleanValue()) {
                    pmonitor.subTask(Messages.getString(SharedResourcesUtils.class, "getData4Application.progress.label", msgParam));
                } else {
                    pmonitor.subTask(Messages.getString(SharedResourcesUtils.class, "getData4Project.progress.label", msgParam));
                }
                try {
                    hsqlConn.setAutoCommit(false);
                    hsqlSavepoint = hsqlConn.setSavepoint(prjOrAppName);
                    pStProj = hsqlConn.prepareStatement("insert into projects values (?, ?) ");
                    pStProj.setInt(1, hsqlPrjIdCounter);
                    pStProj.setString(2, prjOrAppName);
                    pStProj.executeUpdate();
                    service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                    ph = service.getProjectHandler(projectName, null);
                    for (BaseResourceInput selectedType : selectedInputTypes) {
                        block86: {
                            proc = Procedure.getProcByResTypeId(selectedType.getTypeCode());
                            procName = proc.getProcName();
                            params = null;
                            if (useApplications.booleanValue() && selectedApp.isFromMultiApp()) {
                                procName = proc.getProcNameUCMDB();
                                params = new String[]{selectedApp.getApplicationName()};
                            }
                            SharedResourcesUtils.L.debug("before executing stored procedure: {} for project or application {}", (Object)procName, (Object)prjOrAppName);
                            res = new String[1][][];
                            procToExec = procName;
                            params4ProcToExec = params;
                            ph.executeWithLock(ph, new IMFRunnable(){

                                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                                    res[0] = conn.execNonTransactionalStoredProc(procToExec, params4ProcToExec);
                                }
                            }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
                            if (res[0] == null) break block86;
                            SharedResourcesUtils.L.debug("result for procedure {} for project or application {}", (Object)procName, (Object)prjOrAppName);
                            results = res[0];
                            prevName = null;
                            resTypeId = selectedType.getTypeCode();
                            var29_32 = results;
                            var28_31 = results.length;
                            var27_30 = 0;
                            while (var27_30 < var28_31) {
                                row = var29_32[var27_30];
                                hsqlUniqueResName = row[0];
                                ancestorCsect = null;
                                ancestorHsqlResId = 0;
                                switch (SharedResourcesUtils.$SWITCH_TABLE$com$ez$report$application$utils$SharedResourcesUtils$Procedure()[proc.ordinal()]) {
                                    case 4: {
                                        hsqlUniqueResName = String.valueOf(row[0]) + "##EZSRC##" + row[3];
                                        ** GOTO lbl75
                                    }
                                    case 6: {
                                        hsqlUniqueResName = String.valueOf(row[0]) + "##EZSRC##" + row[1];
                                        if (hsqlUniqueResName.equalsIgnoreCase(prevName)) {
                                            SharedResourcesUtils.L.info("duplicate names in SharedAdabas files: {}", (Object)hsqlUniqueResName);
                                            break;
                                        }
                                        prevName = hsqlUniqueResName;
                                        ** GOTO lbl75
                                    }
                                    case 11: 
                                    case 12: 
                                    case 13: 
                                    case 14: {
                                        hsqlUniqueResName = String.valueOf(row[0]) + " (" + row[1] + ")";
                                        ** GOTO lbl75
                                    }
                                    case 17: {
                                        hsqlUniqueResName = String.valueOf(row[0]) + "##EZSRC##" + row[2];
                                        resTypeId = Integer.valueOf(row[2]);
                                        ** GOTO lbl75
                                    }
                                    case 2: {
                                        programTypeId = Integer.valueOf(row[2]);
                                        if (ProgramType.ASSEMBLER_CSECT.getProgramTypeId() == programTypeId.intValue() || ProgramType.ASSEMBLER_ENTRY.getProgramTypeId() == programTypeId.intValue()) {
                                            if (ProgramType.ASSEMBLER_CSECT.getProgramTypeId() == programTypeId.intValue()) {
                                                ancestorCsect = row[4];
                                            }
                                            hsqlUniqueResName = String.valueOf(row[4]) + ":" + row[0];
                                        }
                                    }
lbl75:
                                    // 8 sources

                                    default: {
                                        hsqlResId = hsqlResIdCounter;
                                        if (hsqlPrjIdCounter != 1) {
                                            hsqlResId = SharedResourcesUtils.searchResIfExists(hsqlConn, resTypeId, hsqlUniqueResName, hsqlResId);
                                        }
                                        if (hsqlResId == hsqlResIdCounter) {
                                            hsqlResIdCounter = SharedResourcesUtils.insertResource(hsqlConn, hsqlResIdCounter, resTypeId, hsqlUniqueResName, hsqlResId);
                                        }
                                        if (ancestorCsect != null) {
                                            ancestorHsqlResId = hsqlResIdCounter;
                                            if (hsqlPrjIdCounter != 1) {
                                                ancestorHsqlResId = SharedResourcesUtils.searchResIfExists(hsqlConn, resTypeId, ancestorCsect, ancestorHsqlResId);
                                            }
                                            if (ancestorHsqlResId == hsqlResIdCounter) {
                                                hsqlResIdCounter = SharedResourcesUtils.insertResource(hsqlConn, hsqlResIdCounter, resTypeId, ancestorCsect, ancestorHsqlResId);
                                            }
                                        }
                                        pStCross = hsqlConn.prepareStatement("insert into prj_res values (null, ?, ?, ?) ");
                                        pStCross2 = null;
                                        pStCross.setInt(1, hsqlResId);
                                        pStCross.setInt(2, hsqlPrjIdCounter);
                                        resInfo = null;
                                        switch (SharedResourcesUtils.$SWITCH_TABLE$com$ez$report$application$utils$SharedResourcesUtils$Procedure()[proc.ordinal()]) {
                                            case 4: {
                                                resInfo = String.valueOf(row[1]) + "##EZSRC##" + row[2];
                                                break;
                                            }
                                            case 5: {
                                                resInfo = row[1];
                                                break;
                                            }
                                            case 6: {
                                                resInfo = row[2];
                                                break;
                                            }
                                            case 17: {
                                                resInfo = String.valueOf(row[1]) + "##EZSRC##" + row[3] + "##EZSRC##" + row[4];
                                                break;
                                            }
                                            case 2: {
                                                resInfo = String.valueOf(row[1]) + "##EZSRC##" + row[2] + "##EZSRC##" + row[3] + "##EZSRC##" + row[4] + "##EZSRC##" + row[6];
                                                break;
                                            }
                                        }
                                        SharedResourcesUtils.L.debug("collected resource: hsqlUniqueResName = {}, resType = {} - {}, hsqlResId = {}, res_info = {}, prjName = {}, hsqlPrjId = {}", new Object[]{hsqlUniqueResName, resTypeId, SharedResourcesUtils.getResTypeNameByResTypeId(resTypeId), hsqlResId, resInfo, projectName, hsqlPrjIdCounter});
                                        if (resInfo != null) {
                                            pStCross.setString(3, resInfo);
                                            if (ancestorCsect != null) {
                                                pStCross2 = hsqlConn.prepareStatement("insert into prj_res values (null, ?, ?, ?) ");
                                                pStCross2.setInt(1, ancestorHsqlResId);
                                                pStCross2.setInt(2, hsqlPrjIdCounter);
                                                resInfo2 = String.valueOf(resInfo) + "##EZSRC##" + "FAKE";
                                                pStCross2.setString(3, resInfo2);
                                            }
                                        } else {
                                            pStCross.setNull(3, 0);
                                        }
                                        pStCross.executeUpdate();
                                        if (pStCross2 == null) break;
                                        pStCross2.executeUpdate();
                                        pStCross2 = null;
                                    }
                                }
                                ++var27_30;
                            }
                            res[0] = null;
                            continue;
                        }
                        SharedResourcesUtils.L.debug("no results for procedure: {} for project or application {}", (Object)procName, (Object)prjOrAppName);
                    }
                }
                catch (SQLException e) {
                    block81: {
                        isAccessible = false;
                        SharedResourcesUtils.L.error("SQLException when saving data for {}", (Object)prjOrAppName, (Object)e);
                        if (useApplications.booleanValue()) {
                            MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "appNotAccessible.hsqlException.errorView.message", msgParam), e);
                        } else {
                            MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "prjNotAccessible.hsqlException.errorView.message", msgParam), e);
                        }
                        if (isAccessible) {
                            try {
                                hsqlConn.commit();
                            }
                            catch (SQLException e) {
                                isAccessible = false;
                                SharedResourcesUtils.L.error("SQLException when saving data for {}", (Object)prjOrAppName, (Object)e);
                                if (useApplications.booleanValue()) {
                                    MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "appNotAccessible.hsqlException.errorView.message", msgParam), e);
                                    break block81;
                                }
                                MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "prjNotAccessible.hsqlException.errorView.message", msgParam), e);
                            }
                        }
                    }
                    if (!isAccessible && hsqlSavepoint != null) {
                        try {
                            hsqlConn.rollback(hsqlSavepoint);
                        }
                        catch (SQLException e) {
                            SharedResourcesUtils.L.error("SQLException when rolling back hsql for {}", (Object)prjOrAppName, (Object)e);
                            MainframeGUIErrorLog.err(Messages.getString(SharedResourcesUtils.class, "rollback.hsqlException.errorView.message", msgParam), e);
                        }
                    }
                    break block82;
                }
                catch (InterruptedException e) {
                    isAccessible = false;
                    SharedResourcesUtils.L.error("", (Throwable)e);
                    break block82;
                }
                catch (ExecutionException e) {
                    block83: {
                        isAccessible = false;
                        if (e.getCause() instanceof EZSourceLockException) {
                            if (useApplications.booleanValue()) {
                                SharedResourcesUtils.L.debug("project for application {} is locked. Cannot collect data for it. It will be skipped in the result.", (Object)selectedApp.getDisplayName());
                                MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "appNotAccessible.lockProject.errorView.message", msgParam), null);
                            } else {
                                SharedResourcesUtils.L.debug("project {} is locked. Cannot collect data for it. It will be skipped in the result.", (Object)projectName);
                                MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "prjNotAccessible.lockProject.errorView.message", msgParam), null);
                            }
                        } else if (e.getCause() instanceof EZSourceConnectionException) {
                            SharedResourcesUtils.L.error("ADBuildConnectionException when processing {}", (Object)prjOrAppName, (Object)e);
                            if (useApplications.booleanValue()) {
                                MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "appNotAccessible.connectionException.errorView.message", msgParam), e);
                            } else {
                                MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "prjNotAccessible.connectionException.errorView.message", msgParam), e);
                            }
                        } else {
                            SharedResourcesUtils.L.error("", (Throwable)e);
                        }
                        if (!isAccessible) break block83;
                        {
                            catch (Throwable var38_52) {
                                throw var38_52;
                            }
                        }
                        try {
                            hsqlConn.commit();
                        }
                        catch (SQLException e) {
                            isAccessible = false;
                            SharedResourcesUtils.L.error("SQLException when saving data for {}", (Object)prjOrAppName, (Object)e);
                            if (useApplications.booleanValue()) {
                                MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "appNotAccessible.hsqlException.errorView.message", msgParam), e);
                                break block83;
                            }
                            MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "prjNotAccessible.hsqlException.errorView.message", msgParam), e);
                        }
                    }
                    if (!isAccessible && hsqlSavepoint != null) {
                        try {
                            hsqlConn.rollback(hsqlSavepoint);
                        }
                        catch (SQLException e) {
                            SharedResourcesUtils.L.error("SQLException when rolling back hsql for {}", (Object)prjOrAppName, (Object)e);
                            MainframeGUIErrorLog.err(Messages.getString(SharedResourcesUtils.class, "rollback.hsqlException.errorView.message", msgParam), e);
                        }
                    }
                    break block82;
                }
                {
                    finally {
                        block84: {
                            if (isAccessible) {
                                try {
                                    hsqlConn.commit();
                                }
                                catch (SQLException e) {
                                    isAccessible = false;
                                    SharedResourcesUtils.L.error("SQLException when saving data for {}", (Object)prjOrAppName, (Object)e);
                                    if (useApplications.booleanValue()) {
                                        MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "appNotAccessible.hsqlException.errorView.message", msgParam), e);
                                        break block84;
                                    }
                                    MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "prjNotAccessible.hsqlException.errorView.message", msgParam), e);
                                }
                            }
                        }
                        if (!isAccessible && hsqlSavepoint != null) {
                            try {
                                hsqlConn.rollback(hsqlSavepoint);
                            }
                            catch (SQLException e) {
                                SharedResourcesUtils.L.error("SQLException when rolling back hsql for {}", (Object)prjOrAppName, (Object)e);
                                MainframeGUIErrorLog.err(Messages.getString(SharedResourcesUtils.class, "rollback.hsqlException.errorView.message", msgParam), e);
                            }
                        }
                    }
                }
                if (!isAccessible) break block85;
                try {
                    hsqlConn.commit();
                }
                catch (SQLException e) {
                    isAccessible = false;
                    SharedResourcesUtils.L.error("SQLException when saving data for {}", (Object)prjOrAppName, (Object)e);
                    if (useApplications.booleanValue()) {
                        MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "appNotAccessible.hsqlException.errorView.message", msgParam), e);
                    }
                    MainframeGUIErrorLog.warn(Messages.getString(SharedResourcesUtils.class, "prjNotAccessible.hsqlException.errorView.message", msgParam), e);
                }
            }
            if (!isAccessible && hsqlSavepoint != null) {
                try {
                    hsqlConn.rollback(hsqlSavepoint);
                }
                catch (SQLException e) {
                    SharedResourcesUtils.L.error("SQLException when rolling back hsql for {}", (Object)prjOrAppName, (Object)e);
                    MainframeGUIErrorLog.err(Messages.getString(SharedResourcesUtils.class, "rollback.hsqlException.errorView.message", msgParam), e);
                }
            }
        }
        hsqlPrjIdCounter = hsqlPrjIdCounter + 1;
        return new Triplet((Object)isAccessible, (Object)hsqlPrjIdCounter, (Object)hsqlResIdCounter);
    }

    private static Integer insertResource(Connection hsqlConn, Integer hsqlResIdCounter, Integer resTypeId, String hsqlUniqueResName, int hsqlResId) throws SQLException {
        PreparedStatement pStRes = hsqlConn.prepareStatement(HSQL_INSERT_INTO_RESOURCES);
        pStRes.setInt(1, hsqlResId);
        pStRes.setString(2, hsqlUniqueResName);
        pStRes.setInt(3, resTypeId);
        pStRes.executeUpdate();
        hsqlResIdCounter = hsqlResIdCounter + 1;
        return hsqlResIdCounter;
    }

    private static int searchResIfExists(Connection hsqlConn, Integer resTypeId, String hsqlUniqueResName, int hsqlResId) throws SQLException {
        PreparedStatement pStRes = hsqlConn.prepareStatement(HSQL_GET_RES_BY_NAME_AND_TYPE_QUERY);
        pStRes.setString(1, hsqlUniqueResName);
        pStRes.setInt(2, resTypeId);
        ResultSet rs = pStRes.executeQuery();
        if (rs.next()) {
            hsqlResId = rs.getInt(1);
        }
        return hsqlResId;
    }

    private static Connection startHsqlDBServer(String dbName) {
        Connection hsqlConn = null;
        try {
            hsqlConn = SharedResourcesUtils.getHQSLConn(dbName);
            if (hsqlConn != null) {
                L.debug("hsql conn obtained");
                hsqlConn.createStatement().execute(HSQL_CREATE_PROJECTS_STRING);
                hsqlConn.createStatement().execute(HSQL_CREATE_RESOURCES_STRING);
                hsqlConn.createStatement().execute(HSQL_CREATE_CROSS_STRING);
                hsqlConn.commit();
            }
        }
        catch (Throwable e2) {
            L.error("error at creating HQL tables", e2);
            SharedResourcesUtils.closeHSqlServer(dbName);
            hsqlConn = null;
        }
        return hsqlConn;
    }

    public static Connection getHQSLConn(String dbName) throws Throwable {
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
        }
        catch (Throwable th) {
            L.info("getHQSLConn()", th);
            Class.forName("org.hsqldb.jdbcDriver");
        }
        Connection hsqlConn = DriverManager.getConnection("jdbc:hsqldb:file:" + SharedResourcesUtils.getHsqlPath(dbName), "sa", "");
        return hsqlConn;
    }

    private static String getHsqlPath(String dbName) {
        String path = String.valueOf(PathUtils.METADATA_FOLDER.getAbsolutePath()) + File.separator + "hsql" + File.separator + dbName;
        File hsqlFolder = new File(path);
        if (!hsqlFolder.getParentFile().exists()) {
            hsqlFolder.getParentFile().mkdir();
        }
        while (hsqlFolder.exists()) {
            L.info("report is reloaded and database was kept from the first run; generate another name for HSQL db");
            path = String.valueOf(PathUtils.METADATA_FOLDER.getAbsolutePath()) + File.separator + "hsql" + File.separator + dbName;
            hsqlFolder = new File(path);
        }
        return path;
    }

    public static void closeHSqlServer(final String dbName) {
        try {
            Connection conn = SharedResourcesUtils.getHQSLConn(dbName);
            if (conn != null) {
                int idx;
                File f;
                String[] files;
                String path;
                conn.createStatement().execute("SHUTDOWN");
                L.trace("after shutdown");
                String s = System.getProperty("hsql.server.noDelete");
                if (s == null && (path = SharedResourcesUtils.getHsqlPath(dbName)) != null && (files = (f = new File(path = (idx = path.indexOf(dbName)) > 0 ? path.substring(0, idx - 1) : path)).list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        boolean ret = name.startsWith(String.valueOf(dbName) + ".") || name.equals(dbName) && dir.isDirectory();
                        return ret;
                    }
                })) != null) {
                    int i = 0;
                    while (i < files.length) {
                        String fName = files[i];
                        File ff = new File(String.valueOf(path) + File.separator + fName);
                        boolean del = ff.delete();
                        if (!del) {
                            L.info("file {} cannot be deleted", (Object)ff.getName());
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Throwable e) {
            L.error("error at shutdown", e);
        }
    }

    public static String generateName(String strDate, String title) {
        StringBuffer resultStringBuffer = new StringBuffer();
        resultStringBuffer.append(title);
        resultStringBuffer.append("_");
        resultStringBuffer.append(strDate);
        return resultStringBuffer.toString();
    }

    public static String getGenDate() {
        String strTime = String.valueOf(Calendar.getInstance().getTimeInMillis());
        long time = Long.valueOf(strTime);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        String strDate = String.valueOf(c.get(1)).concat("_").concat(String.valueOf(c.get(2) + 1)).concat("_").concat(String.valueOf(c.get(5))).concat("_").concat(String.valueOf(c.get(11))).concat("_").concat(String.valueOf(c.get(12))).concat("_").concat(String.valueOf(c.get(13)));
        L.debug("date in name: {}", (Object)strDate);
        return strDate;
    }

    public static List<ProgramInputNoGUI> getSharedResByType(Integer resTypeId, String dbName) {
        ArrayList<ProgramInputNoGUI> sharedResources = new ArrayList<ProgramInputNoGUI>();
        Connection hsqlConn = null;
        L.debug("dbName: {}", (Object)dbName);
        try {
            hsqlConn = SharedResourcesUtils.getHQSLConn(dbName);
        }
        catch (Throwable throwable) {
            L.error("Failed to connnect to HSQL! Connection is null.");
            MainframeGUIErrorLog.err(Messages.getString(SharedResourcesUtils.class, "noHsql.errorView.message"), null);
            SharedResourcesUtils.closeHSqlServer(dbName);
        }
        if (hsqlConn != null) {
            try {
                PreparedStatement ps = hsqlConn.prepareStatement(HSQL_SHARED_RES_BY_TYPE_QUERY);
                ps.setInt(1, resTypeId);
                ResultSet rs = ps.executeQuery();
                String prevResName = null;
                HashSet<String> prjs = new HashSet<String>();
                HashSet<Pair> resInfoPerPrj = new HashSet<Pair>();
                while (rs.next()) {
                    String hsqlUniqueResName = rs.getString(1);
                    String resInfo = rs.getString(2);
                    String prjName = rs.getString(3);
                    L.debug("shared resource: resName = {}, resType = {} - {}, res_info = {}, prjName = {}", new Object[]{hsqlUniqueResName, resTypeId, SharedResourcesUtils.getResTypeNameByResTypeId(resTypeId), resInfo, prjName});
                    if (prevResName == null || !hsqlUniqueResName.equalsIgnoreCase(prevResName)) {
                        if (prevResName != null) {
                            prjs = new HashSet();
                            resInfoPerPrj = new HashSet();
                        }
                        prjs.add(prjName);
                        resInfoPerPrj.add(new Pair((Object)prjName, (Object)resInfo));
                        ProgramInputNoGUI resourceInput = new ProgramInputNoGUI(hsqlUniqueResName);
                        resourceInput.setApplicationsName(prjs);
                        resourceInput.setResDbIdInPrj(resInfoPerPrj);
                        resourceInput.setType(resTypeId);
                        sharedResources.add(resourceInput);
                        prevResName = hsqlUniqueResName;
                        continue;
                    }
                    prjs.add(prjName);
                    resInfoPerPrj.add(new Pair((Object)prjName, (Object)resInfo));
                }
                ps.close();
            }
            catch (SQLException e1) {
                L.error("error at getting data from HSQL", (Throwable)e1);
                MainframeGUIErrorLog.err(Messages.getString(SharedResourcesUtils.class, "getData.hsqlException.errorView.message"), e1);
            }
            try {
                hsqlConn.close();
            }
            catch (SQLException e) {
                L.error("error at closing HSQL connection", (Throwable)e);
            }
        }
        return sharedResources;
    }

    @Deprecated
    public static Boolean useApplications() {
        return Boolean.FALSE;
    }

    public static boolean allowDrawing(ProgramInputNoGUI resourceInput, Integer resTypeId) {
        boolean allow = true;
        if (5 == resTypeId) {
            allow = false;
            Set resInfoPerPrj = resourceInput.getResDbIdInPrj();
            for (Pair prjResInfoPair : resInfoPerPrj) {
                String resInfo = (String)prjResInfoPair.getSecond();
                String[] info = resInfo.split(EZS_SEPARATOR);
                if (info.length >= 6) continue;
                L.debug("found an entry that is not fake for {}", (Object)resourceInput.getListableName());
                allow = true;
            }
        }
        return allow;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$ez$report$application$utils$SharedResourcesUtils$Procedure() {
        if ($SWITCH_TABLE$com$ez$report$application$utils$SharedResourcesUtils$Procedure != null) {
            return $SWITCH_TABLE$com$ez$report$application$utils$SharedResourcesUtils$Procedure;
        }
        int[] nArray = new int[Procedure.values().length];
        try {
            nArray[Procedure.P_1.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_18.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_182.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_30.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_56.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_64.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_70.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_71.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_72.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_77.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_77777.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_78.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_788888.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_81.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_9.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_INCLUDE.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Procedure.P_PROGRAMS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$ez$report$application$utils$SharedResourcesUtils$Procedure = nArray;
        return nArray;
    }

    public static enum Procedure {
        P_1(1, "EZReports_SharedResources_RDBMS", Messages.getString(SharedResourcesUtils.class, "fileName.RDBMSTable")),
        P_PROGRAMS(5, "EZViewer_SharedResources_Programs", Messages.getString(SharedResourcesUtils.class, "resourceName.program")),
        P_9(9, "EZReports_SharedResources_File", Messages.getString(SharedResourcesUtils.class, "fileName.File")),
        P_18(18, "EZReports_SharedResources_Database", Messages.getString(SharedResourcesUtils.class, "fileName.Database")),
        P_30(30, "EZReports_SharedResources_JCLPhysicalDataset", Messages.getString(SharedResourcesUtils.class, "fileName.JCL")),
        P_56(56, "EZReports_SharedResources_AdabasFile", Messages.getString(SharedResourcesUtils.class, "fileName.AdabasFile")),
        P_64(64, "EZReports_SharedResources_AIMTable", Messages.getString(SharedResourcesUtils.class, "fileName.AIMFile")),
        P_70(70, "EZReports_SharedResources_AS400PrinterFile", Messages.getString(SharedResourcesUtils.class, "fileName.AS400Printerfile")),
        P_71(71, "EZReports_SharedResources_AS400DBFile", Messages.getString(SharedResourcesUtils.class, "fileName.AS400DBFile")),
        P_72(72, "EZReports_SharedResources_AS400CLFile", Messages.getString(SharedResourcesUtils.class, "fileName.AS400CLFile")),
        P_77(77, "EZReports_SharedResources_IDMSSubschemaRecord", Messages.getString(SharedResourcesUtils.class, "fileName.IDMSRecord")),
        P_78(78, "EZReports_SharedResources_IDMSSubschemaSet", Messages.getString(SharedResourcesUtils.class, "fileName.IDMSSet")),
        P_77777(-177, "EZReports_SharedResources_IDMSSubschemaRecord", Messages.getString(SharedResourcesUtils.class, "fileName.IDMSXRecord")),
        P_788888(-178, "EZReports_SharedResources_IDMSSubschemaSet", Messages.getString(SharedResourcesUtils.class, "fileName.IDMSXSet")),
        P_81(81, "EZReports_SharedResources_Queue", Messages.getString(SharedResourcesUtils.class, "fileName.Queue")),
        P_182(182, "EZReports_SharedResources_Datacom", Messages.getString(SharedResourcesUtils.class, "fileName.DatacomTable")),
        P_INCLUDE(-101, "EZViewer_SharedResources_Includes", Messages.getString(SharedResourcesUtils.class, "resourceName.include"));

        private Integer resTypeIdForGUI;
        private String procName;
        private String resTypeName;

        private Procedure(Integer resTypeId, String procName, String resTypeName) {
            this.resTypeIdForGUI = resTypeId;
            this.procName = procName;
            this.resTypeName = resTypeName;
        }

        public String getProcName() {
            return this.procName;
        }

        public String getProcNameUCMDB() {
            return String.valueOf(this.procName) + SharedResourcesUtils.UCMDB_NAME_IDENTIFIER;
        }

        public Integer getResTypeIdForGUI() {
            return this.resTypeIdForGUI;
        }

        public String getResTypeName() {
            return this.resTypeName;
        }

        public static Procedure getProcByResTypeId(Integer resTypeId) {
            Procedure[] procedureArray = Procedure.values();
            int n = procedureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Procedure proc = procedureArray[n2];
                if (proc.getResTypeIdForGUI().equals(resTypeId)) {
                    return proc;
                }
                ++n2;
            }
            if (resTypeId.equals(99) || resTypeId.equals(13) || resTypeId.equals(60) || resTypeId.equals(67)) {
                return P_INCLUDE;
            }
            L.warn("Undefined procedure for resource type id: {}", (Object)resTypeId);
            return null;
        }

        public boolean evaluate(ProjectInfo prjInfo) {
            boolean ret = false;
            String value = null;
            switch (this) {
                case P_1: {
                    value = "Relational";
                    ret = Manager.evaluateDbTypes((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_PROGRAMS: {
                    ret = true;
                    break;
                }
                case P_9: {
                    value = "";
                    ret = true;
                    break;
                }
                case P_81: {
                    value = "VME";
                    ret = !Manager.evaluateEnvironment((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_30: {
                    value = "SMART AS/400";
                    boolean bl = ret = !Manager.evaluateEnvironment((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    if (!ret) break;
                    value = "VME";
                    ret = !Manager.evaluateEnvironment((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_70: 
                case P_71: 
                case P_72: {
                    value = "SMART AS/400";
                    ret = Manager.evaluateEnvironment((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_64: {
                    value = "AIM/DB";
                    ret = Manager.evaluateDbTypes((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_56: {
                    value = "ADABAS";
                    ret = Manager.evaluateDbTypes((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_77: 
                case P_78: {
                    value = "IDMS";
                    ret = Manager.evaluateDbTypes((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_77777: 
                case P_788888: {
                    value = "IDMSX";
                    ret = Manager.evaluateDbTypes((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_18: {
                    value = "IMS/DB";
                    ret = Manager.evaluateDbTypes((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_182: {
                    value = "DATACOM";
                    ret = Manager.evaluateDbTypes((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                case P_INCLUDE: {
                    value = "COBOL,PL1,NATURAL,ASSEMBLER";
                    ret = Manager.evaluateLanguages((ProjectInfo)prjInfo, (String)value.toUpperCase());
                    break;
                }
                default: {
                    L.warn("proc {} not evaluated!", (Object)this);
                }
            }
            return ret;
        }
    }
}

