/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.common.ui.guielements.EZSpinner;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.internal.Activator;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.ui.wizard.PatternFilter;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSingleFromListPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SelectSingleFromListPage.class);
    public static final String SELECT_SINGLE_FROM_LIST = "SELECT_SINGLE_FROM_LIST";
    protected org.eclipse.swt.widgets.List listControl;
    private Button selProjButton;
    protected List<ListItem> items;
    private ListDetailProvider itemProvider;
    private String title;
    private String description;
    private String entityType;
    private boolean isBoxChecked;
    private Label listHeader;
    protected String selectionKey = "SELECT_SINGLE_FROM_LIST";
    private SelectionVerifier selectionVerifier = null;
    private PatternFilter patternFilter = null;
    protected PrepareReportWizard wizard = null;
    protected Composite filterComp;
    protected Text txtFilter;
    private EZSpinner spinner;
    protected Label lblFilter;
    private boolean hasFilters;
    private SelectionListener upSelector;
    private SelectionListener downSelector;
    private String headerInfo = null;
    protected static Image findBackgrGif = Activator.imageDescriptorFromPlugin((String)"com.ez.mainframe.gui", (String)"icons/search.png").createImage();
    private List<Integer> filtered = new ArrayList<Integer>();
    private int spinnerSelection;

    public SelectSingleFromListPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString(SelectSingleFromListPage.class, "page.title"));
        this.setDescription(Messages.getString(SelectSingleFromListPage.class, "page.description"));
    }

    public SelectSingleFromListPage(String pageName, String title, String description) {
        super(pageName);
        this.setTitle(title);
        this.setDescription(description);
    }

    public void setSelectionKey(String newKey) {
        this.selectionKey = newKey;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        super.setDescription(description);
        this.description = description;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public void setHeaderInfo(String headerInfo) {
        this.headerInfo = headerInfo;
    }

    public void createControl(Composite parent) {
        this.wizard = (PrepareReportWizard)this.getWizard();
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout());
        this.selProjButton = new Button(page, 32);
        this.selProjButton.setText(Messages.getString(SelectSingleFromListPage.class, "sel.proj.btn.txt"));
        this.listHeader = new Label(page, 0);
        this.listHeader.setText(Messages.getString(SelectSingleFromListPage.class, "list.label.txt"));
        this.createListOfInputs(page);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.heightHint = DpiScaler.getScaledSize((int)200);
        this.listControl.setLayoutData((Object)gd);
        this.selProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectSingleFromListPage.this.listControl != null) {
                    if (SelectSingleFromListPage.this.selProjButton.getSelection()) {
                        SelectSingleFromListPage.this.listControl.deselectAll();
                        SelectSingleFromListPage.this.listControl.setEnabled(false);
                        ((PrepareReportWizard)SelectSingleFromListPage.this.getWizard()).set(SelectSingleFromListPage.this.selectionKey, null);
                        SelectSingleFromListPage.this.setPageComplete(true);
                    } else {
                        SelectSingleFromListPage.this.setSelectionKey(SelectSingleFromListPage.this.selectionKey);
                        SelectSingleFromListPage.this.listControl.setEnabled(true);
                        SelectSingleFromListPage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.createFiltersArea(page);
        this.setPageComplete(false);
        parent.layout();
        this.setControl((Control)page);
    }

    protected void createFiltersArea(Composite page) {
        this.filterComp = new Composite(page, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        gl.horizontalSpacing = 1;
        gl.marginLeft = -5;
        gl.marginRight = -5;
        gl.marginTop = 10;
        this.filterComp.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.filterComp.setLayoutData((Object)gd);
        Label lblImg = new Label(this.filterComp, 0);
        lblImg.setImage(findBackgrGif);
        lblImg.setToolTipText(Messages.getString(SelectSingleFromListPage.class, "labelFiler.tooltip"));
        gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)15);
        lblImg.setLayoutData((Object)gd);
        this.txtFilter = new Text(this.filterComp, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.txtFilter.setLayoutData((Object)gd);
        this.txtFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SelectSingleFromListPage.this.filterItems();
            }
        });
        this.txtFilter.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = SelectSingleFromListPage.this.getDescriptionMsg(false);
                }
            }

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(SelectSingleFromListPage.class, "textFilter.name");
            }
        });
        this.createSpinner();
        this.lblFilter = new Label(this.filterComp, 131072);
        gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)35);
        gd.horizontalAlignment = 0x1000008;
        this.lblFilter.setLayoutData((Object)gd);
    }

    protected void createSpinner() {
        AccessibleAdapter upAccAdapter = new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = SelectSingleFromListPage.this.getDescriptionMsg(true);
                }
            }
        };
        AccessibleAdapter downAdapter = new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = SelectSingleFromListPage.this.getDescriptionMsg(true);
                }
            }
        };
        this.upSelector = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = SelectSingleFromListPage.this.spinnerSelection - 1;
                SelectSingleFromListPage.this.makeSelection(selection, false);
                SelectSingleFromListPage.this.spinner.sendAccessibleEvent(32781, null, 0);
            }
        };
        this.downSelector = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = SelectSingleFromListPage.this.spinnerSelection + 1;
                SelectSingleFromListPage.this.makeSelection(selection, true);
                SelectSingleFromListPage.this.spinner.sendAccessibleEvent(32781, null, 1);
            }
        };
        this.spinner = new EZSpinner(this.filterComp, 0);
        this.spinner.addSelectionListener(this.upSelector, 0);
        this.spinner.addSelectionListener(this.downSelector, 1);
        this.spinner.addAccessibleListener((AccessibleListener)upAccAdapter, 0);
        this.spinner.addAccessibleListener((AccessibleListener)downAdapter, 1);
        GridData gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)18);
        gd.heightHint = DpiScaler.getScaledSize((int)24);
        this.spinner.setLayoutData((Object)gd);
    }

    private String getDescriptionMsg(boolean selected) {
        int no = this.spinnerSelection < 0 ? 0 : (this.spinnerSelection == 0 ? 1 : this.spinnerSelection + 1);
        int all = this.filtered.size();
        String ret = selected ? Messages.getString(SelectSingleFromListPage.class, "spinner.buttons.description", new Object[]{no, all}) : Messages.getString(SelectSingleFromListPage.class, "textFilter.description", new Object[]{no, all});
        return ret;
    }

    protected void createListOfInputs(Composite page) {
        this.listControl = new org.eclipse.swt.widgets.List(page, 2820);
        this.listControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = SelectSingleFromListPage.this.listControl.getSelectionIndex();
                SelectSingleFromListPage.this.selectValue(idx);
            }
        });
    }

    private void makeSelection(int selection, boolean down) {
        if (selection > -1 && selection < this.filtered.size()) {
            this.lblFilter.setText(String.valueOf(selection + 1) + "/" + this.filtered.size());
            Integer idxToSelect = 0;
            if (this.filtered.size() > 0) {
                idxToSelect = this.filtered.get(selection);
            }
            this.listControl.select(idxToSelect.intValue());
            if (down) {
                if (selection > 0) {
                    this.listControl.deselect(this.filtered.get(selection - 1).intValue());
                }
            } else {
                this.listControl.deselect(this.filtered.get(selection + 1).intValue());
            }
            this.listControl.showSelection();
            this.selectValue(idxToSelect);
            this.spinnerSelection = selection;
        }
    }

    protected void filterItems() {
        String[] items;
        String filter = this.txtFilter.getText();
        this.listControl.deselectAll();
        this.resetFilters();
        if (filter != null && !"".equals(filter) && (items = this.listControl.getItems()) != null && items.length > 0) {
            int i = 0;
            while (i < items.length) {
                String item = items[i];
                if (this.checkFilter(item, filter) && this.checkSelectionOK(i) == null && !this.filtered.contains(i)) {
                    this.filtered.add(i);
                }
                ++i;
            }
        }
        if (this.filtered.size() > 0) {
            this.spinnerSelection = 0;
            this.makeSelection(this.spinnerSelection, true);
            this.txtFilter.setForeground(Display.getCurrent().getSystemColor(24));
        } else {
            this.resetFilters();
            this.txtFilter.setForeground(Display.getCurrent().getSystemColor(3));
            this.spinnerSelection = -1;
            this.selectValue(this.spinnerSelection);
        }
        this.txtFilter.getAccessible().sendEvent(32781, null);
    }

    protected boolean checkFilter(String target, String pattern) {
        return this.patternFilter == null ? target.toUpperCase().contains(pattern.toUpperCase()) : this.patternFilter.complies(target, pattern);
    }

    private void resetFilters() {
        this.filtered.clear();
        this.lblFilter.setText(String.valueOf(this.spinnerSelection < 0 ? 0 : this.spinnerSelection) + "/" + this.filtered.size());
    }

    protected String checkSelectionOK(int idx) {
        return this.selectionVerifier == null ? null : this.selectionVerifier.checkSelectionOK(this.items.get(idx));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && ((PrepareReportWizard)this.getWizard()).isForward()) {
            this.fillPage();
        }
    }

    protected void fillPage() {
        this.wizard.runLongOperation(new PrepareReportWizard.LongOperation(){

            @Override
            public void runOperation(IProgressMonitor pmonitor) throws Exception {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
                String project = SelectSingleFromListPage.this.wizard.getProject();
                monitor.setTaskName(Messages.getString(SelectSingleFromListPage.class, "getdata.task.name"));
                IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = connService.getProjectHandler(project, null);
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
                        SelectSingleFromListPage.this.getData(conn, (IProgressMonitor)monitor.newChild(100));
                    }
                }, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
                monitor.done();
            }

            @Override
            public Wizard getWizard() {
                return SelectSingleFromListPage.this.wizard;
            }
        });
        this.init();
    }

    protected void getData(EZSourceConnection bridge, IProgressMonitor monitor) {
        if (this.itemProvider != null) {
            this.items = this.itemProvider.getItems(bridge, monitor);
            this.title = this.itemProvider.getTitle();
            this.description = this.itemProvider.getDescription();
            this.entityType = this.itemProvider.getEntityType();
            this.isBoxChecked = this.itemProvider.isCheckBox();
            this.hasFilters = this.itemProvider.hasFilters();
        }
    }

    protected void init() {
        super.setTitle(this.title);
        super.setDescription(this.description);
        if (this.isBoxChecked) {
            this.selProjButton.setVisible(true);
        } else {
            this.selProjButton.setVisible(false);
        }
        String headerTxt = Messages.getString(SelectSingleFromListPage.class, "list.label.new.txt", new String[]{this.entityType});
        if (this.headerInfo != null) {
            headerTxt = headerTxt.concat(this.headerInfo);
        }
        this.listHeader.setText(headerTxt);
        this.listHeader.pack();
        if (this.items != null && this.items.size() > 0) {
            String[] strings = new String[this.items.size()];
            int i = 0;
            for (ListItem element : this.items) {
                strings[i++] = element.getListText();
            }
            this.listControl.setItems(strings);
        } else {
            this.listControl.removeAll();
        }
        this.wizard.set("resource_type", this.entityType);
        if (this.hasFilters) {
            this.filterComp.setVisible(true);
            this.txtFilter.setText("");
            this.resetFilters();
            this.setMessage("");
            this.txtFilter.setFocus();
        } else {
            this.filterComp.setVisible(false);
        }
    }

    public void setItemProvider(ListDetailProvider itemProvider) {
        this.itemProvider = itemProvider;
    }

    public void setSelectionVerifier(SelectionVerifier selectionVerifier) {
        this.selectionVerifier = selectionVerifier;
    }

    protected void selectValue(int index) {
        if (index != -1) {
            String message = this.checkSelectionOK(index);
            if (message != null) {
                this.listControl.deselectAll();
                this.setMessage(message, 2);
                index = -1;
                ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, null);
            } else {
                ListItem selItem = this.items.get(index);
                ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, selItem);
                this.setMessage(null);
                L.debug("selected: {}", (Object)selItem.getListText());
            }
        }
        this.setPageComplete(index != -1);
    }

    public PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public void setPatternFilter(PatternFilter patternFilter) {
        this.patternFilter = patternFilter;
    }

    public static class ArrayListItem
    implements ListItem,
    Serializable,
    Cloneable {
        private String[] object;
        private int position = 0;
        private String listText;
        private boolean duplicate;

        public Object clone() {
            ArrayListItem clone = new ArrayListItem();
            clone.listText = this.listText;
            clone.position = this.position;
            clone.object = (String[])this.object.clone();
            clone.duplicate = this.duplicate;
            return clone;
        }

        @Override
        public String getListText() {
            return this.listText != null ? this.listText : this.object[this.position];
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        public void appendStringToArray(String value) {
            String[] newObject = new String[this.object.length + 1];
            System.arraycopy(this.object, 0, newObject, 0, this.object.length);
            newObject[this.object.length] = value;
            this.object = newObject;
        }

        public void setStringArray(String[] object) {
            this.object = object;
        }

        public String[] getStringArray() {
            return this.object;
        }

        public void setStringPosition(int position) {
            this.position = position;
        }

        public void setListText(String listText) {
            this.listText = listText;
        }

        public void setElementAt(int idx, String newValue) {
            this.object[idx] = newValue;
        }

        public void setDuplicateName(boolean b) {
            this.duplicate = b;
        }

        public boolean hasDuplicateName() {
            return this.duplicate;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayListItem other = (ArrayListItem)obj;
            return Arrays.equals(this.object, other.object);
        }

        public String toString() {
            return "ArrayListItem [object=" + Arrays.toString(this.object) + "]";
        }
    }

    public static interface ListDetailProvider {
        public List<ListItem> getItems(EZSourceConnection var1, IProgressMonitor var2);

        public String getTitle();

        public String getDescription();

        public String getEntityType();

        public boolean isCheckBox();

        public boolean hasFilters();
    }

    public static interface ListItem {
        public String getListText();

        public Object getObject();
    }

    public static interface SelectionVerifier {
        public String checkSelectionOK(ListItem var1);
    }
}

