/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.common.ui.listselection.IOperationHandler;
import com.ez.common.ui.listselection.ListChangeEvent;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.listselection.ListSelectionUI;
import com.ez.common.ui.listselection.Listable;
import com.ez.common.ui.listselection.WizardLongOpeerationHandler;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectAbstractProgramsPage;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectProgramsPage<T extends Listable>
extends SelectAbstractProgramsPage<Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SelectProgramsPage.class);

    public SelectProgramsPage(String pageName, String pageTitle, String pageDescription) {
        super(pageName);
        if (pageTitle == null) {
            pageTitle = Messages.getString(SelectProgramsPage.class, "resourcesPage.title");
        }
        this.setTitle(pageTitle);
        if (pageDescription == null) {
            pageDescription = Messages.getString(SelectProgramsPage.class, "resourcesPage.description");
        }
        this.setDescription(pageDescription);
    }

    public SelectProgramsPage(String pageName, boolean useFilters, boolean generateOnlySummary) {
        this(pageName, Messages.getString(SelectProgramsPage.class, "resourcesPage.title"), Messages.getString(SelectProgramsPage.class, "resourcesPage.description"));
        this.useFilters = useFilters;
        this.showGenerateSummary = generateOnlySummary;
    }

    public SelectProgramsPage(String pageName) {
        this(pageName, false);
    }

    public SelectProgramsPage(String pageName, boolean useFilters) {
        this(pageName, useFilters, false);
    }

    public boolean isPageComplete() {
        this.wizard = (PrepareReportWizard)this.getWizard();
        List sel = this.wizard.getList(this.selectedPropName);
        L.debug("{}", (Object)sel);
        boolean ret = false;
        ret = sel != null && sel.size() >= this.MINIM_SIZE_OF_SELECTED;
        return ret;
    }

    @Override
    public void setLeftGroupLabel(String label) {
        if (this.propertiesGroup != null) {
            super.setLeftGroupLabel(label);
            ((ListSelectionUI)this.propertiesGroup).setLeftGroupLabel(label);
        } else {
            this.leftLabel = label;
        }
    }

    @Override
    public void setRightGroupLabel(String label) {
        if (this.propertiesGroup != null) {
            super.setRightGroupLabel(label);
            ((ListSelectionUI)this.propertiesGroup).setRightGroupLabel(label);
        } else {
            this.rightLabel = label;
        }
    }

    @Override
    protected void createContent(Composite composite) {
        this.propertiesGroup = new ListSelectionUI.Builder(composite).useFilters(this.useFilters).operationWorker((IOperationHandler)new WizardLongOpeerationHandler(true, false, this.getWizard())).createInstance();
        if (this.leftLabel != null) {
            ((ListSelectionUI)this.propertiesGroup).setLeftGroupLabel(this.leftLabel);
        }
        if (this.rightLabel != null) {
            ((ListSelectionUI)this.propertiesGroup).setRightGroupLabel(this.rightLabel);
        }
        this.propertiesGroup.addChangeListener(new ListChangeListener(){

            public void listChangeEventHappend(ListChangeEvent listChangeEv) {
                List selected = SelectProgramsPage.this.propertiesGroup.getSelObjectList();
                SelectProgramsPage.this.wizard.set(SelectProgramsPage.this.selectedPropName, selected);
                boolean enable = selected != null && selected.size() > 1;
                SelectProgramsPage.this.refreshCheckBoxes(enable);
                SelectProgramsPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }
}

