/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.mainframe.gui.internal.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectPathPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Composite container;
    private String selectedPath;

    public SelectPathPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString(SelectPathPage.class, "page.title"));
        this.setDescription(Messages.getString(SelectPathPage.class, "page.description"));
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 3;
        Label labelPath = new Label(this.container, 0);
        labelPath.setText(Messages.getString(SelectPathPage.class, "pathToSave.label"));
        final Text pathField = new Text(this.container, 2052);
        pathField.setText("");
        pathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SelectPathPage.this.selectedPath.trim().equals("")) {
                    SelectPathPage.this.selectedPath = pathField.getText();
                    SelectPathPage.this.setPageComplete(false);
                } else {
                    SelectPathPage.this.selectedPath = pathField.getText();
                    SelectPathPage.this.setPageComplete(true);
                }
            }
        });
        Button browseDirectory = new Button(this.container, 8);
        browseDirectory.setText(Messages.getString(SelectPathPage.class, "browse.button"));
        browseDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(Display.getDefault().getActiveShell(), 8192);
                dialog.open();
                pathField.setText(dialog.getFilterPath());
            }
        });
        GridData gd = new GridData(768);
        pathField.setLayoutData((Object)gd);
        this.setControl((Control)this.container);
        this.setPageComplete(false);
        this.selectedPath = pathField.getText();
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public boolean isPageComplete() {
        return !this.selectedPath.trim().equals("");
    }
}

