/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.ezsource.connection.EZSourceAuthorizationConnectionException;
import com.ez.ezsource.connection.EZSourceAuthorizatonException;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceLockException;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.internal.MainframeGUIErrorLog;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.MappingConstants;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.ApplicationInput;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.report.application.utils.ProjectApplicationInput;
import com.ez.workspace.ProjectInfoConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectApplicationsForSharedResourcesPage
extends SelectProgramsPage<ProjectApplicationInput> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SelectApplicationsForSharedResourcesPage.class);
    private List<EZSourceProjectInputType> inputProjects = null;

    public SelectApplicationsForSharedResourcesPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "page.title"));
        this.setLeftGroupLabel(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "av.applications.objectType"));
        this.setRightGroupLabel(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "sel.applications.objectType"));
        this.setAvailablePropName("available applications for shared resources");
        this.setSelectedPropName("selected applications for shared resources");
        this.MINIM_SIZE_OF_SELECTED = 2;
    }

    @Override
    public void fillUIWithProgress() {
        this.propertiesGroup.clearUILists();
        this.inputProjects = ((PrepareReportWizard)this.getWizard()).getList("selected projects");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                SelectApplicationsForSharedResourcesPage.this.setErrorMessage(null);
            }
        });
        this.wizard.runLongOperation(new PrepareReportWizard.LongOperation(){

            @Override
            public void runOperation(IProgressMonitor monitor) throws Exception {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                sub.setTaskName(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "loadApplications.task.name"));
                ArrayList inputApplications = new ArrayList();
                HashSet<String> notAccessibleProjects = new HashSet<String>();
                boolean bridgeErr = false;
                for (EZSourceProjectInputType inputProject : SelectApplicationsForSharedResourcesPage.this.inputProjects) {
                    SelectApplicationsForSharedResourcesPage.this.loadAppplicationsForProject(sub, inputProject, inputApplications, notAccessibleProjects);
                }
                SelectApplicationsForSharedResourcesPage.this.wizard.set(SelectApplicationsForSharedResourcesPage.this.availablePropName, inputApplications);
                if (bridgeErr) {
                    for (EZSourceProjectInputType project : SelectApplicationsForSharedResourcesPage.this.inputProjects) {
                        notAccessibleProjects.add(project.getName());
                    }
                }
                if (!notAccessibleProjects.isEmpty()) {
                    Object[] msgParams = new String[]{((Object)notAccessibleProjects).toString()};
                    final String msg = Messages.getString(SelectApplicationsForSharedResourcesPage.class, "notAccessibleProjects.wizPage.error.message", msgParams);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            SelectApplicationsForSharedResourcesPage.this.setErrorMessage(msg);
                        }
                    });
                    ArrayList<EZSourceProjectInputType> toRemove = new ArrayList<EZSourceProjectInputType>();
                    for (EZSourceProjectInputType project : SelectApplicationsForSharedResourcesPage.this.inputProjects) {
                        if (!notAccessibleProjects.contains(project.getName())) continue;
                        toRemove.add(project);
                    }
                    SelectApplicationsForSharedResourcesPage.this.inputProjects.removeAll(toRemove);
                    if (inputApplications.size() < 2) {
                        final String msg2 = Messages.getString(SelectApplicationsForSharedResourcesPage.class, "notEnoughApplications.wizPage.error.message2");
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                SelectApplicationsForSharedResourcesPage.this.setErrorMessage(msg2);
                            }
                        });
                    }
                }
                sub.done();
            }

            @Override
            public Wizard getWizard() {
                return SelectApplicationsForSharedResourcesPage.this.wizard;
            }
        });
        if (this.useFilters && this.availableImages != null && !this.availableImages.isEmpty()) {
            this.propertiesGroup.setAvailableImages(this.availableImages);
        }
        this.propertiesGroup.setAvailable(this.wizard.getList(this.availablePropName));
    }

    private void loadAppplicationsForProject(SubMonitor monitor, EZSourceProjectInputType inputProject, List<ProjectApplicationInput> inputApplications, Set<String> notAccessibleProjects) {
        String projectName = inputProject.getName();
        boolean projectIsUCMDB = false;
        ProjectInfo pInfo = (ProjectInfo)inputProject.getProperty("PROJECT_INFO");
        com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
        projectIsUCMDB = prjInfo.isUMCDB();
        if (projectIsUCMDB) {
            monitor.subTask(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "process.project.subtask.name", new String[]{projectName}));
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = service.getProjectHandler(projectName, null);
            final ArrayList availableApplications = new ArrayList();
            try {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        availableApplications.addAll(Utils.getAvailableApplications(conn));
                    }
                }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof EZSourceLockException) {
                    L.warn("Could not retrieve applications for project: {}. Project is locked!", (Object)projectName);
                    MainframeGUIErrorLog.warn(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "project.locked.warn.message", new String[]{projectName}), null);
                    notAccessibleProjects.add(projectName);
                } else if (e.getCause() instanceof EZSourceAuthorizationConnectionException) {
                    L.error("bridge EZSourceAuthorizationConnectionException", (Throwable)e);
                    MainframeGUIErrorLog.warn(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "project.applications.fail.error.message", new String[]{projectName, MappingConstants.NO_CONNECTION_TO_LICENSE_MSG}), e);
                    notAccessibleProjects.add(projectName);
                } else if (e.getCause() instanceof EZSourceAuthorizatonException) {
                    L.error("bridge EZSourceAuthorizatonException", (Throwable)e);
                    MainframeGUIErrorLog.warn(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "project.applications.fail.error.message", new String[]{projectName, MappingConstants.LICENSE_OPERATION_DENIED_MSG}), e);
                    notAccessibleProjects.add(projectName);
                } else if (e.getCause() instanceof EZSourceConnectionException) {
                    L.error("bridge EZSourceConnectionException", (Throwable)e);
                    MainframeGUIErrorLog.warn(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "project.applications.connection.error.message"), e);
                    notAccessibleProjects.add(projectName);
                }
            }
            catch (Exception e) {
                L.error("", (Throwable)e);
            }
            if (!availableApplications.isEmpty()) {
                for (ApplicationInput appInput : availableApplications) {
                    inputApplications.add(new ProjectApplicationInput(projectName, appInput.getListableName(), true));
                }
            } else {
                L.warn("Multi-app project: {} has no applications defined and will be treated as a simple project", (Object)projectName);
                MainframeGUIErrorLog.warn(Messages.getString(SelectApplicationsForSharedResourcesPage.class, "multiApp.noApplications.warn.message", new String[]{projectName}), null);
                inputApplications.add(new ProjectApplicationInput(projectName, projectName, false));
            }
        } else {
            inputApplications.add(new ProjectApplicationInput(projectName, projectName, false));
        }
    }
}

