/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.internal.MainframeGUIErrorLog;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.ApplicationInput;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectApplicationPage
extends AbstractWizardPage
implements ICheckStateListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SelectApplicationPage.class);
    private CheckboxTableViewer checkBoxList;
    private Map applications;
    private Map<String, ApplicationInput> checked = new HashMap<String, ApplicationInput>();
    private boolean filterList = false;
    private boolean showAppendixVal = false;

    public SelectApplicationPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString(SelectApplicationPage.class, "applicationsPage.title"));
        this.setDescription(Messages.getString(SelectApplicationPage.class, "applicationsPage.description"));
        this.applications = new HashMap();
    }

    public SelectApplicationPage(String pageName, boolean generateOnlySummary) {
        this(pageName);
        this.showReportsOptionGroup = true;
        this.showGenerateSummary = generateOnlySummary;
    }

    @Override
    public void createControl(Composite parent) {
        this.init((IProgressMonitor)new NullProgressMonitor());
        super.createControl(parent);
    }

    @Override
    protected void createContent(Composite composite) {
        Label info = new Label(composite, 16384);
        info.setText(Messages.getString(SelectApplicationPage.class, "dialog.label"));
        this.createCheckBoxList(composite);
    }

    @Override
    protected void init(IProgressMonitor monitor) {
        this.wizard = (PrepareReportWizard)this.getWizard();
        super.init(monitor);
    }

    private void createCheckBoxList(Composite parent) {
        this.checkBoxList = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = this.checkBoxList.getTable().getItemHeight() * 10;
        this.checkBoxList.getTable().setLayoutData((Object)data);
        this.checkBoxList.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.checkBoxList.setContentProvider(this.createContentProvider());
        this.checkBoxList.setSorter(new ViewerSorter());
        if (this.applications.size() > 0) {
            this.checkBoxList.setInput(this.applications.values());
        }
        this.checkBoxList.addCheckStateListener((ICheckStateListener)this);
        this.addSelectionButtons(parent);
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        String label = Messages.getString(SelectApplicationPage.class, "selectAll.button");
        Button selectButton = new Button(buttonComposite, 8);
        selectButton.setText(label);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectApplicationPage.this.checkBoxList.setAllChecked(true);
                SelectApplicationPage.this.checked.putAll(SelectApplicationPage.this.applications);
                SelectApplicationPage.this.refreshCheckBoxes(true);
                SelectApplicationPage.this.setPageComplete(SelectApplicationPage.this.isPageComplete());
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        label = Messages.getString(SelectApplicationPage.class, "deselectAll.button");
        Button deselectButton = new Button(buttonComposite, 8);
        deselectButton.setText(label);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectApplicationPage.this.checkBoxList.setAllChecked(false);
                SelectApplicationPage.this.checked.clear();
                SelectApplicationPage.this.refreshCheckBoxes(false);
                SelectApplicationPage.this.setPageComplete(SelectApplicationPage.this.isPageComplete());
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ApplicationInput) {
                    return ((ApplicationInput)((Object)element)).getListableName();
                }
                return element.toString();
            }
        };
    }

    private IContentProvider createContentProvider() {
        return new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                L.warn("wrong type of objects in datasource of list");
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    public boolean isPageComplete() {
        boolean pageComplete = !this.checked.isEmpty();
        L.debug("checked size: {}", (Object)this.checked.size());
        return pageComplete;
    }

    public void setSelectedApplications() {
        HashSet<String> appNames = new HashSet<String>();
        HashSet<String> ids = new HashSet<String>();
        for (ApplicationInput app : this.checked.values()) {
            ids.add(app.getApplicationID());
            appNames.add(app.getListableName());
        }
        this.wizard.set("selected applications", ids);
        this.wizard.set("selected applications names", appNames);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getSource().equals(this.checkBoxList)) {
            ApplicationInput objSelected = (ApplicationInput)((Object)event.getElement());
            if (event.getChecked()) {
                this.checked.put(objSelected.getListableName(), objSelected);
            } else {
                this.checked.remove(objSelected.getListableName());
            }
            boolean enable = this.checked != null && this.checked.size() > 0;
            this.refreshCheckBoxes(enable);
            this.setPageComplete(this.isPageComplete());
        }
    }

    public void dispose() {
        this.wizard = null;
        super.dispose();
    }

    public void setFilterAppList(boolean filter) {
        this.filterList = filter;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            SelectSingleFromListPage.ArrayListItem inputApp;
            this.checkBoxList.setInput(new ArrayList(this.applications.values()));
            if (this.filterList && (inputApp = (SelectSingleFromListPage.ArrayListItem)this.wizard.getValue("SELECT_SINGLE_FROM_LIST")) != null) {
                String appName = inputApp.getListText();
                ApplicationInput appInpt = (ApplicationInput)((Object)this.applications.get(appName));
                ((Collection)this.checkBoxList.getInput()).remove((Object)appInpt);
                this.checkBoxList.refresh();
            }
        }
        super.setVisible(visible);
    }

    public void fillApplicationsList() {
        this.wizard.runLongOperation(new PrepareReportWizard.LongOperation(){

            @Override
            public void runOperation(IProgressMonitor pmonitor) {
                pmonitor.beginTask(Messages.getString(SelectApplicationPage.class, "getData.progress.taskName"), -1);
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
                String project = SelectApplicationPage.this.wizard.getProject();
                IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler projectHandler = service.getProjectHandler(project, null);
                try {
                    projectHandler.executeWithLock(projectHandler, new IMFRunnable(){

                        public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                            List<ApplicationInput> apps = Utils.getAvailableApplications(conn);
                            for (ApplicationInput app : apps) {
                                SelectApplicationPage.this.applications.put(app.getListableName(), app);
                            }
                            (this).SelectApplicationPage.this.wizard.set("available applications", apps);
                        }
                    }, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
                }
                catch (InterruptedException e) {
                    L.error("", (Throwable)e);
                }
                catch (Exception e) {
                    L.error("while computing results", (Throwable)e);
                    MainframeGUIErrorLog.err(Messages.getString(SelectApplicationPage.class, "connectionError.log.message"), e);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SelectApplicationPage.this.setErrorMessage(Messages.getString(SelectApplicationPage.class, "connectionError.message"));
                        }
                    });
                }
                pmonitor.done();
            }

            @Override
            public Wizard getWizard() {
                return SelectApplicationPage.this.wizard;
            }
        });
        this.checkBoxList.setInput(new ArrayList(this.applications.values()));
    }

    @Override
    protected boolean getShowAppendixValue() {
        return this.showAppendixVal;
    }

    public void setShowAppendixValue(boolean val) {
        this.showAppendixVal = val;
    }
}

