/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.common.ui.listselection.AbstractSelectionUI;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.Listable;
import com.ez.mainframe.gui.internal.MainframeGUIErrorLog;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.ui.collectors.ProgramInputsFactory4Wizard;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SelectAbstractProgramsPage<T extends Listable>
extends AbstractWizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SelectAbstractProgramsPage.class);
    protected AbstractSelectionUI<T> propertiesGroup = null;
    private boolean runSearch = true;
    protected ResourcesCollector<T> resourcesCollector = null;
    protected static final int DIALOG_MIN_HEIGHT = 710;
    protected static final int DIALOG_MIN_WIDTH = 880;
    protected List<ImageObj4Wizard> availableImages;
    protected String availablePropName = "available resources";
    protected String selectedPropName = "selected resources";
    protected Integer MINIM_SIZE_OF_SELECTED = new Integer(1);
    private String noResourceErrMsg = null;
    protected static final String localErrMsg = Messages.getString(SelectAbstractProgramsPage.class, "nores.info");
    protected boolean hasInputsAsSelected = false;
    protected Set<Integer> availableTypesForFilters;
    private boolean otherRes = false;
    protected String rightLabel = null;
    protected String leftLabel;
    protected String pageDescriptionWhenNoResources = null;

    SelectAbstractProgramsPage(String pageName, boolean useFilters, boolean generateOnlySummary) {
        super(pageName);
        this.setTitle(Messages.getString(SelectAbstractProgramsPage.class, "resourcesPage.title"));
        this.setDescription(Messages.getString(SelectAbstractProgramsPage.class, "resourcesPage.description"));
        this.useFilters = useFilters;
        this.showGenerateSummary = generateOnlySummary;
    }

    public SelectAbstractProgramsPage(String pageName) {
        this(pageName, false);
    }

    public SelectAbstractProgramsPage(String pageName, boolean useFilters) {
        this(pageName, useFilters, false);
    }

    public void setResourcesCollector(ResourcesCollector resourcesCollector) {
        this.resourcesCollector = resourcesCollector;
    }

    public ResourcesCollector<T> getResourcesCollector() {
        return this.resourcesCollector;
    }

    @Override
    protected void init(IProgressMonitor pmonitor) {
        Set apps = (Set)this.wizard.getValue("selected applications");
        List<T> res = null;
        String errMsg = null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        if (this.resourcesCollector == null) {
            if (this.hasInputsAsSelected) {
                ProgramInputsFactory4Wizard factory = ProgramInputsFactory4Wizard.getInstance();
                this.availableImages = factory.buildAvailableImagesFromTypes(this.availableTypesForFilters);
                this.wizard.set(this.selectedPropName, this.wizard.getList(this.availablePropName));
            } else {
                L.info("resourceCollector is null");
            }
        } else {
            try {
                String prjName = this.wizard.getProject();
                L.debug("will open project {}", (Object)prjName);
                res = this.resourcesCollector.collect(this.useFilters, apps, prjName, (IProgressMonitor)monitor.newChild(80));
                this.availableImages = this.resourcesCollector.getAvailableImages();
                this.wizard.set(this.availablePropName, res);
                monitor.worked(20);
                if ((res == null || res.isEmpty()) && !this.acceptNoRes()) {
                    errMsg = this.noResourceErrMsg != null ? this.noResourceErrMsg : localErrMsg;
                }
                final String cpy = errMsg;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SelectAbstractProgramsPage.this.setErrorMessage(cpy);
                    }
                });
                if (this.pageDescriptionWhenNoResources != null && res.isEmpty() && this.acceptNoRes()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SelectAbstractProgramsPage.this.setDescription(SelectAbstractProgramsPage.this.pageDescriptionWhenNoResources);
                        }
                    });
                }
            }
            catch (Exception e) {
                L.error("while computing results", (Throwable)e);
                MainframeGUIErrorLog.err(Messages.getString(SelectAbstractProgramsPage.class, "connectionError.log.message"), e);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SelectAbstractProgramsPage.this.setErrorMessage(Messages.getString(SelectAbstractProgramsPage.class, "connectionError.message"));
                    }
                });
            }
        }
        super.init((IProgressMonitor)monitor.newChild(1));
    }

    protected boolean acceptNoRes() {
        return false;
    }

    @Override
    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ez.report.application.ezreport.help_general");
        super.createControl(parent);
    }

    public void dispose() {
        if (this.propertiesGroup != null) {
            this.propertiesGroup.resetPanel();
            this.propertiesGroup = null;
        }
        this.wizard = null;
        super.dispose();
    }

    @Override
    protected abstract void createContent(Composite var1);

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.runSearch) {
            L.debug("page is visible");
            this.runSearch = false;
            if (this.btnSummary != null && this.btnAppendix != null) {
                this.btnSummary.setSelection(false);
                this.btnAppendix.setSelection(this.getShowAppendixValue());
                List selected = this.propertiesGroup.getSelObjectList();
                boolean enable = selected != null && selected.size() > 1;
                this.refreshCheckBoxes(enable);
            }
        }
    }

    public void setRunSearch(boolean b) {
        this.runSearch = b;
    }

    @Override
    protected void addShowAppendixOptions(Composite optionsGroup) {
        this.defaultAddAppendixOptions(optionsGroup);
    }

    public void fillUIWithProgress() {
        this.wizard.runLongOperation(new PrepareReportWizard.LongOperation(){

            @Override
            public void runOperation(IProgressMonitor monitor) throws Exception {
                monitor.beginTask(Messages.getString(SelectAbstractProgramsPage.class, "getData.progress.taskName"), -1);
                SelectAbstractProgramsPage.this.wizard.set(SelectAbstractProgramsPage.this.selectedPropName, null);
                SelectAbstractProgramsPage.this.init(monitor);
                monitor.done();
            }

            @Override
            public Wizard getWizard() {
                return SelectAbstractProgramsPage.this.wizard;
            }
        });
        if (this.propertiesGroup != null) {
            this.fillGUI();
        }
    }

    protected void fillGUI() {
        this.propertiesGroup.clearUILists();
        if (this.useFilters && this.availableImages != null && !this.availableImages.isEmpty()) {
            this.propertiesGroup.setAvailableImages(this.availableImages);
        }
        if (this.hasInputsAsSelected) {
            this.propertiesGroup.setSelected(this.wizard.getList(this.selectedPropName));
        } else {
            this.propertiesGroup.setAvailable(this.wizard.getList(this.availablePropName));
        }
        this.propertiesGroup.makeSelectionIfSingle();
    }

    public void setAvailablePropName(String propName) {
        this.availablePropName = propName;
    }

    public String getAvailablePropName() {
        return this.availablePropName;
    }

    public void setSelectedPropName(String propName) {
        this.selectedPropName = propName;
    }

    public String getSelectedPropName() {
        return this.selectedPropName;
    }

    public void setErrMsgNoResource(String noResourceErrMsg) {
        this.noResourceErrMsg = noResourceErrMsg;
    }

    public boolean hasInputsAsSelected() {
        return this.hasInputsAsSelected;
    }

    public void setHasInputsAsSelected(boolean hasInputsAsSelected) {
        this.hasInputsAsSelected = hasInputsAsSelected;
    }

    public Set<Integer> getAvailableTypesForFilters() {
        return this.availableTypesForFilters;
    }

    public void setAvailableTypesForFilters(Set<Integer> availableTypesForFilters) {
        this.availableTypesForFilters = availableTypesForFilters;
    }

    public void setLeftGroupLabel(String label) {
        this.leftLabel = label;
    }

    public void setRightGroupLabel(String label) {
        this.rightLabel = label;
    }

    @Override
    protected void checkOnlySummary() {
        super.checkOnlySummary();
        boolean selected = this.btnSummary.getSelection();
        if (this.btnShowInputs != null) {
            this.btnShowInputs.setEnabled(selected ? this.btnAppendix.getSelection() : true);
        }
    }

    @Override
    protected void checkAppendix() {
        super.checkAppendix();
        boolean showAppendix = this.btnAppendix.getSelection();
        if (this.btnShowInputs != null) {
            this.btnShowInputs.setEnabled(showAppendix);
        }
    }

    private abstract class ResourcesRunnable
    implements IMFRunnable {
        public List<T> resources = null;

        private ResourcesRunnable() {
        }
    }
}

