/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.listselection.Listable;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.mainframe.gui.internal.MainframeGUIErrorLog;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.wizard.GenericSelectPage;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.utils.ProjectApplicationInput;
import com.ez.report.application.utils.SharedResourcesUtils;
import com.ez.workspace.ProjectInfoConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypesPage
extends GenericSelectPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResourceTypesPage.class);
    private List<EZSourceProjectInputType> selectedProjects = null;
    private List<ProjectApplicationInput> selectedApplications = null;
    @Deprecated
    private Boolean useApplications = SharedResourcesUtils.useApplications();
    private boolean showAppendixVal = false;

    public ResourceTypesPage(String pageName) {
        super(pageName);
    }

    public ResourceTypesPage(String pageName, boolean showReportOptionsGroup) {
        super(pageName);
        this.showReportsOptionGroup = true;
    }

    private void analyzeProject(SubMonitor monitor, Map<SharedResourcesUtils.Procedure, Integer> vals, EZSourceProjectInputType inputProject, Set<String> notAccessiblePrjs) {
        SharedResourcesUtils.Procedure[] procs = SharedResourcesUtils.Procedure.values();
        String prjName = inputProject.getName();
        monitor.subTask(Messages.getString(ResourceTypesPage.class, "analyzingProject.task.name", new String[]{prjName}));
        ProjectInfo mfPrjInfo = (ProjectInfo)inputProject.getProperty("PROJECT_INFO");
        if (mfPrjInfo != null && mfPrjInfo.getInfo() != null && !mfPrjInfo.getInfo().isEmpty()) {
            com.ez.ezsource.connection.ProjectInfo ezProjectInfo = ProjectInfoConverter.convert((Map)mfPrjInfo.getInfo());
            if (ezProjectInfo.getEnvironment() != null && !ezProjectInfo.getEnvironment().equals("")) {
                int i = 0;
                while (i < procs.length) {
                    boolean available;
                    SharedResourcesUtils.Procedure proc = procs[i];
                    if (proc != null && (available = proc.evaluate(ezProjectInfo))) {
                        Integer no = vals.get((Object)proc);
                        no = no == null ? new Integer(1) : new Integer(no + 1);
                        vals.put(proc, no);
                    }
                    ++i;
                }
            } else {
                L.warn("Project {} has no environment set!", (Object)prjName);
                MainframeGUIErrorLog.warn(Messages.getString(ResourceTypesPage.class, "noEnvironment.errorView.message"), null);
                notAccessiblePrjs.add(prjName);
            }
        } else {
            L.warn("Project {} has no project info!", (Object)prjName);
            MainframeGUIErrorLog.warn(Messages.getString(ResourceTypesPage.class, "noProjectInfo.errorView.message", new String[]{prjName}), null);
            notAccessiblePrjs.add(prjName);
        }
    }

    private List<Listable> getResourceTypes(Map<SharedResourcesUtils.Procedure, Integer> vals) {
        ArrayList<Listable> resrs = new ArrayList<Listable>();
        for (SharedResourcesUtils.Procedure proc : vals.keySet()) {
            Integer val = vals.get((Object)proc);
            if (val <= 1) continue;
            BaseMainframeResourceInput inpt = new BaseMainframeResourceInput(proc.getResTypeName(), proc.getResTypeIdForGUI());
            resrs.add((Listable)new BaseMainframeResource4GUI((BaseResourceInput)inpt));
        }
        return resrs;
    }

    @Override
    public void fillUIWithProgress() {
        this.selectedProjects = this.wizard.getList("selected projects");
        this.selectedApplications = this.wizard.getList("selected applications for shared resources");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ResourceTypesPage.this.setErrorMessage(null);
            }
        });
        this.wizard.runLongOperation(new PrepareReportWizard.LongOperation(){

            @Override
            public void runOperation(IProgressMonitor monitor) throws Exception {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                sub.setTaskName(Messages.getString(ResourceTypesPage.class, "checkProjects.task.name"));
                HashMap<SharedResourcesUtils.Procedure, Integer> vals = new HashMap<SharedResourcesUtils.Procedure, Integer>();
                HashSet notAccessiblePrjs = new HashSet();
                HashSet<String> notAccessibleApps = new HashSet<String>();
                for (EZSourceProjectInputType inputProject : ResourceTypesPage.this.selectedProjects) {
                    ResourceTypesPage.this.analyzeProject(sub, vals, inputProject, notAccessiblePrjs);
                }
                Object[] msgParams = new String[]{((Object)notAccessiblePrjs).toString()};
                final String msg = Messages.getString(ResourceTypesPage.class, "noResourceTypes.wizPage.error.message", msgParams);
                if (!notAccessiblePrjs.isEmpty()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResourceTypesPage.this.setErrorMessage(msg);
                        }
                    });
                }
                ResourceTypesPage.this.wizard.set("not accessible projects", notAccessiblePrjs);
                List types = new ArrayList();
                boolean enoughPrjsOrApps = false;
                String notEnoughMessage = null;
                if (ResourceTypesPage.this.useApplications.booleanValue()) {
                    if (!notAccessiblePrjs.isEmpty()) {
                        for (String string : notAccessiblePrjs) {
                            for (ProjectApplicationInput inputApp : ResourceTypesPage.this.selectedApplications) {
                                if (!inputApp.getProjectName().equals(string)) continue;
                                notAccessibleApps.add(inputApp.getDisplayName());
                                MainframeGUIErrorLog.warn(Messages.getString(ResourceTypesPage.class, "notAccessibleApp.errorView.message", new String[]{inputApp.getDisplayName()}), null);
                            }
                        }
                    }
                    if (ResourceTypesPage.this.selectedApplications.size() - notAccessibleApps.size() > 1) {
                        enoughPrjsOrApps = true;
                        for (Map.Entry entry : vals.entrySet()) {
                            Integer newVal = (Integer)entry.getValue() + 1;
                            vals.put((SharedResourcesUtils.Procedure)((Object)entry.getKey()), newVal);
                        }
                    } else {
                        notEnoughMessage = Messages.getString(ResourceTypesPage.class, "notEnoughApplications.wizPage.error.message");
                    }
                    ResourceTypesPage.this.wizard.set("not accessible applications for shared resources", notAccessibleApps);
                } else if (ResourceTypesPage.this.selectedProjects.size() - notAccessiblePrjs.size() > 1) {
                    enoughPrjsOrApps = true;
                } else {
                    notEnoughMessage = Messages.getString(ResourceTypesPage.class, "notEnoughProjects.wizPage.error.message");
                }
                if (enoughPrjsOrApps) {
                    types = ResourceTypesPage.this.getResourceTypes(vals);
                    if (types.isEmpty()) {
                        final String string = Messages.getString(ResourceTypesPage.class, "noCommonTypes.wizPage.error.message");
                        MainframeGUIErrorLog.warn(string, null);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ResourceTypesPage.this.setErrorMessage(string);
                            }
                        });
                    }
                } else {
                    L.warn("there are not at least two projects or applications available");
                    final String string = String.valueOf(msg) + notEnoughMessage;
                    MainframeGUIErrorLog.warn(string, null);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResourceTypesPage.this.setErrorMessage(string);
                        }
                    });
                }
                ResourceTypesPage.this.setAvailableResources(types);
                sub.done();
            }

            @Override
            public Wizard getWizard() {
                return ResourceTypesPage.this.wizard;
            }
        });
        super.fillUIWithProgress();
    }

    @Override
    protected boolean getShowAppendixValue() {
        return this.showAppendixVal;
    }

    public void setShowAppendixValue(boolean val) {
        this.showAppendixVal = val;
    }
}

