/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectAbstractProgramsPage;
import com.ez.report.application.ui.wizard.SelectApplicationPage;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportWizardDialog
extends WizardDialog
implements IPageChangingListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportWizardDialog.class);
    private Shell shell;

    public ReportWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        this.shell = parentShell;
        this.addPageChangingListener(this);
        ReportWizardDialog.setDialogHelpAvailable((boolean)true);
        this.setHelpAvailable(true);
    }

    protected void backPressed() {
        ((WizardPage)this.getCurrentPage()).setPageComplete(false);
        super.backPressed();
    }

    public int open() {
        int ret;
        IWizardPage page = this.getCurrentPage();
        if (this.shouldFillPage(page)) {
            this.setBlockOnOpen(false);
            ret = super.open();
            if (page instanceof SelectAbstractProgramsPage) {
                SelectAbstractProgramsPage pageSel = (SelectAbstractProgramsPage)page;
                pageSel.fillUIWithProgress();
                this.getWizard().getContainer().updateButtons();
            }
            this.runEventLoop(this.getShell());
        } else if (page.getName().equals("applications name page")) {
            this.setBlockOnOpen(false);
            ret = super.open();
            SelectApplicationPage appSelPage = (SelectApplicationPage)page;
            appSelPage.fillApplicationsList();
            this.runEventLoop(appSelPage.getShell());
        } else {
            ret = super.open();
        }
        return ret;
    }

    protected boolean shouldFillPage(IWizardPage firstPage) {
        return firstPage.getName().equals("programs page") || firstPage.getName().equals("mfLibraries name page") || firstPage.getName().equals("tests page") || firstPage.getName().equals("single program page") || firstPage.getName().equals("programs for callgraph page") || firstPage.getName().equals("applications for shared resources page") || firstPage.getName().equals("RDZ mainframe project page") || firstPage.getName().equals("ddcl elements for application master graph page") || firstPage.getName().equalsIgnoreCase("sapiens root page") || firstPage.getName().equalsIgnoreCase("roots page") || firstPage.getName().equals("single assembler program page");
    }

    public void handlePageChanging(PageChangingEvent event) {
        IWizardPage currentPage = (IWizardPage)event.getCurrentPage();
        IWizardPage nextPage = (IWizardPage)event.getTargetPage();
        L.debug("handlePageChanging(); currentPage: {}, targetPage: {}", (Object)currentPage.getName(), (Object)nextPage.getName());
        ((PrepareReportWizard)this.getWizard()).setChangeDirection(currentPage, nextPage);
        if (currentPage.equals(((PrepareReportWizard)this.getWizard()).getPage("applications name page"))) {
            ((SelectApplicationPage)currentPage).setSelectedApplications();
        }
        if ((currentPage.equals(((PrepareReportWizard)this.getWizard()).getPage("applications name page")) || currentPage.equals(((PrepareReportWizard)this.getWizard()).getPage("program or include")) || currentPage.equals(((PrepareReportWizard)this.getWizard()).getPage("No DB resources page")) || currentPage.equals(((PrepareReportWizard)this.getWizard()).getPage("applications for shared resources page")) || currentPage.equals(((PrepareReportWizard)this.getWizard()).getPage("roots page"))) && nextPage.equals(((PrepareReportWizard)this.getWizard()).getPage("programs page"))) {
            SelectProgramsPage pageSel = (SelectProgramsPage)nextPage;
            pageSel.setRunSearch(true);
            pageSel.fillUIWithProgress();
        } else if (currentPage.getName().equals("single program page") && nextPage.getName().equals("single assembler program page") || currentPage.getName().equals("programs for callgraph page") && nextPage.getName().equals("ass children page") || currentPage.getName().equals("sapiens root page") && nextPage.getName().equalsIgnoreCase("sapiens inputs page")) {
            SelectAbstractProgramsPage selectAssemblerPage = (SelectAbstractProgramsPage)nextPage;
            selectAssemblerPage.setRunSearch(true);
            selectAssemblerPage.fillUIWithProgress();
        } else if (currentPage.equals(((PrepareReportWizard)this.getWizard()).getPage("No DB resources page")) && nextPage.equals(((PrepareReportWizard)this.getWizard()).getPage("applications name page"))) {
            SelectApplicationPage appSelPage = (SelectApplicationPage)nextPage;
            appSelPage.fillApplicationsList();
        } else {
            L.debug("nextPage: {}", (Object)nextPage);
        }
    }

    protected void firePageChanged(PageChangedEvent event) {
        super.firePageChanged(event);
    }

    public Button getButton(int id) {
        return super.getButton(id);
    }

    protected void buttonPressed(int buttonId) {
        if (((PrepareReportWizard)this.getWizard()).buttonPressed(buttonId)) {
            super.buttonPressed(buttonId);
        }
    }

    protected void cancelPressed() {
        if (((PrepareReportWizard)this.getWizard()).cancelPressed()) {
            super.cancelPressed();
        }
    }

    protected void runEventLoop(Shell loopShell) {
        Display display = this.shell == null ? Display.getCurrent() : loopShell.getDisplay();
        while (loopShell != null && !loopShell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                L.error("display exception", e);
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
    }
}

