/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.ProgramsParamCollector;
import com.ez.report.application.ui.wizard.SelectAbstractProgramsPage;
import com.ez.report.application.ui.wizard.SelectApplicationPage;
import com.ez.report.application.ui.wizard.SelectPathPage;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareReportWizard
extends Wizard {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PrepareReportWizard.class);
    public static final String PROGRAMS_PAGE_NAME = "programs page";
    public static final String PROGRAMS_FOR_CALLGRAPH_PAGE_NAME = "programs for callgraph page";
    public static final String JOBS_FOR_CALLGRAPH_PAGE_NAME = "jobs for callgraph page";
    public static final String ASSEMBLER_CHILDREN_FOR_CALLGRAPH_PAGE_NAME = "ass children page";
    public static final String SINGLE_PROGRAM_PAGE_NAME = "single program page";
    public static final String SINGLE_ASSEMBLER_PAGE_NAME = "single assembler program page";
    public static final String STATEMENTS_PAGE_NAME = "statements page";
    public static final String PATTERN_SEARCH_PAGE_NAME = "pattern search page";
    public static final String APPLICATIONS_PAGE_NAME = "applications name page";
    public static final String SINGLE_APPLICATION_PAGE_NAME = "application name page";
    public static final String PROGRAM_OR_INCLUDE_PAGE_NAME = "program or include";
    public static final String VARIABLE_SELECT_PAGE_NAME = "variable select page name";
    public static final String COMPARE_PROJECTS_PAGE_NAME = "compare projects";
    public static final String COMPARE_APPLICATIONS_PAGE_NAME = "compare applications";
    public static final String MFLIBRARIES_PAGE_NAME = "mfLibraries name page";
    public static final String JAVA_CLASSES_PAGE_NAME = "Classes from java";
    public static final String GATHERING_SOURCES_PAGE_NAME = "Gathering sources";
    public static final String EXCLUDE_DATASETS_PAGE_NAME = "Datasets to be excluded";
    public static final String NO_DB_RESOURCES_PAGE_NAME = "No DB resources page";
    public static final String SELECTED_ASS_RESOURCES = "SELECTED_ASS_RESOURCES";
    public static final String APPLICATIONS_FOR_SHARED_RESOURCES_PAGE_NAME = "applications for shared resources page";
    public static final String RDZ_MAINFRAME_PROJECT_PAGE_NAME = "RDZ mainframe project page";
    public static final String RDZ_MAINFRAME_ANALYSIS_PAGE_NAME = "RDZ mainframe analysis page";
    public static final String DDCL_ELEMENTS_FOR_APPLICATION_MASTER_PAGE = "ddcl elements for application master graph page";
    public static final String SAPIENS_ROOT_PAGE_NAME = "sapiens root page";
    public static final String SAPIENS_INPUTS_PAGE_NAME = "sapiens inputs page";
    public static final String TESTS_PAGE_NAME = "tests page";
    public static final String UNREF_DDCL_ROOTS_PAGENAME = "roots page";
    public static final String EMPTY_PAGE_NAME = "empty name page";
    public static final String SELECTED_VARIABLE = "selected variable(s)";
    public static final String SELECTED_ID = "selected id";
    private Map model = new HashMap();
    private boolean canceled = false;
    private boolean forward = true;
    private boolean containsOnlyApplicationsPage = false;
    private String project;
    private boolean projectIsUCMDB;
    private int projectDatabaseEngine;
    public static final String LOGICAL_OR_PHYSICAL_FILENAME = "file_name_selection";
    public static final String TARGET_PROJECT = "target project";
    public static final String SOURCE_APPLICATION = "source application";
    public static final String TARGET_APPLICATION = "target application";
    public static final String TARGET_OUTPUT_EDITOR = "target output editor";
    public static final String JAVA_CLASS = "target java class";
    public static final String JAVA_METHOD = "target method class";
    public static final String JAVA_PARAM = "target java param";
    public static final String GENERATE_DETAILED_INFO = "generate detailed information";
    public static final String DATAFLOW_DIRECTION = "directed";
    public static final String GRAPH_DIRECTION = "graph direction: forward or backward or both";
    public static final String GRAPH_IS_LIMITED = "is graph limited";
    public static final String GRAPH_LEVELS_LIMIT = "limit number for graph levels";
    public static final String DATASETFLOW_LIMIT = "datasetflow threshold";
    public static final String DATASETFLOW_IS_LIMITED = "datesetflow is limited";
    public static final String GRAPH_WITHOUT_RESOURCES = "graph without resources";
    public static final String GRAPH_RESOURCES_STATES = "graph resources checked or not";
    private String selectedPath = "";

    public PrepareReportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public PrepareReportWizard(boolean containsOnlyApplicationsPage) {
        this();
        this.containsOnlyApplicationsPage = containsOnlyApplicationsPage;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public boolean performFinish() {
        this.canceled = false;
        if (this.getContainer().getCurrentPage() == this.getPage(TESTS_PAGE_NAME)) {
            this.selectedPath = ((SelectPathPage)this.getContainer().getCurrentPage()).getSelectedPath();
        } else if (this.containsOnlyApplicationsPage) {
            ((SelectApplicationPage)this.getPage(APPLICATIONS_PAGE_NAME)).setSelectedApplications();
        }
        return true;
    }

    public boolean performCancel() {
        this.canceled = true;
        return true;
    }

    public List getList(String property) {
        List ret = null;
        ret = (List)this.model.get(property);
        return ret;
    }

    public Map getMap(String property) {
        return (Map)this.model.get(property);
    }

    public Object getValue(String property) {
        return this.model.get(property);
    }

    public void set(String property, Object value) {
        this.model.put(property, value);
    }

    public void close() {
        this.model.clear();
        super.dispose();
    }

    public String[] getStringArray(String property) {
        return (String[])this.model.get(property);
    }

    public boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    public int getPageIndex(String name) {
        IWizardPage[] pages = this.getPages();
        int idx = -1;
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            String pageName = page.getName();
            if (pageName.equals(name)) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    public boolean getChangeDirection(IWizardPage fromPage, IWizardPage toPage) {
        boolean forward = true;
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page.equals(fromPage)) {
                forward = true;
                break;
            }
            if (page.equals(toPage)) {
                forward = false;
                break;
            }
            ++i;
        }
        return forward;
    }

    public void setChangeDirection(IWizardPage fromPage, IWizardPage toPage) {
        this.setForward(this.getChangeDirection(fromPage, toPage));
    }

    public boolean canFinish() {
        boolean ret = false;
        if (this.getContainer().getCurrentPage() == this.getPage(VARIABLE_SELECT_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(PATTERN_SEARCH_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(MFLIBRARIES_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(COMPARE_PROJECTS_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(COMPARE_APPLICATIONS_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(APPLICATIONS_PAGE_NAME) && this.containsOnlyApplicationsPage || this.getContainer().getCurrentPage() == this.getPage(EMPTY_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(JAVA_CLASSES_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(TESTS_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(PROGRAMS_PAGE_NAME) && this.getContainer().getCurrentPage().getNextPage() == this.getPage(TESTS_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(PROGRAMS_PAGE_NAME) && this.getContainer().getCurrentPage().getNextPage() == this.getPage(EXCLUDE_DATASETS_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(GATHERING_SOURCES_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(EXCLUDE_DATASETS_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(SINGLE_PROGRAM_PAGE_NAME) && this.getAssemblerSelected() == null || this.getContainer().getCurrentPage() == this.getPage(PROGRAMS_FOR_CALLGRAPH_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(SINGLE_ASSEMBLER_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(ASSEMBLER_CHILDREN_FOR_CALLGRAPH_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage(NO_DB_RESOURCES_PAGE_NAME) && this.getContainer().getCurrentPage().getNextPage() == null || this.getContainer().getCurrentPage() == this.getPage(DDCL_ELEMENTS_FOR_APPLICATION_MASTER_PAGE)) {
            ret = this.getContainer().getCurrentPage().isPageComplete();
        }
        return ret;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (next != null && (ASSEMBLER_CHILDREN_FOR_CALLGRAPH_PAGE_NAME.equals(next.getName()) || SINGLE_ASSEMBLER_PAGE_NAME.equals(next.getName()))) {
            Set<String> assPrg = this.getAssemblerSelected();
            if (assPrg == null || assPrg.isEmpty()) {
                next = null;
                this.set(SELECTED_ASS_RESOURCES, null);
            } else {
                ProgramsParamCollector collector = (ProgramsParamCollector)((SelectAbstractProgramsPage)next).getResourcesCollector();
                collector.setParameters(assPrg);
            }
        }
        return next;
    }

    public void runLongOperation(LongOperation operation) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (Exception t) {
            L.error("error executing long running operation: {}", (Object)operation, (Object)t);
        }
    }

    protected boolean buttonPressed(int buttonId) {
        return true;
    }

    public boolean cancelPressed() {
        return true;
    }

    public Map<String, Object> getValues() {
        return this.model;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public boolean getProjectIsUCMDB() {
        return this.projectIsUCMDB;
    }

    public void setProjectIsUCMDB(boolean projectIsUCMDB) {
        this.projectIsUCMDB = projectIsUCMDB;
    }

    public int getProjectDatabaseEngine() {
        return this.projectDatabaseEngine;
    }

    public void setProjectDatabaseEngine(int projectDbEngine) {
        this.projectDatabaseEngine = projectDbEngine;
    }

    private Set<String> getAssemblerSelected() {
        List selected = this.getList("selected resources");
        if (selected != null && !selected.isEmpty()) {
            HashSet<String> assemblers = null;
            for (Object o : selected) {
                ProgramInput pi = null;
                pi = o instanceof BaseMainframeResource4GUI ? (ProgramInput)((BaseMainframeResource4GUI)((Object)o)).getObject() : (ProgramInput)((Object)o);
                Integer type = pi.getTypeCode();
                if (type != 8) continue;
                if (assemblers == null) {
                    assemblers = new HashSet<String>();
                }
                assemblers.add(pi.getName());
            }
            return assemblers;
        }
        return null;
    }

    public static abstract class LongOperation
    implements IRunnableWithProgress {
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.runOperation(monitor);
            }
            catch (EZSourceNativeException t) {
                L.error("ADBuildNativeException executing long running operation: {}", (Object)this, (Object)t);
                String msg = t.getMessage();
                Wizard wizard = this.getWizard();
                Display.getDefault().syncExec((Runnable)new DisplayErrMsg(msg, wizard));
            }
            catch (Exception t) {
                L.error("error executing long running operation: {}", (Object)this, (Object)t);
                String msg = t.getMessage();
                Wizard wizard = this.getWizard();
                Display.getDefault().syncExec((Runnable)new DisplayErrMsg(msg, wizard));
            }
        }

        public abstract Wizard getWizard();

        public abstract void runOperation(IProgressMonitor var1) throws Exception;

        class DisplayErrMsg
        implements Runnable {
            private String msg;
            private Wizard wizard;

            public DisplayErrMsg(String msg, Wizard wizard) {
                this.msg = msg;
                this.wizard = wizard;
            }

            @Override
            public void run() {
                if (this.wizard != null) {
                    Object[] msgParam = new String[]{this.msg};
                    String errMsg = Messages.getString(PrepareReportWizard.class, "unspecified.open.error", msgParam);
                    IWizardPage currentPage = this.wizard.getContainer().getCurrentPage();
                    ((WizardPage)currentPage).setErrorMessage(errMsg);
                }
            }
        }
    }
}

