/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.wizard;

import com.ez.mainframe.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWizardPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractWizardPage.class);
    protected PrepareReportWizard wizard = null;
    protected boolean useFilters = false;
    protected boolean useImport = false;
    protected boolean showReportsOptionGroup = false;
    protected boolean showGenerateSummary = false;
    protected Button btnSummary;
    protected Button btnAppendix;
    public static final String RESOURCE_TYPE = "resource_type";
    private Group optionsGroup;
    protected boolean showInputsOption = false;
    protected Button btnShowInputs;
    protected String optionLabel = Messages.getString(AbstractWizardPage.class, "showInputsInAppendix.lbl");
    protected boolean optionValue = false;
    protected boolean showOption1 = false;
    protected Button btnOpt1;
    protected String lblOption1 = Messages.getString(AbstractWizardPage.class, "showImages.lbl");
    protected String option1PropName = "hide images";
    protected String optionPropName = "showInputDetails";
    public static final String HIDE_IMAGES = "hide images";

    protected AbstractWizardPage(String pageName) {
        super(pageName);
    }

    protected void init(IProgressMonitor monitor) {
    }

    public void createControl(Composite parent) {
        this.wizard = (PrepareReportWizard)this.getWizard();
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        GridData gd = new GridData(4, 4, true, true);
        scrolledComposite.setLayoutData((Object)gd);
        final Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createContent(composite);
        this.wizard.set("show summary only", Boolean.FALSE);
        if (this.showReportsOptionGroup) {
            this.createSummaryGroup(composite);
        }
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point size = composite.computeSize(-1, -1);
                scrolledComposite.setMinSize(size);
                scrolledComposite.layout();
            }
        });
        this.setControl((Control)scrolledComposite);
    }

    protected abstract void createContent(Composite var1);

    protected void createSummaryGroup(Composite parent) {
        Group optionsGroup = this.getReportOptionsGroup(parent);
        this.btnAppendix = new Button((Composite)optionsGroup, 32);
        this.btnAppendix.setText(Messages.getString(AbstractWizardPage.class, "showAppendix.lbl"));
        this.btnAppendix.setSelection(this.getShowAppendixValue());
        this.checkAppendix();
        this.btnAppendix.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractWizardPage.this.checkAppendix();
            }
        });
        GridData data = new GridData();
        data.horizontalAlignment = 1;
        data.verticalAlignment = 3;
        data.grabExcessVerticalSpace = true;
        this.btnAppendix.setLayoutData((Object)data);
        this.addShowAppendixOptions((Composite)optionsGroup);
        if (this.showGenerateSummary) {
            this.btnSummary = new Button((Composite)optionsGroup, 32);
            this.btnSummary.setText(Messages.getString(AbstractWizardPage.class, "showSummary.lbl"));
            this.btnSummary.setEnabled(false);
            this.btnSummary.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AbstractWizardPage.this.checkOnlySummary();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 1;
            data.verticalAlignment = 3;
            data.grabExcessVerticalSpace = true;
            this.btnSummary.setLayoutData((Object)data);
        }
    }

    protected boolean getShowAppendixValue() {
        return true;
    }

    protected void addShowAppendixOptions(Composite optionsGroup) {
    }

    protected void defaultAddAppendixOptions(Composite optionsGroup) {
        GridData data;
        if (this.showInputsOption) {
            this.btnShowInputs = new Button(optionsGroup, 32);
            this.btnShowInputs.setText(this.optionLabel);
            this.btnShowInputs.setSelection(this.optionValue);
            this.btnShowInputs.setEnabled(this.btnAppendix.getSelection());
            this.checkShowInputs();
            this.btnShowInputs.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AbstractWizardPage.this.checkShowInputs();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 1;
            data.verticalAlignment = 3;
            data.grabExcessVerticalSpace = true;
            data.horizontalIndent = 20;
            this.btnShowInputs.setLayoutData((Object)data);
        }
        if (this.showOption1) {
            this.btnOpt1 = new Button(optionsGroup, 32);
            this.btnOpt1.setText(this.lblOption1);
            this.btnOpt1.setSelection(this.showOption1);
            this.btnOpt1.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = AbstractWizardPage.this.btnOpt1.getSelection();
                    AbstractWizardPage.this.wizard.set(AbstractWizardPage.this.option1PropName, selected);
                }
            });
            data = new GridData();
            data.horizontalAlignment = 4;
            data.horizontalSpan = 2;
            data.verticalAlignment = 3;
            data.grabExcessVerticalSpace = true;
            this.btnOpt1.setLayoutData((Object)data);
        }
    }

    protected void refreshCheckBoxes(boolean enableButtons) {
        if (this.showGenerateSummary) {
            if (enableButtons) {
                this.btnSummary.setEnabled(true);
            } else {
                this.btnSummary.setEnabled(false);
            }
        }
    }

    public boolean isUseFilters() {
        return this.useFilters;
    }

    public void setUseFilters(boolean useFilters) {
        this.useFilters = useFilters;
    }

    public boolean isUseImport() {
        return this.useImport;
    }

    public void setUseImport(boolean useImport) {
        this.useImport = useImport;
    }

    public boolean isShowGenerateSummary() {
        return this.showGenerateSummary;
    }

    protected Group getReportOptionsGroup(Composite parent) {
        if (this.optionsGroup == null) {
            Composite fakeParent = new Composite(parent, parent.getStyle());
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = false;
            data.horizontalAlignment = 0x1000008;
            data.verticalAlignment = 0x1000008;
            fakeParent.setLayoutData((Object)data);
            GridLayout gl = new GridLayout(2, false);
            gl.marginRight = 5;
            fakeParent.setLayout((Layout)gl);
            this.optionsGroup = new Group(fakeParent, 0);
            this.optionsGroup.setText(Messages.getString(AbstractWizardPage.class, "generationOptions.lbl"));
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 0x1000008;
            data.verticalAlignment = 0x1000008;
            this.optionsGroup.setLayoutData((Object)data);
            gl = new GridLayout();
            this.optionsGroup.setLayout((Layout)gl);
        }
        return this.optionsGroup;
    }

    protected void checkOnlySummary() {
        boolean selected = this.btnSummary.getSelection();
        this.wizard.set("show summary only", selected);
    }

    protected void checkAppendix() {
        boolean showAppendix = this.btnAppendix.getSelection();
        this.wizard.set("show appendix", showAppendix);
    }

    protected void checkShowInputs() {
        boolean selected = this.btnShowInputs.getSelection();
        this.wizard.set(this.optionPropName, selected);
    }

    public void setOptionLabel(String text) {
        if (text != null && !text.isEmpty()) {
            this.lblOption1 = text;
        } else {
            L.warn("cannot set a null text");
        }
    }

    public void setOption1PropName(String propName) {
        if (propName != null && !propName.isEmpty()) {
            this.option1PropName = propName;
        } else {
            L.warn("cannot set a null property");
        }
    }
}

