/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.InputsCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSAMFileCollector
extends InputsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(VSAMFileCollector.class);

    @Override
    public List<BaseResourceInput4GUI> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<BaseResourceInput4GUI> resources = new ArrayList<BaseResourceInput4GUI>();
        try {
            String[][] results = conn.executeSQL(this.resourcesQuery);
            if (results != null && results.length > 0) {
                this.createObjects(resources, results);
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return resources;
    }

    protected void createObjects(List<BaseResourceInput4GUI> resources, String[][] results) {
        int i = 0;
        while (i < results.length) {
            String[] result = results[i];
            String id = result[0];
            String name = result[1];
            String number = null;
            if (i + 1 < results.length && results[i + 1][1].equalsIgnoreCase(name) || i - 1 >= 0 && results[i - 1][1].equalsIgnoreCase(name)) {
                number = result[2];
            }
            VSAMInput inpt = new VSAMInput(name, Integer.valueOf(id), number != null ? Integer.valueOf(number) : null, null);
            resources.add(new BaseMainframeResource4GUI((BaseResourceInput)inpt));
            ++i;
        }
    }
}

