/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.report.application.model.ScreenInput;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenCollector
extends BridgeResourcesCollectorAdapter<ScreenInput> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ScreenCollector.class);
    private String queryName;
    private boolean occurIdPositive = false;
    private static List<ImageObj4Wizard> imagesObjsList;

    public ScreenCollector(boolean occurIdPositive) {
        this.occurIdPositive = occurIdPositive;
    }

    @Override
    public List<ScreenInput> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<ScreenInput> screensList = new ArrayList<ScreenInput>();
        imagesObjsList = new ArrayList<ImageObj4Wizard>();
        try {
            Object[] params = new Integer[]{this.occurIdPositive ? 1 : 0};
            String[][] queryResult = conn.execNonTransactionalStoredProc(this.queryName, params);
            ArrayList<Integer> screenTypes = new ArrayList<Integer>();
            if (queryResult != null && queryResult.length > 0) {
                String[][] stringArray = queryResult;
                int n = queryResult.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] screenFromDb = stringArray[n2];
                    String screenName = screenFromDb[0];
                    String mapSetName = "";
                    Integer screenID = Integer.valueOf(screenFromDb[4]);
                    int screenType = Integer.valueOf(screenFromDb[3]);
                    if (119 == screenType && com.ez.mainframe.data.utils.Utils.filterNullValue((String)(mapSetName = screenFromDb[2])) != null) {
                        screenName = mapSetName.concat("-").concat(screenName);
                    }
                    if (65 == screenType) {
                        mapSetName = screenName;
                    }
                    ScreenInput screen = new ScreenInput(screenID, screenName, screenType);
                    screen.setScreenName(screenFromDb[0]);
                    screen.setType(screenType);
                    screen.setMapSet(mapSetName);
                    screen.setOccurID(screenFromDb[1]);
                    screensList.add(screen);
                    if (!screenTypes.contains(screenType)) {
                        String textType = com.ez.mainframe.data.utils.Utils.getExternalizedType((Integer)screenType);
                        ImageDescriptor image_desc = Utils.getImageDescType(screenType);
                        ImageObj4Wizard imageObj = new ImageObj4Wizard(Integer.valueOf(screenType), textType, image_desc);
                        imagesObjsList.add(imageObj);
                        screenTypes.add(screenType);
                    }
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return screensList;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    @Override
    public List<ImageObj4Wizard> getAvailableImages() {
        return imagesObjsList;
    }
}

