/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import com.ez.report.application.ui.collectors.ProgramInputsFactory4Wizard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramsParamCollector
extends BridgeResourcesCollectorAdapter<ProgramInput> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramsParamCollector.class);
    private String programsQuery = null;
    private Set<String> parameters = null;
    private List<ImageObj4Wizard> availableImages;
    private boolean completeTempTblName = false;
    private String tblName;

    public void setProgramsQuery(String programsQuery) {
        this.programsQuery = programsQuery;
    }

    public void setParameters(Set<String> param) {
        this.parameters = param;
    }

    @Override
    public List<ProgramInput> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        boolean useApps;
        List resources = null;
        boolean bl = useApps = apps != null && !apps.isEmpty();
        if (this.availableImages != null) {
            this.availableImages.clear();
        }
        try {
            if (useApps) {
                resources = null;
            } else {
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[this.parameters.size()]);
                Collections.fill(types, EZSourceDataType.String);
                if (this.completeTempTblName) {
                    Assert.isNotNull((Object)this.tblName);
                    this.programsQuery = this.programsQuery.replaceAll(this.tblName, Utils.getTempTableName((EZSourceConnection)conn, (String)this.tblName));
                    this.completeTempTblName = false;
                }
                String[][] programs = conn.executeSQL(this.programsQuery, types, new ArrayList<String>(this.parameters));
                ProgramInputsFactory4Wizard factory = ProgramInputsFactory4Wizard.getInstance();
                resources = factory.buildProgramInputs(programs, true);
                this.availableImages = factory.getAvailableImages();
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return resources;
    }

    @Override
    public List<ImageObj4Wizard> getAvailableImages() {
        return this.availableImages;
    }

    public void completeTempTableName(String tempTblName, boolean complete) {
        this.tblName = tempTblName;
        this.completeTempTblName = complete;
    }
}

