/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import com.ez.report.application.ui.collectors.ProgramInputsFactory4Wizard;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramsCollector
extends BridgeResourcesCollectorAdapter<ProgramInput> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgramsCollector.class);
    private String programsForAppQuery = null;
    private String programsQuery = null;
    private String viewName = null;
    private List<ImageObj4Wizard> availableImages;

    public void setProgramsQuery(String programsQuery, String viewName) {
        this.setProgramsQuery(programsQuery);
        this.viewName = viewName;
    }

    public void setProgramsQuery(String programsQuery) {
        this.programsQuery = programsQuery;
    }

    public void setProgramsForAppQuery(String query) {
        this.programsForAppQuery = query;
    }

    @Override
    public List<ProgramInput> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ProgramInputsFactory4Wizard factory;
        boolean useApps;
        List resources;
        block6: {
            resources = null;
            boolean bl = useApps = apps != null && !apps.isEmpty();
            if (this.availableImages != null) {
                this.availableImages.clear();
            }
            factory = ProgramInputsFactory4Wizard.getInstance();
            boolean preparedCache = this.prepareCacheIfNecessary(this.viewName, conn);
            if (preparedCache) break block6;
            L.warn("Cache not prepared. Retry later.");
            return null;
        }
        try {
            if (useFilters) {
                resources = useApps ? factory.getAvailableProgramsWithTypesForApp(conn, this.programsForAppQuery, apps) : factory.getProgramsWithTypes(this.programsQuery, conn);
                this.availableImages = factory.getAvailableImages();
            } else {
                resources = useApps ? factory.getAvailableProgramsForApp(this.programsForAppQuery, apps, conn) : factory.getAvailablePrograms(this.programsQuery, conn);
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return resources;
    }

    @Override
    public List<ImageObj4Wizard> getAvailableImages() {
        return this.availableImages;
    }
}

