/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.ItemType;
import com.ez.mainframe.data.utils.ProgramInputsFactory;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.report.application.model.PrgOrIncludeWithPathInput;
import com.ez.report.application.model.ProgramInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProgramInputsFactory4Wizard
extends ProgramInputsFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static List<ImageObj4Wizard> imagesObjsList = new ArrayList<ImageObj4Wizard>();
    List<ItemType> availableTypes;

    public static ProgramInputsFactory4Wizard getInstance() {
        if (_INSTANCE == null) {
            ProgramInputsFactory4Wizard.instantiator();
        }
        return (ProgramInputsFactory4Wizard)_INSTANCE;
    }

    protected static void instantiator() {
        _INSTANCE = new ProgramInputsFactory4Wizard();
        _INSTANCE.setHasImages(true);
    }

    protected void init() {
        this.availableTypes = new ArrayList<ItemType>();
        imagesObjsList.clear();
    }

    protected void buildImages4Wizard(boolean considerAssChildren, Integer prgType) {
        ItemType wizType = ItemType.getItemType((Integer)prgType, (boolean)considerAssChildren);
        if (!this.availableTypes.contains(wizType)) {
            String textType = com.ez.mainframe.data.utils.Utils.getExternalizedType((Integer)prgType, (!considerAssChildren ? 1 : 0) != 0);
            ImageDescriptor image_desc = Utils.getImageDescType(prgType, !considerAssChildren);
            ImageObj4Wizard imageObj = new ImageObj4Wizard(wizType, textType, image_desc);
            this.availableTypes.add(wizType);
            imagesObjsList.add(imageObj);
        }
    }

    protected void buildImages4Wizard(Integer prgType, boolean bool) {
        ItemType wizType = ItemType.getItemType((Integer)prgType);
        if (!this.availableTypes.contains(wizType)) {
            String textType = com.ez.mainframe.data.utils.Utils.getExternalizedType((Integer)prgType, (boolean)bool);
            ImageDescriptor image_desc = Utils.getImageDescType(prgType, bool);
            ImageObj4Wizard imageObj = new ImageObj4Wizard(wizType, textType, image_desc);
            this.availableTypes.add(wizType);
            imagesObjsList.add(imageObj);
        }
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return imagesObjsList;
    }

    public List<ImageObj4Wizard> buildAvailableImagesFromTypes(Set<Integer> availableTypesForFilters) {
        return this.buildAvailableImagesFromTypes(availableTypesForFilters, false);
    }

    public List<ImageObj4Wizard> buildAvailableImagesFromTypes(Set<Integer> availableTypesForFilters, boolean considerAssChildren) {
        imagesObjsList.clear();
        for (Integer prgType : availableTypesForFilters) {
            ItemType type = ItemType.getItemType((Integer)prgType, (boolean)considerAssChildren);
            String textType = com.ez.mainframe.data.utils.Utils.getExternalizedType((Integer)prgType, (!considerAssChildren ? 1 : 0) != 0);
            ImageDescriptor image_desc = Utils.getImageDescType(prgType, !considerAssChildren);
            ImageObj4Wizard imageObj = new ImageObj4Wizard(type, textType, image_desc);
            imagesObjsList.add(imageObj);
        }
        return new ArrayList<ImageObj4Wizard>(imagesObjsList);
    }

    protected ProgramInput instantiateObj(String prgName, Integer prgType, Integer dbID, String path) {
        PrgOrIncludeWithPathInput inp = new PrgOrIncludeWithPathInput(prgName, prgType, dbID, path, null);
        inp.displayPath(true);
        return inp;
    }

    protected ProgramInput instantiateObj(String prgName) {
        return new ProgramInput(prgName);
    }
}

