/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.VSAMFileCollector;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleVSAMCollector
extends VSAMFileCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MultipleVSAMCollector.class);

    @Override
    protected void createObjects(List<BaseResourceInput4GUI> resources, String[][] results) {
        MultipleVSAMInput inpt = null;
        int i = 0;
        while (i < results.length) {
            boolean noMemberName;
            String[] result = results[i];
            String id = result[0];
            String name = result[1];
            String memberName = result[3];
            String number = result[2];
            Integer genNo = null;
            try {
                genNo = Integer.valueOf(number);
            }
            catch (NumberFormatException numberFormatException) {
                L.warn("dataset without generationNumber; id={}, name={}", (Object)id, (Object)name);
                genNo = new Integer(0);
            }
            String nextMemberName = i + 1 < results.length ? results[i + 1][3] : null;
            String prevMemberName = i - 1 >= 0 ? results[i - 1][3] : null;
            boolean bl = noMemberName = memberName == null || memberName.isEmpty();
            if (inpt != null && (i + 1 < results.length && results[i + 1][1].equalsIgnoreCase(name) && ((nextMemberName == null || nextMemberName.isEmpty()) && noMemberName || nextMemberName.equalsIgnoreCase(memberName)) || i - 1 >= 0 && results[i - 1][1].equalsIgnoreCase(name) && ((prevMemberName == null || prevMemberName.isEmpty()) && noMemberName || prevMemberName.equalsIgnoreCase(memberName)))) {
                if (inpt.getListableName().equalsIgnoreCase(this.getNameWithMember(name, memberName))) {
                    inpt.addInfo(Integer.valueOf(id), number);
                } else {
                    inpt = new MultipleVSAMInput(name, memberName, Integer.valueOf(id), genNo);
                    resources.add(new BaseMainframeResource4GUI((BaseResourceInput)inpt));
                }
            } else {
                Integer idAsInt = id != null ? Integer.valueOf(id) : null;
                inpt = new MultipleVSAMInput(name, memberName, idAsInt, genNo);
                resources.add(new BaseMainframeResource4GUI((BaseResourceInput)inpt));
            }
            ++i;
        }
    }

    private String getNameWithMember(String name, String memberName) {
        return String.valueOf(name) + (memberName != null && !memberName.isEmpty() ? "(" + memberName + ")" : "");
    }
}

