/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.ItemType;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDCLElementCollector
extends BridgeResourcesCollectorAdapter<DDCLElementInput> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DDCLElementCollector.class);
    private String viewName = null;
    private static List<ImageObj4Wizard> imagesObjsList;
    private Set parameters = null;
    private EZSourceDataType paramType = null;
    protected String resourcesQuery = null;

    public DDCLElementCollector() {
    }

    public DDCLElementCollector(String viewName) {
        this.viewName = viewName;
    }

    public void setResourcesQuery(String resourcesQuery) {
        this.resourcesQuery = resourcesQuery;
    }

    @Override
    public List<DDCLElementInput> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<DDCLElementInput> resources = new ArrayList<DDCLElementInput>();
        ArrayList<ItemType> availableTypes = new ArrayList<ItemType>();
        imagesObjsList = new ArrayList<ImageObj4Wizard>();
        try {
            boolean preparedCache;
            String[][] results = null;
            boolean bl = preparedCache = this.viewName == null;
            if (!preparedCache) {
                preparedCache = com.ez.mainframe.data.utils.Utils.prepareCache((EZSourceConnection)conn, (String)this.viewName, (IProgressMonitor)new NullProgressMonitor());
            }
            if (preparedCache) {
                if (this.parameters != null) {
                    List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[this.parameters.size()]);
                    EZSourceDataType type = this.paramType == null ? EZSourceDataType.String : this.paramType;
                    Collections.fill(types, type);
                    results = conn.executeSQL(this.resourcesQuery, types, new ArrayList(this.parameters));
                } else {
                    results = conn.executeSQL(this.resourcesQuery);
                }
                if (results != null && results.length > 0) {
                    String[][] stringArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] result = stringArray[n2];
                        Integer resourceID = Integer.valueOf(result[0]);
                        String resourceName = result[1];
                        Integer resourceType = Integer.valueOf(result[2]);
                        DDCLElementInput res = new DDCLElementInput(resourceName, resourceType, resourceID);
                        resources.add(res);
                        ItemType wizType = new ItemType(resourceType);
                        if (!availableTypes.contains(wizType)) {
                            String textType = com.ez.mainframe.data.utils.Utils.getExternalizedType4DDCLComponent((Integer)resourceType);
                            ImageDescriptor image_desc = Utils.getImageDescType4DDCLElements(resourceType);
                            ImageObj4Wizard imageObj = new ImageObj4Wizard(wizType, textType, image_desc);
                            availableTypes.add(wizType);
                            imagesObjsList.add(imageObj);
                        }
                        ++n2;
                    }
                }
            } else {
                L.warn("Cache already in progress. Retry later.");
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return resources;
    }

    @Override
    public List<ImageObj4Wizard> getAvailableImages() {
        return imagesObjsList;
    }

    public void setParameters(Set ids, EZSourceDataType paramType) {
        this.parameters = ids;
        this.paramType = paramType;
    }
}

