/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.ui.listselection.Listable;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.ui.collectors.CacheableResourcesCollector;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class BridgeResourcesCollectorAdapter<T extends Listable>
implements CacheableResourcesCollector<T> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    @Override
    public List<T> collect(final boolean useFilters, final Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)100);
        List ret = null;
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(prjName, null);
        ResourcesRunnable rr = new ResourcesRunnable(this){

            public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                this.resources = this.collect(useFilters, apps, conn);
            }
        };
        ph.executeWithLock(ph, (IMFRunnable)rr, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
        ret = rr.resources;
        return ret;
    }

    protected abstract List<T> collect(boolean var1, Set<String> var2, EZSourceConnection var3);

    @Override
    public boolean prepareCacheIfNecessary(String viewName, EZSourceConnection conn) {
        boolean preparedCache;
        boolean bl = preparedCache = viewName == null;
        if (!preparedCache) {
            preparedCache = Utils.prepareCache((EZSourceConnection)conn, (String)viewName, (IProgressMonitor)new NullProgressMonitor());
        }
        return preparedCache;
    }

    private abstract class ResourcesRunnable
    implements IMFRunnable {
        public List<T> resources = null;

        private ResourcesRunnable() {
        }
    }
}

