/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.report.application.model.AAutoNetwork;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AAutoNetworkCollector
extends BridgeResourcesCollectorAdapter<AAutoNetwork> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AAutoNetworkCollector.class);
    private static final String ALL_AAUTO_NETWORKS_QUERY = "select NetworkID, NetworkName, NetwkExpandedName from AAUTONetworks ";
    private String resourcesQuery;

    @Override
    public List<AAutoNetwork> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        this.resourcesQuery = ALL_AAUTO_NETWORKS_QUERY;
        ArrayList<AAutoNetwork> networkList = null;
        try {
            String[][] results = conn.executeSQL(this.resourcesQuery);
            if (results != null && results.length > 0) {
                networkList = new ArrayList<AAutoNetwork>();
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    Integer networkid = Integer.valueOf(result[0]);
                    String networkName = result[1];
                    String netwkExpandedName = result[2];
                    AAutoNetwork network = new AAutoNetwork(networkid, networkName, netwkExpandedName);
                    networkList.add(network);
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return networkList;
    }

    @Override
    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }
}

